/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkMemoryMapPlacedInfoEXT
extends Struct<VkMemoryMapPlacedInfoEXT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int PPLACEDADDRESS;

    protected VkMemoryMapPlacedInfoEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkMemoryMapPlacedInfoEXT create(long address, @Nullable ByteBuffer container) {
        return new VkMemoryMapPlacedInfoEXT(address, container);
    }

    public VkMemoryMapPlacedInfoEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkMemoryMapPlacedInfoEXT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkMemoryMapPlacedInfoEXT.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkMemoryMapPlacedInfoEXT.npNext(this.address());
    }

    @NativeType(value="void *")
    public long pPlacedAddress() {
        return VkMemoryMapPlacedInfoEXT.npPlacedAddress(this.address());
    }

    public VkMemoryMapPlacedInfoEXT sType(@NativeType(value="VkStructureType") int value) {
        VkMemoryMapPlacedInfoEXT.nsType(this.address(), value);
        return this;
    }

    public VkMemoryMapPlacedInfoEXT sType$Default() {
        return this.sType(1000272002);
    }

    public VkMemoryMapPlacedInfoEXT pNext(@NativeType(value="void const *") long value) {
        VkMemoryMapPlacedInfoEXT.npNext(this.address(), value);
        return this;
    }

    public VkMemoryMapPlacedInfoEXT pPlacedAddress(@NativeType(value="void *") long value) {
        VkMemoryMapPlacedInfoEXT.npPlacedAddress(this.address(), value);
        return this;
    }

    public VkMemoryMapPlacedInfoEXT set(int sType, long pNext, long pPlacedAddress) {
        this.sType(sType);
        this.pNext(pNext);
        this.pPlacedAddress(pPlacedAddress);
        return this;
    }

    public VkMemoryMapPlacedInfoEXT set(VkMemoryMapPlacedInfoEXT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkMemoryMapPlacedInfoEXT malloc() {
        return new VkMemoryMapPlacedInfoEXT(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkMemoryMapPlacedInfoEXT calloc() {
        return new VkMemoryMapPlacedInfoEXT(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkMemoryMapPlacedInfoEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkMemoryMapPlacedInfoEXT(MemoryUtil.memAddress(container), container);
    }

    public static VkMemoryMapPlacedInfoEXT create(long address) {
        return new VkMemoryMapPlacedInfoEXT(address, null);
    }

    public static @Nullable VkMemoryMapPlacedInfoEXT createSafe(long address) {
        return address == 0L ? null : new VkMemoryMapPlacedInfoEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkMemoryMapPlacedInfoEXT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkMemoryMapPlacedInfoEXT.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkMemoryMapPlacedInfoEXT malloc(MemoryStack stack) {
        return new VkMemoryMapPlacedInfoEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkMemoryMapPlacedInfoEXT calloc(MemoryStack stack) {
        return new VkMemoryMapPlacedInfoEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static long npPlacedAddress(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PPLACEDADDRESS);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void npPlacedAddress(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PPLACEDADDRESS, value);
    }

    static {
        Struct.Layout layout = VkMemoryMapPlacedInfoEXT.__struct(VkMemoryMapPlacedInfoEXT.__member(4), VkMemoryMapPlacedInfoEXT.__member(POINTER_SIZE), VkMemoryMapPlacedInfoEXT.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        PPLACEDADDRESS = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkMemoryMapPlacedInfoEXT, Buffer>
    implements NativeResource {
        private static final VkMemoryMapPlacedInfoEXT ELEMENT_FACTORY = VkMemoryMapPlacedInfoEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkMemoryMapPlacedInfoEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkMemoryMapPlacedInfoEXT.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkMemoryMapPlacedInfoEXT.npNext(this.address());
        }

        @NativeType(value="void *")
        public long pPlacedAddress() {
            return VkMemoryMapPlacedInfoEXT.npPlacedAddress(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkMemoryMapPlacedInfoEXT.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000272002);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkMemoryMapPlacedInfoEXT.npNext(this.address(), value);
            return this;
        }

        public Buffer pPlacedAddress(@NativeType(value="void *") long value) {
            VkMemoryMapPlacedInfoEXT.npPlacedAddress(this.address(), value);
            return this;
        }
    }
}

