/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkExtent3D;
import org.lwjgl.vulkan.VkImageSubresourceLayers;
import org.lwjgl.vulkan.VkOffset3D;

public class VkMemoryToImageCopy
extends Struct<VkMemoryToImageCopy>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int PHOSTPOINTER;
    public static final int MEMORYROWLENGTH;
    public static final int MEMORYIMAGEHEIGHT;
    public static final int IMAGESUBRESOURCE;
    public static final int IMAGEOFFSET;
    public static final int IMAGEEXTENT;

    protected VkMemoryToImageCopy(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkMemoryToImageCopy create(long address, @Nullable ByteBuffer container) {
        return new VkMemoryToImageCopy(address, container);
    }

    public VkMemoryToImageCopy(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkMemoryToImageCopy.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkMemoryToImageCopy.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkMemoryToImageCopy.npNext(this.address());
    }

    @NativeType(value="void const *")
    public long pHostPointer() {
        return VkMemoryToImageCopy.npHostPointer(this.address());
    }

    @NativeType(value="uint32_t")
    public int memoryRowLength() {
        return VkMemoryToImageCopy.nmemoryRowLength(this.address());
    }

    @NativeType(value="uint32_t")
    public int memoryImageHeight() {
        return VkMemoryToImageCopy.nmemoryImageHeight(this.address());
    }

    public VkImageSubresourceLayers imageSubresource() {
        return VkMemoryToImageCopy.nimageSubresource(this.address());
    }

    public VkOffset3D imageOffset() {
        return VkMemoryToImageCopy.nimageOffset(this.address());
    }

    public VkExtent3D imageExtent() {
        return VkMemoryToImageCopy.nimageExtent(this.address());
    }

    public VkMemoryToImageCopy sType(@NativeType(value="VkStructureType") int value) {
        VkMemoryToImageCopy.nsType(this.address(), value);
        return this;
    }

    public VkMemoryToImageCopy sType$Default() {
        return this.sType(1000270002);
    }

    public VkMemoryToImageCopy pNext(@NativeType(value="void const *") long value) {
        VkMemoryToImageCopy.npNext(this.address(), value);
        return this;
    }

    public VkMemoryToImageCopy pHostPointer(@NativeType(value="void const *") long value) {
        VkMemoryToImageCopy.npHostPointer(this.address(), value);
        return this;
    }

    public VkMemoryToImageCopy memoryRowLength(@NativeType(value="uint32_t") int value) {
        VkMemoryToImageCopy.nmemoryRowLength(this.address(), value);
        return this;
    }

    public VkMemoryToImageCopy memoryImageHeight(@NativeType(value="uint32_t") int value) {
        VkMemoryToImageCopy.nmemoryImageHeight(this.address(), value);
        return this;
    }

    public VkMemoryToImageCopy imageSubresource(VkImageSubresourceLayers value) {
        VkMemoryToImageCopy.nimageSubresource(this.address(), value);
        return this;
    }

    public VkMemoryToImageCopy imageSubresource(Consumer<VkImageSubresourceLayers> consumer) {
        consumer.accept(this.imageSubresource());
        return this;
    }

    public VkMemoryToImageCopy imageOffset(VkOffset3D value) {
        VkMemoryToImageCopy.nimageOffset(this.address(), value);
        return this;
    }

    public VkMemoryToImageCopy imageOffset(Consumer<VkOffset3D> consumer) {
        consumer.accept(this.imageOffset());
        return this;
    }

    public VkMemoryToImageCopy imageExtent(VkExtent3D value) {
        VkMemoryToImageCopy.nimageExtent(this.address(), value);
        return this;
    }

    public VkMemoryToImageCopy imageExtent(Consumer<VkExtent3D> consumer) {
        consumer.accept(this.imageExtent());
        return this;
    }

    public VkMemoryToImageCopy set(int sType, long pNext, long pHostPointer, int memoryRowLength, int memoryImageHeight, VkImageSubresourceLayers imageSubresource, VkOffset3D imageOffset, VkExtent3D imageExtent) {
        this.sType(sType);
        this.pNext(pNext);
        this.pHostPointer(pHostPointer);
        this.memoryRowLength(memoryRowLength);
        this.memoryImageHeight(memoryImageHeight);
        this.imageSubresource(imageSubresource);
        this.imageOffset(imageOffset);
        this.imageExtent(imageExtent);
        return this;
    }

    public VkMemoryToImageCopy set(VkMemoryToImageCopy src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkMemoryToImageCopy malloc() {
        return new VkMemoryToImageCopy(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkMemoryToImageCopy calloc() {
        return new VkMemoryToImageCopy(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkMemoryToImageCopy create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkMemoryToImageCopy(MemoryUtil.memAddress(container), container);
    }

    public static VkMemoryToImageCopy create(long address) {
        return new VkMemoryToImageCopy(address, null);
    }

    public static @Nullable VkMemoryToImageCopy createSafe(long address) {
        return address == 0L ? null : new VkMemoryToImageCopy(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkMemoryToImageCopy.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkMemoryToImageCopy.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkMemoryToImageCopy malloc(MemoryStack stack) {
        return new VkMemoryToImageCopy(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkMemoryToImageCopy calloc(MemoryStack stack) {
        return new VkMemoryToImageCopy(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static long npHostPointer(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PHOSTPOINTER);
    }

    public static int nmemoryRowLength(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MEMORYROWLENGTH);
    }

    public static int nmemoryImageHeight(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MEMORYIMAGEHEIGHT);
    }

    public static VkImageSubresourceLayers nimageSubresource(long struct) {
        return VkImageSubresourceLayers.create(struct + (long)IMAGESUBRESOURCE);
    }

    public static VkOffset3D nimageOffset(long struct) {
        return VkOffset3D.create(struct + (long)IMAGEOFFSET);
    }

    public static VkExtent3D nimageExtent(long struct) {
        return VkExtent3D.create(struct + (long)IMAGEEXTENT);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void npHostPointer(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PHOSTPOINTER, Checks.check(value));
    }

    public static void nmemoryRowLength(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MEMORYROWLENGTH, value);
    }

    public static void nmemoryImageHeight(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MEMORYIMAGEHEIGHT, value);
    }

    public static void nimageSubresource(long struct, VkImageSubresourceLayers value) {
        MemoryUtil.memCopy(value.address(), struct + (long)IMAGESUBRESOURCE, VkImageSubresourceLayers.SIZEOF);
    }

    public static void nimageOffset(long struct, VkOffset3D value) {
        MemoryUtil.memCopy(value.address(), struct + (long)IMAGEOFFSET, VkOffset3D.SIZEOF);
    }

    public static void nimageExtent(long struct, VkExtent3D value) {
        MemoryUtil.memCopy(value.address(), struct + (long)IMAGEEXTENT, VkExtent3D.SIZEOF);
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PHOSTPOINTER));
    }

    static {
        Struct.Layout layout = VkMemoryToImageCopy.__struct(VkMemoryToImageCopy.__member(4), VkMemoryToImageCopy.__member(POINTER_SIZE), VkMemoryToImageCopy.__member(POINTER_SIZE), VkMemoryToImageCopy.__member(4), VkMemoryToImageCopy.__member(4), VkMemoryToImageCopy.__member(VkImageSubresourceLayers.SIZEOF, VkImageSubresourceLayers.ALIGNOF), VkMemoryToImageCopy.__member(VkOffset3D.SIZEOF, VkOffset3D.ALIGNOF), VkMemoryToImageCopy.__member(VkExtent3D.SIZEOF, VkExtent3D.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        PHOSTPOINTER = layout.offsetof(2);
        MEMORYROWLENGTH = layout.offsetof(3);
        MEMORYIMAGEHEIGHT = layout.offsetof(4);
        IMAGESUBRESOURCE = layout.offsetof(5);
        IMAGEOFFSET = layout.offsetof(6);
        IMAGEEXTENT = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<VkMemoryToImageCopy, Buffer>
    implements NativeResource {
        private static final VkMemoryToImageCopy ELEMENT_FACTORY = VkMemoryToImageCopy.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkMemoryToImageCopy getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkMemoryToImageCopy.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkMemoryToImageCopy.npNext(this.address());
        }

        @NativeType(value="void const *")
        public long pHostPointer() {
            return VkMemoryToImageCopy.npHostPointer(this.address());
        }

        @NativeType(value="uint32_t")
        public int memoryRowLength() {
            return VkMemoryToImageCopy.nmemoryRowLength(this.address());
        }

        @NativeType(value="uint32_t")
        public int memoryImageHeight() {
            return VkMemoryToImageCopy.nmemoryImageHeight(this.address());
        }

        public VkImageSubresourceLayers imageSubresource() {
            return VkMemoryToImageCopy.nimageSubresource(this.address());
        }

        public VkOffset3D imageOffset() {
            return VkMemoryToImageCopy.nimageOffset(this.address());
        }

        public VkExtent3D imageExtent() {
            return VkMemoryToImageCopy.nimageExtent(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkMemoryToImageCopy.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000270002);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkMemoryToImageCopy.npNext(this.address(), value);
            return this;
        }

        public Buffer pHostPointer(@NativeType(value="void const *") long value) {
            VkMemoryToImageCopy.npHostPointer(this.address(), value);
            return this;
        }

        public Buffer memoryRowLength(@NativeType(value="uint32_t") int value) {
            VkMemoryToImageCopy.nmemoryRowLength(this.address(), value);
            return this;
        }

        public Buffer memoryImageHeight(@NativeType(value="uint32_t") int value) {
            VkMemoryToImageCopy.nmemoryImageHeight(this.address(), value);
            return this;
        }

        public Buffer imageSubresource(VkImageSubresourceLayers value) {
            VkMemoryToImageCopy.nimageSubresource(this.address(), value);
            return this;
        }

        public Buffer imageSubresource(Consumer<VkImageSubresourceLayers> consumer) {
            consumer.accept(this.imageSubresource());
            return this;
        }

        public Buffer imageOffset(VkOffset3D value) {
            VkMemoryToImageCopy.nimageOffset(this.address(), value);
            return this;
        }

        public Buffer imageOffset(Consumer<VkOffset3D> consumer) {
            consumer.accept(this.imageOffset());
            return this;
        }

        public Buffer imageExtent(VkExtent3D value) {
            VkMemoryToImageCopy.nimageExtent(this.address(), value);
            return this;
        }

        public Buffer imageExtent(Consumer<VkExtent3D> consumer) {
            consumer.accept(this.imageExtent());
            return this;
        }
    }
}

