/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkExtent3D;
import org.lwjgl.vulkan.VkImageSubresourceLayers;
import org.lwjgl.vulkan.VkMemoryToImageCopy;
import org.lwjgl.vulkan.VkOffset3D;

public class VkMemoryToImageCopyEXT
extends VkMemoryToImageCopy {
    protected VkMemoryToImageCopyEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkMemoryToImageCopyEXT create(long address, @Nullable ByteBuffer container) {
        return new VkMemoryToImageCopyEXT(address, container);
    }

    public VkMemoryToImageCopyEXT(ByteBuffer container) {
        super(container);
    }

    @Override
    public VkMemoryToImageCopyEXT sType(@NativeType(value="VkStructureType") int value) {
        VkMemoryToImageCopyEXT.nsType(this.address(), value);
        return this;
    }

    @Override
    public VkMemoryToImageCopyEXT sType$Default() {
        return this.sType(1000270002);
    }

    @Override
    public VkMemoryToImageCopyEXT pNext(@NativeType(value="void const *") long value) {
        VkMemoryToImageCopyEXT.npNext(this.address(), value);
        return this;
    }

    @Override
    public VkMemoryToImageCopyEXT pHostPointer(@NativeType(value="void const *") long value) {
        VkMemoryToImageCopyEXT.npHostPointer(this.address(), value);
        return this;
    }

    @Override
    public VkMemoryToImageCopyEXT memoryRowLength(@NativeType(value="uint32_t") int value) {
        VkMemoryToImageCopyEXT.nmemoryRowLength(this.address(), value);
        return this;
    }

    @Override
    public VkMemoryToImageCopyEXT memoryImageHeight(@NativeType(value="uint32_t") int value) {
        VkMemoryToImageCopyEXT.nmemoryImageHeight(this.address(), value);
        return this;
    }

    @Override
    public VkMemoryToImageCopyEXT imageSubresource(VkImageSubresourceLayers value) {
        VkMemoryToImageCopyEXT.nimageSubresource(this.address(), value);
        return this;
    }

    @Override
    public VkMemoryToImageCopyEXT imageSubresource(Consumer<VkImageSubresourceLayers> consumer) {
        consumer.accept(this.imageSubresource());
        return this;
    }

    @Override
    public VkMemoryToImageCopyEXT imageOffset(VkOffset3D value) {
        VkMemoryToImageCopyEXT.nimageOffset(this.address(), value);
        return this;
    }

    @Override
    public VkMemoryToImageCopyEXT imageOffset(Consumer<VkOffset3D> consumer) {
        consumer.accept(this.imageOffset());
        return this;
    }

    @Override
    public VkMemoryToImageCopyEXT imageExtent(VkExtent3D value) {
        VkMemoryToImageCopyEXT.nimageExtent(this.address(), value);
        return this;
    }

    @Override
    public VkMemoryToImageCopyEXT imageExtent(Consumer<VkExtent3D> consumer) {
        consumer.accept(this.imageExtent());
        return this;
    }

    @Override
    public VkMemoryToImageCopyEXT set(int sType, long pNext, long pHostPointer, int memoryRowLength, int memoryImageHeight, VkImageSubresourceLayers imageSubresource, VkOffset3D imageOffset, VkExtent3D imageExtent) {
        this.sType(sType);
        this.pNext(pNext);
        this.pHostPointer(pHostPointer);
        this.memoryRowLength(memoryRowLength);
        this.memoryImageHeight(memoryImageHeight);
        this.imageSubresource(imageSubresource);
        this.imageOffset(imageOffset);
        this.imageExtent(imageExtent);
        return this;
    }

    public VkMemoryToImageCopyEXT set(VkMemoryToImageCopyEXT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkMemoryToImageCopyEXT malloc() {
        return new VkMemoryToImageCopyEXT(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkMemoryToImageCopyEXT calloc() {
        return new VkMemoryToImageCopyEXT(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkMemoryToImageCopyEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkMemoryToImageCopyEXT(MemoryUtil.memAddress(container), container);
    }

    public static VkMemoryToImageCopyEXT create(long address) {
        return new VkMemoryToImageCopyEXT(address, null);
    }

    public static @Nullable VkMemoryToImageCopyEXT createSafe(long address) {
        return address == 0L ? null : new VkMemoryToImageCopyEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkMemoryToImageCopyEXT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkMemoryToImageCopyEXT.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkMemoryToImageCopyEXT malloc(MemoryStack stack) {
        return new VkMemoryToImageCopyEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkMemoryToImageCopyEXT calloc(MemoryStack stack) {
        return new VkMemoryToImageCopyEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends VkMemoryToImageCopy.Buffer {
        private static final VkMemoryToImageCopyEXT ELEMENT_FACTORY = VkMemoryToImageCopyEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkMemoryToImageCopyEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Override
        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkMemoryToImageCopyEXT.nsType(this.address(), value);
            return this;
        }

        @Override
        public Buffer sType$Default() {
            return this.sType(1000270002);
        }

        @Override
        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkMemoryToImageCopyEXT.npNext(this.address(), value);
            return this;
        }

        @Override
        public Buffer pHostPointer(@NativeType(value="void const *") long value) {
            VkMemoryToImageCopyEXT.npHostPointer(this.address(), value);
            return this;
        }

        @Override
        public Buffer memoryRowLength(@NativeType(value="uint32_t") int value) {
            VkMemoryToImageCopyEXT.nmemoryRowLength(this.address(), value);
            return this;
        }

        @Override
        public Buffer memoryImageHeight(@NativeType(value="uint32_t") int value) {
            VkMemoryToImageCopyEXT.nmemoryImageHeight(this.address(), value);
            return this;
        }

        @Override
        public Buffer imageSubresource(VkImageSubresourceLayers value) {
            VkMemoryToImageCopyEXT.nimageSubresource(this.address(), value);
            return this;
        }

        @Override
        public Buffer imageSubresource(Consumer<VkImageSubresourceLayers> consumer) {
            consumer.accept(this.imageSubresource());
            return this;
        }

        @Override
        public Buffer imageOffset(VkOffset3D value) {
            VkMemoryToImageCopyEXT.nimageOffset(this.address(), value);
            return this;
        }

        @Override
        public Buffer imageOffset(Consumer<VkOffset3D> consumer) {
            consumer.accept(this.imageOffset());
            return this;
        }

        @Override
        public Buffer imageExtent(VkExtent3D value) {
            VkMemoryToImageCopyEXT.nimageExtent(this.address(), value);
            return this;
        }

        @Override
        public Buffer imageExtent(Consumer<VkExtent3D> consumer) {
            consumer.accept(this.imageExtent());
            return this;
        }
    }
}

