/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkMemoryUnmapInfo;

public class VkMemoryUnmapInfoKHR
extends VkMemoryUnmapInfo {
    protected VkMemoryUnmapInfoKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkMemoryUnmapInfoKHR create(long address, @Nullable ByteBuffer container) {
        return new VkMemoryUnmapInfoKHR(address, container);
    }

    public VkMemoryUnmapInfoKHR(ByteBuffer container) {
        super(container);
    }

    @Override
    public VkMemoryUnmapInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkMemoryUnmapInfoKHR.nsType(this.address(), value);
        return this;
    }

    @Override
    public VkMemoryUnmapInfoKHR sType$Default() {
        return this.sType(1000271001);
    }

    @Override
    public VkMemoryUnmapInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkMemoryUnmapInfoKHR.npNext(this.address(), value);
        return this;
    }

    @Override
    public VkMemoryUnmapInfoKHR flags(@NativeType(value="VkMemoryUnmapFlags") int value) {
        VkMemoryUnmapInfoKHR.nflags(this.address(), value);
        return this;
    }

    @Override
    public VkMemoryUnmapInfoKHR memory(@NativeType(value="VkDeviceMemory") long value) {
        VkMemoryUnmapInfoKHR.nmemory(this.address(), value);
        return this;
    }

    @Override
    public VkMemoryUnmapInfoKHR set(int sType, long pNext, int flags, long memory) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.memory(memory);
        return this;
    }

    public VkMemoryUnmapInfoKHR set(VkMemoryUnmapInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkMemoryUnmapInfoKHR malloc() {
        return new VkMemoryUnmapInfoKHR(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkMemoryUnmapInfoKHR calloc() {
        return new VkMemoryUnmapInfoKHR(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkMemoryUnmapInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkMemoryUnmapInfoKHR(MemoryUtil.memAddress(container), container);
    }

    public static VkMemoryUnmapInfoKHR create(long address) {
        return new VkMemoryUnmapInfoKHR(address, null);
    }

    public static @Nullable VkMemoryUnmapInfoKHR createSafe(long address) {
        return address == 0L ? null : new VkMemoryUnmapInfoKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkMemoryUnmapInfoKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkMemoryUnmapInfoKHR.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkMemoryUnmapInfoKHR malloc(MemoryStack stack) {
        return new VkMemoryUnmapInfoKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkMemoryUnmapInfoKHR calloc(MemoryStack stack) {
        return new VkMemoryUnmapInfoKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends VkMemoryUnmapInfo.Buffer {
        private static final VkMemoryUnmapInfoKHR ELEMENT_FACTORY = VkMemoryUnmapInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkMemoryUnmapInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Override
        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkMemoryUnmapInfoKHR.nsType(this.address(), value);
            return this;
        }

        @Override
        public Buffer sType$Default() {
            return this.sType(1000271001);
        }

        @Override
        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkMemoryUnmapInfoKHR.npNext(this.address(), value);
            return this;
        }

        @Override
        public Buffer flags(@NativeType(value="VkMemoryUnmapFlags") int value) {
            VkMemoryUnmapInfoKHR.nflags(this.address(), value);
            return this;
        }

        @Override
        public Buffer memory(@NativeType(value="VkDeviceMemory") long value) {
            VkMemoryUnmapInfoKHR.nmemory(this.address(), value);
            return this;
        }
    }
}

