/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkMicromapTriangleEXT
extends Struct<VkMicromapTriangleEXT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DATAOFFSET;
    public static final int SUBDIVISIONLEVEL;
    public static final int FORMAT;

    protected VkMicromapTriangleEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkMicromapTriangleEXT create(long address, @Nullable ByteBuffer container) {
        return new VkMicromapTriangleEXT(address, container);
    }

    public VkMicromapTriangleEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkMicromapTriangleEXT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int dataOffset() {
        return VkMicromapTriangleEXT.ndataOffset(this.address());
    }

    @NativeType(value="uint16_t")
    public short subdivisionLevel() {
        return VkMicromapTriangleEXT.nsubdivisionLevel(this.address());
    }

    @NativeType(value="uint16_t")
    public short format() {
        return VkMicromapTriangleEXT.nformat(this.address());
    }

    public VkMicromapTriangleEXT dataOffset(@NativeType(value="uint32_t") int value) {
        VkMicromapTriangleEXT.ndataOffset(this.address(), value);
        return this;
    }

    public VkMicromapTriangleEXT subdivisionLevel(@NativeType(value="uint16_t") short value) {
        VkMicromapTriangleEXT.nsubdivisionLevel(this.address(), value);
        return this;
    }

    public VkMicromapTriangleEXT format(@NativeType(value="uint16_t") short value) {
        VkMicromapTriangleEXT.nformat(this.address(), value);
        return this;
    }

    public VkMicromapTriangleEXT set(int dataOffset, short subdivisionLevel, short format) {
        this.dataOffset(dataOffset);
        this.subdivisionLevel(subdivisionLevel);
        this.format(format);
        return this;
    }

    public VkMicromapTriangleEXT set(VkMicromapTriangleEXT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkMicromapTriangleEXT malloc() {
        return new VkMicromapTriangleEXT(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkMicromapTriangleEXT calloc() {
        return new VkMicromapTriangleEXT(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkMicromapTriangleEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkMicromapTriangleEXT(MemoryUtil.memAddress(container), container);
    }

    public static VkMicromapTriangleEXT create(long address) {
        return new VkMicromapTriangleEXT(address, null);
    }

    public static @Nullable VkMicromapTriangleEXT createSafe(long address) {
        return address == 0L ? null : new VkMicromapTriangleEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkMicromapTriangleEXT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkMicromapTriangleEXT.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkMicromapTriangleEXT malloc(MemoryStack stack) {
        return new VkMicromapTriangleEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkMicromapTriangleEXT calloc(MemoryStack stack) {
        return new VkMicromapTriangleEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ndataOffset(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DATAOFFSET);
    }

    public static short nsubdivisionLevel(long struct) {
        return MemoryUtil.memGetShort(struct + (long)SUBDIVISIONLEVEL);
    }

    public static short nformat(long struct) {
        return MemoryUtil.memGetShort(struct + (long)FORMAT);
    }

    public static void ndataOffset(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DATAOFFSET, value);
    }

    public static void nsubdivisionLevel(long struct, short value) {
        MemoryUtil.memPutShort(struct + (long)SUBDIVISIONLEVEL, value);
    }

    public static void nformat(long struct, short value) {
        MemoryUtil.memPutShort(struct + (long)FORMAT, value);
    }

    static {
        Struct.Layout layout = VkMicromapTriangleEXT.__struct(VkMicromapTriangleEXT.__member(4), VkMicromapTriangleEXT.__member(2), VkMicromapTriangleEXT.__member(2));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DATAOFFSET = layout.offsetof(0);
        SUBDIVISIONLEVEL = layout.offsetof(1);
        FORMAT = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkMicromapTriangleEXT, Buffer>
    implements NativeResource {
        private static final VkMicromapTriangleEXT ELEMENT_FACTORY = VkMicromapTriangleEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkMicromapTriangleEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint32_t")
        public int dataOffset() {
            return VkMicromapTriangleEXT.ndataOffset(this.address());
        }

        @NativeType(value="uint16_t")
        public short subdivisionLevel() {
            return VkMicromapTriangleEXT.nsubdivisionLevel(this.address());
        }

        @NativeType(value="uint16_t")
        public short format() {
            return VkMicromapTriangleEXT.nformat(this.address());
        }

        public Buffer dataOffset(@NativeType(value="uint32_t") int value) {
            VkMicromapTriangleEXT.ndataOffset(this.address(), value);
            return this;
        }

        public Buffer subdivisionLevel(@NativeType(value="uint16_t") short value) {
            VkMicromapTriangleEXT.nsubdivisionLevel(this.address(), value);
            return this;
        }

        public Buffer format(@NativeType(value="uint16_t") short value) {
            VkMicromapTriangleEXT.nformat(this.address(), value);
            return this;
        }
    }
}

