/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkPhysicalDeviceFeatures;
import org.lwjgl.vulkan.VkPhysicalDeviceFeatures2;

public class VkPhysicalDeviceFeatures2KHR
extends VkPhysicalDeviceFeatures2 {
    protected VkPhysicalDeviceFeatures2KHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkPhysicalDeviceFeatures2KHR create(long address, @Nullable ByteBuffer container) {
        return new VkPhysicalDeviceFeatures2KHR(address, container);
    }

    public VkPhysicalDeviceFeatures2KHR(ByteBuffer container) {
        super(container);
    }

    @Override
    public VkPhysicalDeviceFeatures2KHR sType(@NativeType(value="VkStructureType") int value) {
        VkPhysicalDeviceFeatures2KHR.nsType(this.address(), value);
        return this;
    }

    @Override
    public VkPhysicalDeviceFeatures2KHR sType$Default() {
        return this.sType(1000059000);
    }

    @Override
    public VkPhysicalDeviceFeatures2KHR pNext(@NativeType(value="void *") long value) {
        VkPhysicalDeviceFeatures2KHR.npNext(this.address(), value);
        return this;
    }

    @Override
    public VkPhysicalDeviceFeatures2KHR features(VkPhysicalDeviceFeatures value) {
        VkPhysicalDeviceFeatures2KHR.nfeatures(this.address(), value);
        return this;
    }

    @Override
    public VkPhysicalDeviceFeatures2KHR features(Consumer<VkPhysicalDeviceFeatures> consumer) {
        consumer.accept(this.features());
        return this;
    }

    @Override
    public VkPhysicalDeviceFeatures2KHR set(int sType, long pNext, VkPhysicalDeviceFeatures features) {
        this.sType(sType);
        this.pNext(pNext);
        this.features(features);
        return this;
    }

    public VkPhysicalDeviceFeatures2KHR set(VkPhysicalDeviceFeatures2KHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkPhysicalDeviceFeatures2KHR malloc() {
        return new VkPhysicalDeviceFeatures2KHR(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkPhysicalDeviceFeatures2KHR calloc() {
        return new VkPhysicalDeviceFeatures2KHR(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkPhysicalDeviceFeatures2KHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkPhysicalDeviceFeatures2KHR(MemoryUtil.memAddress(container), container);
    }

    public static VkPhysicalDeviceFeatures2KHR create(long address) {
        return new VkPhysicalDeviceFeatures2KHR(address, null);
    }

    public static @Nullable VkPhysicalDeviceFeatures2KHR createSafe(long address) {
        return address == 0L ? null : new VkPhysicalDeviceFeatures2KHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkPhysicalDeviceFeatures2KHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkPhysicalDeviceFeatures2KHR.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkPhysicalDeviceFeatures2KHR mallocStack() {
        return VkPhysicalDeviceFeatures2KHR.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkPhysicalDeviceFeatures2KHR callocStack() {
        return VkPhysicalDeviceFeatures2KHR.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkPhysicalDeviceFeatures2KHR mallocStack(MemoryStack stack) {
        return VkPhysicalDeviceFeatures2KHR.malloc(stack);
    }

    @Deprecated
    public static VkPhysicalDeviceFeatures2KHR callocStack(MemoryStack stack) {
        return VkPhysicalDeviceFeatures2KHR.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkPhysicalDeviceFeatures2KHR.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkPhysicalDeviceFeatures2KHR.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkPhysicalDeviceFeatures2KHR.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkPhysicalDeviceFeatures2KHR.calloc(capacity, stack);
    }

    public static VkPhysicalDeviceFeatures2KHR malloc(MemoryStack stack) {
        return new VkPhysicalDeviceFeatures2KHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkPhysicalDeviceFeatures2KHR calloc(MemoryStack stack) {
        return new VkPhysicalDeviceFeatures2KHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends VkPhysicalDeviceFeatures2.Buffer {
        private static final VkPhysicalDeviceFeatures2KHR ELEMENT_FACTORY = VkPhysicalDeviceFeatures2KHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkPhysicalDeviceFeatures2KHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Override
        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkPhysicalDeviceFeatures2KHR.nsType(this.address(), value);
            return this;
        }

        @Override
        public Buffer sType$Default() {
            return this.sType(1000059000);
        }

        @Override
        public Buffer pNext(@NativeType(value="void *") long value) {
            VkPhysicalDeviceFeatures2KHR.npNext(this.address(), value);
            return this;
        }

        @Override
        public Buffer features(VkPhysicalDeviceFeatures value) {
            VkPhysicalDeviceFeatures2KHR.nfeatures(this.address(), value);
            return this;
        }

        @Override
        public Buffer features(Consumer<VkPhysicalDeviceFeatures> consumer) {
            consumer.accept(this.features());
            return this;
        }
    }
}

