/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkPhysicalDeviceToolProperties
extends Struct<VkPhysicalDeviceToolProperties>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int NAME;
    public static final int VERSION;
    public static final int PURPOSES;
    public static final int DESCRIPTION;
    public static final int LAYER;

    protected VkPhysicalDeviceToolProperties(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkPhysicalDeviceToolProperties create(long address, @Nullable ByteBuffer container) {
        return new VkPhysicalDeviceToolProperties(address, container);
    }

    public VkPhysicalDeviceToolProperties(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkPhysicalDeviceToolProperties.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkPhysicalDeviceToolProperties.nsType(this.address());
    }

    @NativeType(value="void *")
    public long pNext() {
        return VkPhysicalDeviceToolProperties.npNext(this.address());
    }

    @NativeType(value="char[VK_MAX_EXTENSION_NAME_SIZE]")
    public ByteBuffer name() {
        return VkPhysicalDeviceToolProperties.nname(this.address());
    }

    @NativeType(value="char[VK_MAX_EXTENSION_NAME_SIZE]")
    public String nameString() {
        return VkPhysicalDeviceToolProperties.nnameString(this.address());
    }

    @NativeType(value="char[VK_MAX_EXTENSION_NAME_SIZE]")
    public ByteBuffer version() {
        return VkPhysicalDeviceToolProperties.nversion(this.address());
    }

    @NativeType(value="char[VK_MAX_EXTENSION_NAME_SIZE]")
    public String versionString() {
        return VkPhysicalDeviceToolProperties.nversionString(this.address());
    }

    @NativeType(value="VkToolPurposeFlags")
    public int purposes() {
        return VkPhysicalDeviceToolProperties.npurposes(this.address());
    }

    @NativeType(value="char[VK_MAX_DESCRIPTION_SIZE]")
    public ByteBuffer description() {
        return VkPhysicalDeviceToolProperties.ndescription(this.address());
    }

    @NativeType(value="char[VK_MAX_DESCRIPTION_SIZE]")
    public String descriptionString() {
        return VkPhysicalDeviceToolProperties.ndescriptionString(this.address());
    }

    @NativeType(value="char[VK_MAX_EXTENSION_NAME_SIZE]")
    public ByteBuffer layer() {
        return VkPhysicalDeviceToolProperties.nlayer(this.address());
    }

    @NativeType(value="char[VK_MAX_EXTENSION_NAME_SIZE]")
    public String layerString() {
        return VkPhysicalDeviceToolProperties.nlayerString(this.address());
    }

    public VkPhysicalDeviceToolProperties sType(@NativeType(value="VkStructureType") int value) {
        VkPhysicalDeviceToolProperties.nsType(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceToolProperties sType$Default() {
        return this.sType(1000245000);
    }

    public VkPhysicalDeviceToolProperties pNext(@NativeType(value="void *") long value) {
        VkPhysicalDeviceToolProperties.npNext(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceToolProperties set(int sType, long pNext) {
        this.sType(sType);
        this.pNext(pNext);
        return this;
    }

    public VkPhysicalDeviceToolProperties set(VkPhysicalDeviceToolProperties src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkPhysicalDeviceToolProperties malloc() {
        return new VkPhysicalDeviceToolProperties(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkPhysicalDeviceToolProperties calloc() {
        return new VkPhysicalDeviceToolProperties(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkPhysicalDeviceToolProperties create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkPhysicalDeviceToolProperties(MemoryUtil.memAddress(container), container);
    }

    public static VkPhysicalDeviceToolProperties create(long address) {
        return new VkPhysicalDeviceToolProperties(address, null);
    }

    public static @Nullable VkPhysicalDeviceToolProperties createSafe(long address) {
        return address == 0L ? null : new VkPhysicalDeviceToolProperties(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkPhysicalDeviceToolProperties.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkPhysicalDeviceToolProperties.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkPhysicalDeviceToolProperties malloc(MemoryStack stack) {
        return new VkPhysicalDeviceToolProperties(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkPhysicalDeviceToolProperties calloc(MemoryStack stack) {
        return new VkPhysicalDeviceToolProperties(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static ByteBuffer nname(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)NAME, 256);
    }

    public static String nnameString(long struct) {
        return MemoryUtil.memUTF8(struct + (long)NAME);
    }

    public static ByteBuffer nversion(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)VERSION, 256);
    }

    public static String nversionString(long struct) {
        return MemoryUtil.memUTF8(struct + (long)VERSION);
    }

    public static int npurposes(long struct) {
        return MemoryUtil.memGetInt(struct + (long)PURPOSES);
    }

    public static ByteBuffer ndescription(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)DESCRIPTION, 256);
    }

    public static String ndescriptionString(long struct) {
        return MemoryUtil.memUTF8(struct + (long)DESCRIPTION);
    }

    public static ByteBuffer nlayer(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)LAYER, 256);
    }

    public static String nlayerString(long struct) {
        return MemoryUtil.memUTF8(struct + (long)LAYER);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    static {
        Struct.Layout layout = VkPhysicalDeviceToolProperties.__struct(VkPhysicalDeviceToolProperties.__member(4), VkPhysicalDeviceToolProperties.__member(POINTER_SIZE), VkPhysicalDeviceToolProperties.__array(1, 256), VkPhysicalDeviceToolProperties.__array(1, 256), VkPhysicalDeviceToolProperties.__member(4), VkPhysicalDeviceToolProperties.__array(1, 256), VkPhysicalDeviceToolProperties.__array(1, 256));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        NAME = layout.offsetof(2);
        VERSION = layout.offsetof(3);
        PURPOSES = layout.offsetof(4);
        DESCRIPTION = layout.offsetof(5);
        LAYER = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<VkPhysicalDeviceToolProperties, Buffer>
    implements NativeResource {
        private static final VkPhysicalDeviceToolProperties ELEMENT_FACTORY = VkPhysicalDeviceToolProperties.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkPhysicalDeviceToolProperties getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkPhysicalDeviceToolProperties.nsType(this.address());
        }

        @NativeType(value="void *")
        public long pNext() {
            return VkPhysicalDeviceToolProperties.npNext(this.address());
        }

        @NativeType(value="char[VK_MAX_EXTENSION_NAME_SIZE]")
        public ByteBuffer name() {
            return VkPhysicalDeviceToolProperties.nname(this.address());
        }

        @NativeType(value="char[VK_MAX_EXTENSION_NAME_SIZE]")
        public String nameString() {
            return VkPhysicalDeviceToolProperties.nnameString(this.address());
        }

        @NativeType(value="char[VK_MAX_EXTENSION_NAME_SIZE]")
        public ByteBuffer version() {
            return VkPhysicalDeviceToolProperties.nversion(this.address());
        }

        @NativeType(value="char[VK_MAX_EXTENSION_NAME_SIZE]")
        public String versionString() {
            return VkPhysicalDeviceToolProperties.nversionString(this.address());
        }

        @NativeType(value="VkToolPurposeFlags")
        public int purposes() {
            return VkPhysicalDeviceToolProperties.npurposes(this.address());
        }

        @NativeType(value="char[VK_MAX_DESCRIPTION_SIZE]")
        public ByteBuffer description() {
            return VkPhysicalDeviceToolProperties.ndescription(this.address());
        }

        @NativeType(value="char[VK_MAX_DESCRIPTION_SIZE]")
        public String descriptionString() {
            return VkPhysicalDeviceToolProperties.ndescriptionString(this.address());
        }

        @NativeType(value="char[VK_MAX_EXTENSION_NAME_SIZE]")
        public ByteBuffer layer() {
            return VkPhysicalDeviceToolProperties.nlayer(this.address());
        }

        @NativeType(value="char[VK_MAX_EXTENSION_NAME_SIZE]")
        public String layerString() {
            return VkPhysicalDeviceToolProperties.nlayerString(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkPhysicalDeviceToolProperties.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000245000);
        }

        public Buffer pNext(@NativeType(value="void *") long value) {
            VkPhysicalDeviceToolProperties.npNext(this.address(), value);
            return this;
        }
    }
}

