/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkPipelineBinaryDataKHR
extends Struct<VkPipelineBinaryDataKHR>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DATASIZE;
    public static final int PDATA;

    protected VkPipelineBinaryDataKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkPipelineBinaryDataKHR create(long address, @Nullable ByteBuffer container) {
        return new VkPipelineBinaryDataKHR(address, container);
    }

    public VkPipelineBinaryDataKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkPipelineBinaryDataKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="size_t")
    public long dataSize() {
        return VkPipelineBinaryDataKHR.ndataSize(this.address());
    }

    @NativeType(value="void *")
    public ByteBuffer pData() {
        return VkPipelineBinaryDataKHR.npData(this.address());
    }

    public VkPipelineBinaryDataKHR pData(@NativeType(value="void *") ByteBuffer value) {
        VkPipelineBinaryDataKHR.npData(this.address(), value);
        return this;
    }

    public VkPipelineBinaryDataKHR set(VkPipelineBinaryDataKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkPipelineBinaryDataKHR malloc() {
        return new VkPipelineBinaryDataKHR(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkPipelineBinaryDataKHR calloc() {
        return new VkPipelineBinaryDataKHR(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkPipelineBinaryDataKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkPipelineBinaryDataKHR(MemoryUtil.memAddress(container), container);
    }

    public static VkPipelineBinaryDataKHR create(long address) {
        return new VkPipelineBinaryDataKHR(address, null);
    }

    public static @Nullable VkPipelineBinaryDataKHR createSafe(long address) {
        return address == 0L ? null : new VkPipelineBinaryDataKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkPipelineBinaryDataKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkPipelineBinaryDataKHR.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkPipelineBinaryDataKHR malloc(MemoryStack stack) {
        return new VkPipelineBinaryDataKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkPipelineBinaryDataKHR calloc(MemoryStack stack) {
        return new VkPipelineBinaryDataKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long ndataSize(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)DATASIZE);
    }

    public static ByteBuffer npData(long struct) {
        return MemoryUtil.memByteBuffer(MemoryUtil.memGetAddress(struct + (long)PDATA), (int)VkPipelineBinaryDataKHR.ndataSize(struct));
    }

    public static void ndataSize(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)DATASIZE, value);
    }

    public static void npData(long struct, ByteBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PDATA, MemoryUtil.memAddress(value));
        VkPipelineBinaryDataKHR.ndataSize(struct, value.remaining());
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PDATA));
    }

    static {
        Struct.Layout layout = VkPipelineBinaryDataKHR.__struct(VkPipelineBinaryDataKHR.__member(POINTER_SIZE), VkPipelineBinaryDataKHR.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DATASIZE = layout.offsetof(0);
        PDATA = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VkPipelineBinaryDataKHR, Buffer>
    implements NativeResource {
        private static final VkPipelineBinaryDataKHR ELEMENT_FACTORY = VkPipelineBinaryDataKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkPipelineBinaryDataKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="size_t")
        public long dataSize() {
            return VkPipelineBinaryDataKHR.ndataSize(this.address());
        }

        @NativeType(value="void *")
        public ByteBuffer pData() {
            return VkPipelineBinaryDataKHR.npData(this.address());
        }

        public Buffer pData(@NativeType(value="void *") ByteBuffer value) {
            VkPipelineBinaryDataKHR.npData(this.address(), value);
            return this;
        }
    }
}

