/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkPipelineBinaryDataKHR;
import org.lwjgl.vulkan.VkPipelineBinaryKeyKHR;

public class VkPipelineBinaryKeysAndDataKHR
extends Struct<VkPipelineBinaryKeysAndDataKHR>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int BINARYCOUNT;
    public static final int PPIPELINEBINARYKEYS;
    public static final int PPIPELINEBINARYDATA;

    protected VkPipelineBinaryKeysAndDataKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkPipelineBinaryKeysAndDataKHR create(long address, @Nullable ByteBuffer container) {
        return new VkPipelineBinaryKeysAndDataKHR(address, container);
    }

    public VkPipelineBinaryKeysAndDataKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkPipelineBinaryKeysAndDataKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int binaryCount() {
        return VkPipelineBinaryKeysAndDataKHR.nbinaryCount(this.address());
    }

    @NativeType(value="VkPipelineBinaryKeyKHR const *")
    public VkPipelineBinaryKeyKHR.Buffer pPipelineBinaryKeys() {
        return VkPipelineBinaryKeysAndDataKHR.npPipelineBinaryKeys(this.address());
    }

    @NativeType(value="VkPipelineBinaryDataKHR const *")
    public VkPipelineBinaryDataKHR.Buffer pPipelineBinaryData() {
        return VkPipelineBinaryKeysAndDataKHR.npPipelineBinaryData(this.address());
    }

    public VkPipelineBinaryKeysAndDataKHR binaryCount(@NativeType(value="uint32_t") int value) {
        VkPipelineBinaryKeysAndDataKHR.nbinaryCount(this.address(), value);
        return this;
    }

    public VkPipelineBinaryKeysAndDataKHR pPipelineBinaryKeys(@NativeType(value="VkPipelineBinaryKeyKHR const *") VkPipelineBinaryKeyKHR.Buffer value) {
        VkPipelineBinaryKeysAndDataKHR.npPipelineBinaryKeys(this.address(), value);
        return this;
    }

    public VkPipelineBinaryKeysAndDataKHR pPipelineBinaryData(@NativeType(value="VkPipelineBinaryDataKHR const *") VkPipelineBinaryDataKHR.Buffer value) {
        VkPipelineBinaryKeysAndDataKHR.npPipelineBinaryData(this.address(), value);
        return this;
    }

    public VkPipelineBinaryKeysAndDataKHR set(int binaryCount, VkPipelineBinaryKeyKHR.Buffer pPipelineBinaryKeys, VkPipelineBinaryDataKHR.Buffer pPipelineBinaryData) {
        this.binaryCount(binaryCount);
        this.pPipelineBinaryKeys(pPipelineBinaryKeys);
        this.pPipelineBinaryData(pPipelineBinaryData);
        return this;
    }

    public VkPipelineBinaryKeysAndDataKHR set(VkPipelineBinaryKeysAndDataKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkPipelineBinaryKeysAndDataKHR malloc() {
        return new VkPipelineBinaryKeysAndDataKHR(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkPipelineBinaryKeysAndDataKHR calloc() {
        return new VkPipelineBinaryKeysAndDataKHR(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkPipelineBinaryKeysAndDataKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkPipelineBinaryKeysAndDataKHR(MemoryUtil.memAddress(container), container);
    }

    public static VkPipelineBinaryKeysAndDataKHR create(long address) {
        return new VkPipelineBinaryKeysAndDataKHR(address, null);
    }

    public static @Nullable VkPipelineBinaryKeysAndDataKHR createSafe(long address) {
        return address == 0L ? null : new VkPipelineBinaryKeysAndDataKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkPipelineBinaryKeysAndDataKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkPipelineBinaryKeysAndDataKHR.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkPipelineBinaryKeysAndDataKHR malloc(MemoryStack stack) {
        return new VkPipelineBinaryKeysAndDataKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkPipelineBinaryKeysAndDataKHR calloc(MemoryStack stack) {
        return new VkPipelineBinaryKeysAndDataKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nbinaryCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)BINARYCOUNT);
    }

    public static VkPipelineBinaryKeyKHR.Buffer npPipelineBinaryKeys(long struct) {
        return VkPipelineBinaryKeyKHR.create(MemoryUtil.memGetAddress(struct + (long)PPIPELINEBINARYKEYS), VkPipelineBinaryKeysAndDataKHR.nbinaryCount(struct));
    }

    public static VkPipelineBinaryDataKHR.Buffer npPipelineBinaryData(long struct) {
        return VkPipelineBinaryDataKHR.create(MemoryUtil.memGetAddress(struct + (long)PPIPELINEBINARYDATA), VkPipelineBinaryKeysAndDataKHR.nbinaryCount(struct));
    }

    public static void nbinaryCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)BINARYCOUNT, value);
    }

    public static void npPipelineBinaryKeys(long struct, VkPipelineBinaryKeyKHR.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PPIPELINEBINARYKEYS, value.address());
    }

    public static void npPipelineBinaryData(long struct, VkPipelineBinaryDataKHR.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PPIPELINEBINARYDATA, value.address());
    }

    public static void validate(long struct) {
        int binaryCount = VkPipelineBinaryKeysAndDataKHR.nbinaryCount(struct);
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PPIPELINEBINARYKEYS));
        long pPipelineBinaryData = MemoryUtil.memGetAddress(struct + (long)PPIPELINEBINARYDATA);
        Checks.check(pPipelineBinaryData);
        VkPipelineBinaryKeysAndDataKHR.validate(pPipelineBinaryData, binaryCount, VkPipelineBinaryDataKHR.SIZEOF, VkPipelineBinaryDataKHR::validate);
    }

    static {
        Struct.Layout layout = VkPipelineBinaryKeysAndDataKHR.__struct(VkPipelineBinaryKeysAndDataKHR.__member(4), VkPipelineBinaryKeysAndDataKHR.__member(POINTER_SIZE), VkPipelineBinaryKeysAndDataKHR.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        BINARYCOUNT = layout.offsetof(0);
        PPIPELINEBINARYKEYS = layout.offsetof(1);
        PPIPELINEBINARYDATA = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkPipelineBinaryKeysAndDataKHR, Buffer>
    implements NativeResource {
        private static final VkPipelineBinaryKeysAndDataKHR ELEMENT_FACTORY = VkPipelineBinaryKeysAndDataKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkPipelineBinaryKeysAndDataKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint32_t")
        public int binaryCount() {
            return VkPipelineBinaryKeysAndDataKHR.nbinaryCount(this.address());
        }

        @NativeType(value="VkPipelineBinaryKeyKHR const *")
        public VkPipelineBinaryKeyKHR.Buffer pPipelineBinaryKeys() {
            return VkPipelineBinaryKeysAndDataKHR.npPipelineBinaryKeys(this.address());
        }

        @NativeType(value="VkPipelineBinaryDataKHR const *")
        public VkPipelineBinaryDataKHR.Buffer pPipelineBinaryData() {
            return VkPipelineBinaryKeysAndDataKHR.npPipelineBinaryData(this.address());
        }

        public Buffer binaryCount(@NativeType(value="uint32_t") int value) {
            VkPipelineBinaryKeysAndDataKHR.nbinaryCount(this.address(), value);
            return this;
        }

        public Buffer pPipelineBinaryKeys(@NativeType(value="VkPipelineBinaryKeyKHR const *") VkPipelineBinaryKeyKHR.Buffer value) {
            VkPipelineBinaryKeysAndDataKHR.npPipelineBinaryKeys(this.address(), value);
            return this;
        }

        public Buffer pPipelineBinaryData(@NativeType(value="VkPipelineBinaryDataKHR const *") VkPipelineBinaryDataKHR.Buffer value) {
            VkPipelineBinaryKeysAndDataKHR.npPipelineBinaryData(this.address(), value);
            return this;
        }
    }
}

