/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkPipelineExecutableInfoKHR
extends Struct<VkPipelineExecutableInfoKHR>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int PIPELINE;
    public static final int EXECUTABLEINDEX;

    protected VkPipelineExecutableInfoKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkPipelineExecutableInfoKHR create(long address, @Nullable ByteBuffer container) {
        return new VkPipelineExecutableInfoKHR(address, container);
    }

    public VkPipelineExecutableInfoKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkPipelineExecutableInfoKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkPipelineExecutableInfoKHR.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkPipelineExecutableInfoKHR.npNext(this.address());
    }

    @NativeType(value="VkPipeline")
    public long pipeline() {
        return VkPipelineExecutableInfoKHR.npipeline(this.address());
    }

    @NativeType(value="uint32_t")
    public int executableIndex() {
        return VkPipelineExecutableInfoKHR.nexecutableIndex(this.address());
    }

    public VkPipelineExecutableInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkPipelineExecutableInfoKHR.nsType(this.address(), value);
        return this;
    }

    public VkPipelineExecutableInfoKHR sType$Default() {
        return this.sType(1000269003);
    }

    public VkPipelineExecutableInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkPipelineExecutableInfoKHR.npNext(this.address(), value);
        return this;
    }

    public VkPipelineExecutableInfoKHR pipeline(@NativeType(value="VkPipeline") long value) {
        VkPipelineExecutableInfoKHR.npipeline(this.address(), value);
        return this;
    }

    public VkPipelineExecutableInfoKHR executableIndex(@NativeType(value="uint32_t") int value) {
        VkPipelineExecutableInfoKHR.nexecutableIndex(this.address(), value);
        return this;
    }

    public VkPipelineExecutableInfoKHR set(int sType, long pNext, long pipeline, int executableIndex) {
        this.sType(sType);
        this.pNext(pNext);
        this.pipeline(pipeline);
        this.executableIndex(executableIndex);
        return this;
    }

    public VkPipelineExecutableInfoKHR set(VkPipelineExecutableInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkPipelineExecutableInfoKHR malloc() {
        return new VkPipelineExecutableInfoKHR(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkPipelineExecutableInfoKHR calloc() {
        return new VkPipelineExecutableInfoKHR(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkPipelineExecutableInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkPipelineExecutableInfoKHR(MemoryUtil.memAddress(container), container);
    }

    public static VkPipelineExecutableInfoKHR create(long address) {
        return new VkPipelineExecutableInfoKHR(address, null);
    }

    public static @Nullable VkPipelineExecutableInfoKHR createSafe(long address) {
        return address == 0L ? null : new VkPipelineExecutableInfoKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkPipelineExecutableInfoKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkPipelineExecutableInfoKHR.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkPipelineExecutableInfoKHR mallocStack() {
        return VkPipelineExecutableInfoKHR.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkPipelineExecutableInfoKHR callocStack() {
        return VkPipelineExecutableInfoKHR.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkPipelineExecutableInfoKHR mallocStack(MemoryStack stack) {
        return VkPipelineExecutableInfoKHR.malloc(stack);
    }

    @Deprecated
    public static VkPipelineExecutableInfoKHR callocStack(MemoryStack stack) {
        return VkPipelineExecutableInfoKHR.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkPipelineExecutableInfoKHR.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkPipelineExecutableInfoKHR.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkPipelineExecutableInfoKHR.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkPipelineExecutableInfoKHR.calloc(capacity, stack);
    }

    public static VkPipelineExecutableInfoKHR malloc(MemoryStack stack) {
        return new VkPipelineExecutableInfoKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkPipelineExecutableInfoKHR calloc(MemoryStack stack) {
        return new VkPipelineExecutableInfoKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static long npipeline(long struct) {
        return MemoryUtil.memGetLong(struct + (long)PIPELINE);
    }

    public static int nexecutableIndex(long struct) {
        return MemoryUtil.memGetInt(struct + (long)EXECUTABLEINDEX);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void npipeline(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)PIPELINE, value);
    }

    public static void nexecutableIndex(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)EXECUTABLEINDEX, value);
    }

    static {
        Struct.Layout layout = VkPipelineExecutableInfoKHR.__struct(VkPipelineExecutableInfoKHR.__member(4), VkPipelineExecutableInfoKHR.__member(POINTER_SIZE), VkPipelineExecutableInfoKHR.__member(8), VkPipelineExecutableInfoKHR.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        PIPELINE = layout.offsetof(2);
        EXECUTABLEINDEX = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkPipelineExecutableInfoKHR, Buffer>
    implements NativeResource {
        private static final VkPipelineExecutableInfoKHR ELEMENT_FACTORY = VkPipelineExecutableInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkPipelineExecutableInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkPipelineExecutableInfoKHR.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkPipelineExecutableInfoKHR.npNext(this.address());
        }

        @NativeType(value="VkPipeline")
        public long pipeline() {
            return VkPipelineExecutableInfoKHR.npipeline(this.address());
        }

        @NativeType(value="uint32_t")
        public int executableIndex() {
            return VkPipelineExecutableInfoKHR.nexecutableIndex(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkPipelineExecutableInfoKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000269003);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkPipelineExecutableInfoKHR.npNext(this.address(), value);
            return this;
        }

        public Buffer pipeline(@NativeType(value="VkPipeline") long value) {
            VkPipelineExecutableInfoKHR.npipeline(this.address(), value);
            return this;
        }

        public Buffer executableIndex(@NativeType(value="uint32_t") int value) {
            VkPipelineExecutableInfoKHR.nexecutableIndex(this.address(), value);
            return this;
        }
    }
}

