/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkPushConstantsInfo;

public class VkPushConstantsInfoKHR
extends VkPushConstantsInfo {
    protected VkPushConstantsInfoKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkPushConstantsInfoKHR create(long address, @Nullable ByteBuffer container) {
        return new VkPushConstantsInfoKHR(address, container);
    }

    public VkPushConstantsInfoKHR(ByteBuffer container) {
        super(container);
    }

    @Override
    public VkPushConstantsInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkPushConstantsInfoKHR.nsType(this.address(), value);
        return this;
    }

    @Override
    public VkPushConstantsInfoKHR sType$Default() {
        return this.sType(1000545004);
    }

    @Override
    public VkPushConstantsInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkPushConstantsInfoKHR.npNext(this.address(), value);
        return this;
    }

    @Override
    public VkPushConstantsInfoKHR layout(@NativeType(value="VkPipelineLayout") long value) {
        VkPushConstantsInfoKHR.nlayout(this.address(), value);
        return this;
    }

    @Override
    public VkPushConstantsInfoKHR stageFlags(@NativeType(value="VkShaderStageFlags") int value) {
        VkPushConstantsInfoKHR.nstageFlags(this.address(), value);
        return this;
    }

    @Override
    public VkPushConstantsInfoKHR offset(@NativeType(value="uint32_t") int value) {
        VkPushConstantsInfoKHR.noffset(this.address(), value);
        return this;
    }

    @Override
    public VkPushConstantsInfoKHR pValues(@NativeType(value="void const *") ByteBuffer value) {
        VkPushConstantsInfoKHR.npValues(this.address(), value);
        return this;
    }

    @Override
    public VkPushConstantsInfoKHR set(int sType, long pNext, long layout, int stageFlags, int offset, ByteBuffer pValues) {
        this.sType(sType);
        this.pNext(pNext);
        this.layout(layout);
        this.stageFlags(stageFlags);
        this.offset(offset);
        this.pValues(pValues);
        return this;
    }

    public VkPushConstantsInfoKHR set(VkPushConstantsInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkPushConstantsInfoKHR malloc() {
        return new VkPushConstantsInfoKHR(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkPushConstantsInfoKHR calloc() {
        return new VkPushConstantsInfoKHR(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkPushConstantsInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkPushConstantsInfoKHR(MemoryUtil.memAddress(container), container);
    }

    public static VkPushConstantsInfoKHR create(long address) {
        return new VkPushConstantsInfoKHR(address, null);
    }

    public static @Nullable VkPushConstantsInfoKHR createSafe(long address) {
        return address == 0L ? null : new VkPushConstantsInfoKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkPushConstantsInfoKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkPushConstantsInfoKHR.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkPushConstantsInfoKHR malloc(MemoryStack stack) {
        return new VkPushConstantsInfoKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkPushConstantsInfoKHR calloc(MemoryStack stack) {
        return new VkPushConstantsInfoKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends VkPushConstantsInfo.Buffer {
        private static final VkPushConstantsInfoKHR ELEMENT_FACTORY = VkPushConstantsInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkPushConstantsInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Override
        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkPushConstantsInfoKHR.nsType(this.address(), value);
            return this;
        }

        @Override
        public Buffer sType$Default() {
            return this.sType(1000545004);
        }

        @Override
        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkPushConstantsInfoKHR.npNext(this.address(), value);
            return this;
        }

        @Override
        public Buffer layout(@NativeType(value="VkPipelineLayout") long value) {
            VkPushConstantsInfoKHR.nlayout(this.address(), value);
            return this;
        }

        @Override
        public Buffer stageFlags(@NativeType(value="VkShaderStageFlags") int value) {
            VkPushConstantsInfoKHR.nstageFlags(this.address(), value);
            return this;
        }

        @Override
        public Buffer offset(@NativeType(value="uint32_t") int value) {
            VkPushConstantsInfoKHR.noffset(this.address(), value);
            return this;
        }

        @Override
        public Buffer pValues(@NativeType(value="void const *") ByteBuffer value) {
            VkPushConstantsInfoKHR.npValues(this.address(), value);
            return this;
        }
    }
}

