/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkRenderPassMultiviewCreateInfo;

public class VkRenderPassMultiviewCreateInfoKHR
extends VkRenderPassMultiviewCreateInfo {
    protected VkRenderPassMultiviewCreateInfoKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkRenderPassMultiviewCreateInfoKHR create(long address, @Nullable ByteBuffer container) {
        return new VkRenderPassMultiviewCreateInfoKHR(address, container);
    }

    public VkRenderPassMultiviewCreateInfoKHR(ByteBuffer container) {
        super(container);
    }

    @Override
    public VkRenderPassMultiviewCreateInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkRenderPassMultiviewCreateInfoKHR.nsType(this.address(), value);
        return this;
    }

    @Override
    public VkRenderPassMultiviewCreateInfoKHR sType$Default() {
        return this.sType(1000053000);
    }

    @Override
    public VkRenderPassMultiviewCreateInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkRenderPassMultiviewCreateInfoKHR.npNext(this.address(), value);
        return this;
    }

    @Override
    public VkRenderPassMultiviewCreateInfoKHR pViewMasks(@NativeType(value="uint32_t const *") @Nullable IntBuffer value) {
        VkRenderPassMultiviewCreateInfoKHR.npViewMasks(this.address(), value);
        return this;
    }

    @Override
    public VkRenderPassMultiviewCreateInfoKHR pViewOffsets(@NativeType(value="int32_t const *") @Nullable IntBuffer value) {
        VkRenderPassMultiviewCreateInfoKHR.npViewOffsets(this.address(), value);
        return this;
    }

    @Override
    public VkRenderPassMultiviewCreateInfoKHR pCorrelationMasks(@NativeType(value="uint32_t const *") @Nullable IntBuffer value) {
        VkRenderPassMultiviewCreateInfoKHR.npCorrelationMasks(this.address(), value);
        return this;
    }

    @Override
    public VkRenderPassMultiviewCreateInfoKHR set(int sType, long pNext, @Nullable IntBuffer pViewMasks, @Nullable IntBuffer pViewOffsets, @Nullable IntBuffer pCorrelationMasks) {
        this.sType(sType);
        this.pNext(pNext);
        this.pViewMasks(pViewMasks);
        this.pViewOffsets(pViewOffsets);
        this.pCorrelationMasks(pCorrelationMasks);
        return this;
    }

    public VkRenderPassMultiviewCreateInfoKHR set(VkRenderPassMultiviewCreateInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkRenderPassMultiviewCreateInfoKHR malloc() {
        return new VkRenderPassMultiviewCreateInfoKHR(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkRenderPassMultiviewCreateInfoKHR calloc() {
        return new VkRenderPassMultiviewCreateInfoKHR(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkRenderPassMultiviewCreateInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkRenderPassMultiviewCreateInfoKHR(MemoryUtil.memAddress(container), container);
    }

    public static VkRenderPassMultiviewCreateInfoKHR create(long address) {
        return new VkRenderPassMultiviewCreateInfoKHR(address, null);
    }

    public static @Nullable VkRenderPassMultiviewCreateInfoKHR createSafe(long address) {
        return address == 0L ? null : new VkRenderPassMultiviewCreateInfoKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkRenderPassMultiviewCreateInfoKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkRenderPassMultiviewCreateInfoKHR.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkRenderPassMultiviewCreateInfoKHR mallocStack() {
        return VkRenderPassMultiviewCreateInfoKHR.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkRenderPassMultiviewCreateInfoKHR callocStack() {
        return VkRenderPassMultiviewCreateInfoKHR.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkRenderPassMultiviewCreateInfoKHR mallocStack(MemoryStack stack) {
        return VkRenderPassMultiviewCreateInfoKHR.malloc(stack);
    }

    @Deprecated
    public static VkRenderPassMultiviewCreateInfoKHR callocStack(MemoryStack stack) {
        return VkRenderPassMultiviewCreateInfoKHR.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkRenderPassMultiviewCreateInfoKHR.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkRenderPassMultiviewCreateInfoKHR.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkRenderPassMultiviewCreateInfoKHR.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkRenderPassMultiviewCreateInfoKHR.calloc(capacity, stack);
    }

    public static VkRenderPassMultiviewCreateInfoKHR malloc(MemoryStack stack) {
        return new VkRenderPassMultiviewCreateInfoKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkRenderPassMultiviewCreateInfoKHR calloc(MemoryStack stack) {
        return new VkRenderPassMultiviewCreateInfoKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends VkRenderPassMultiviewCreateInfo.Buffer {
        private static final VkRenderPassMultiviewCreateInfoKHR ELEMENT_FACTORY = VkRenderPassMultiviewCreateInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkRenderPassMultiviewCreateInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Override
        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkRenderPassMultiviewCreateInfoKHR.nsType(this.address(), value);
            return this;
        }

        @Override
        public Buffer sType$Default() {
            return this.sType(1000053000);
        }

        @Override
        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkRenderPassMultiviewCreateInfoKHR.npNext(this.address(), value);
            return this;
        }

        @Override
        public Buffer pViewMasks(@NativeType(value="uint32_t const *") @Nullable IntBuffer value) {
            VkRenderPassMultiviewCreateInfoKHR.npViewMasks(this.address(), value);
            return this;
        }

        @Override
        public Buffer pViewOffsets(@NativeType(value="int32_t const *") @Nullable IntBuffer value) {
            VkRenderPassMultiviewCreateInfoKHR.npViewOffsets(this.address(), value);
            return this;
        }

        @Override
        public Buffer pCorrelationMasks(@NativeType(value="uint32_t const *") @Nullable IntBuffer value) {
            VkRenderPassMultiviewCreateInfoKHR.npCorrelationMasks(this.address(), value);
            return this;
        }
    }
}

