/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkRenderingAreaInfo
extends Struct<VkRenderingAreaInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int VIEWMASK;
    public static final int COLORATTACHMENTCOUNT;
    public static final int PCOLORATTACHMENTFORMATS;
    public static final int DEPTHATTACHMENTFORMAT;
    public static final int STENCILATTACHMENTFORMAT;

    protected VkRenderingAreaInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkRenderingAreaInfo create(long address, @Nullable ByteBuffer container) {
        return new VkRenderingAreaInfo(address, container);
    }

    public VkRenderingAreaInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkRenderingAreaInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkRenderingAreaInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkRenderingAreaInfo.npNext(this.address());
    }

    @NativeType(value="uint32_t")
    public int viewMask() {
        return VkRenderingAreaInfo.nviewMask(this.address());
    }

    @NativeType(value="uint32_t")
    public int colorAttachmentCount() {
        return VkRenderingAreaInfo.ncolorAttachmentCount(this.address());
    }

    @NativeType(value="VkFormat const *")
    public @Nullable IntBuffer pColorAttachmentFormats() {
        return VkRenderingAreaInfo.npColorAttachmentFormats(this.address());
    }

    @NativeType(value="VkFormat")
    public int depthAttachmentFormat() {
        return VkRenderingAreaInfo.ndepthAttachmentFormat(this.address());
    }

    @NativeType(value="VkFormat")
    public int stencilAttachmentFormat() {
        return VkRenderingAreaInfo.nstencilAttachmentFormat(this.address());
    }

    public VkRenderingAreaInfo sType(@NativeType(value="VkStructureType") int value) {
        VkRenderingAreaInfo.nsType(this.address(), value);
        return this;
    }

    public VkRenderingAreaInfo sType$Default() {
        return this.sType(1000470003);
    }

    public VkRenderingAreaInfo pNext(@NativeType(value="void const *") long value) {
        VkRenderingAreaInfo.npNext(this.address(), value);
        return this;
    }

    public VkRenderingAreaInfo viewMask(@NativeType(value="uint32_t") int value) {
        VkRenderingAreaInfo.nviewMask(this.address(), value);
        return this;
    }

    public VkRenderingAreaInfo colorAttachmentCount(@NativeType(value="uint32_t") int value) {
        VkRenderingAreaInfo.ncolorAttachmentCount(this.address(), value);
        return this;
    }

    public VkRenderingAreaInfo pColorAttachmentFormats(@NativeType(value="VkFormat const *") @Nullable IntBuffer value) {
        VkRenderingAreaInfo.npColorAttachmentFormats(this.address(), value);
        return this;
    }

    public VkRenderingAreaInfo depthAttachmentFormat(@NativeType(value="VkFormat") int value) {
        VkRenderingAreaInfo.ndepthAttachmentFormat(this.address(), value);
        return this;
    }

    public VkRenderingAreaInfo stencilAttachmentFormat(@NativeType(value="VkFormat") int value) {
        VkRenderingAreaInfo.nstencilAttachmentFormat(this.address(), value);
        return this;
    }

    public VkRenderingAreaInfo set(int sType, long pNext, int viewMask, int colorAttachmentCount, @Nullable IntBuffer pColorAttachmentFormats, int depthAttachmentFormat, int stencilAttachmentFormat) {
        this.sType(sType);
        this.pNext(pNext);
        this.viewMask(viewMask);
        this.colorAttachmentCount(colorAttachmentCount);
        this.pColorAttachmentFormats(pColorAttachmentFormats);
        this.depthAttachmentFormat(depthAttachmentFormat);
        this.stencilAttachmentFormat(stencilAttachmentFormat);
        return this;
    }

    public VkRenderingAreaInfo set(VkRenderingAreaInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkRenderingAreaInfo malloc() {
        return new VkRenderingAreaInfo(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkRenderingAreaInfo calloc() {
        return new VkRenderingAreaInfo(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkRenderingAreaInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkRenderingAreaInfo(MemoryUtil.memAddress(container), container);
    }

    public static VkRenderingAreaInfo create(long address) {
        return new VkRenderingAreaInfo(address, null);
    }

    public static @Nullable VkRenderingAreaInfo createSafe(long address) {
        return address == 0L ? null : new VkRenderingAreaInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkRenderingAreaInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkRenderingAreaInfo.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkRenderingAreaInfo malloc(MemoryStack stack) {
        return new VkRenderingAreaInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkRenderingAreaInfo calloc(MemoryStack stack) {
        return new VkRenderingAreaInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nviewMask(long struct) {
        return MemoryUtil.memGetInt(struct + (long)VIEWMASK);
    }

    public static int ncolorAttachmentCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)COLORATTACHMENTCOUNT);
    }

    public static @Nullable IntBuffer npColorAttachmentFormats(long struct) {
        return MemoryUtil.memIntBufferSafe(MemoryUtil.memGetAddress(struct + (long)PCOLORATTACHMENTFORMATS), VkRenderingAreaInfo.ncolorAttachmentCount(struct));
    }

    public static int ndepthAttachmentFormat(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DEPTHATTACHMENTFORMAT);
    }

    public static int nstencilAttachmentFormat(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STENCILATTACHMENTFORMAT);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nviewMask(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)VIEWMASK, value);
    }

    public static void ncolorAttachmentCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)COLORATTACHMENTCOUNT, value);
    }

    public static void npColorAttachmentFormats(long struct, @Nullable IntBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PCOLORATTACHMENTFORMATS, MemoryUtil.memAddressSafe(value));
        if (value != null) {
            VkRenderingAreaInfo.ncolorAttachmentCount(struct, value.remaining());
        }
    }

    public static void ndepthAttachmentFormat(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DEPTHATTACHMENTFORMAT, value);
    }

    public static void nstencilAttachmentFormat(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STENCILATTACHMENTFORMAT, value);
    }

    static {
        Struct.Layout layout = VkRenderingAreaInfo.__struct(VkRenderingAreaInfo.__member(4), VkRenderingAreaInfo.__member(POINTER_SIZE), VkRenderingAreaInfo.__member(4), VkRenderingAreaInfo.__member(4), VkRenderingAreaInfo.__member(POINTER_SIZE), VkRenderingAreaInfo.__member(4), VkRenderingAreaInfo.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        VIEWMASK = layout.offsetof(2);
        COLORATTACHMENTCOUNT = layout.offsetof(3);
        PCOLORATTACHMENTFORMATS = layout.offsetof(4);
        DEPTHATTACHMENTFORMAT = layout.offsetof(5);
        STENCILATTACHMENTFORMAT = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<VkRenderingAreaInfo, Buffer>
    implements NativeResource {
        private static final VkRenderingAreaInfo ELEMENT_FACTORY = VkRenderingAreaInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkRenderingAreaInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkRenderingAreaInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkRenderingAreaInfo.npNext(this.address());
        }

        @NativeType(value="uint32_t")
        public int viewMask() {
            return VkRenderingAreaInfo.nviewMask(this.address());
        }

        @NativeType(value="uint32_t")
        public int colorAttachmentCount() {
            return VkRenderingAreaInfo.ncolorAttachmentCount(this.address());
        }

        @NativeType(value="VkFormat const *")
        public @Nullable IntBuffer pColorAttachmentFormats() {
            return VkRenderingAreaInfo.npColorAttachmentFormats(this.address());
        }

        @NativeType(value="VkFormat")
        public int depthAttachmentFormat() {
            return VkRenderingAreaInfo.ndepthAttachmentFormat(this.address());
        }

        @NativeType(value="VkFormat")
        public int stencilAttachmentFormat() {
            return VkRenderingAreaInfo.nstencilAttachmentFormat(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkRenderingAreaInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000470003);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkRenderingAreaInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer viewMask(@NativeType(value="uint32_t") int value) {
            VkRenderingAreaInfo.nviewMask(this.address(), value);
            return this;
        }

        public Buffer colorAttachmentCount(@NativeType(value="uint32_t") int value) {
            VkRenderingAreaInfo.ncolorAttachmentCount(this.address(), value);
            return this;
        }

        public Buffer pColorAttachmentFormats(@NativeType(value="VkFormat const *") @Nullable IntBuffer value) {
            VkRenderingAreaInfo.npColorAttachmentFormats(this.address(), value);
            return this;
        }

        public Buffer depthAttachmentFormat(@NativeType(value="VkFormat") int value) {
            VkRenderingAreaInfo.ndepthAttachmentFormat(this.address(), value);
            return this;
        }

        public Buffer stencilAttachmentFormat(@NativeType(value="VkFormat") int value) {
            VkRenderingAreaInfo.nstencilAttachmentFormat(this.address(), value);
            return this;
        }
    }
}

