/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkSparseMemoryBind;

public class VkSparseBufferMemoryBindInfo
extends Struct<VkSparseBufferMemoryBindInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int BUFFER;
    public static final int BINDCOUNT;
    public static final int PBINDS;

    protected VkSparseBufferMemoryBindInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkSparseBufferMemoryBindInfo create(long address, @Nullable ByteBuffer container) {
        return new VkSparseBufferMemoryBindInfo(address, container);
    }

    public VkSparseBufferMemoryBindInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkSparseBufferMemoryBindInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkBuffer")
    public long buffer() {
        return VkSparseBufferMemoryBindInfo.nbuffer(this.address());
    }

    @NativeType(value="uint32_t")
    public int bindCount() {
        return VkSparseBufferMemoryBindInfo.nbindCount(this.address());
    }

    @NativeType(value="VkSparseMemoryBind const *")
    public VkSparseMemoryBind.Buffer pBinds() {
        return VkSparseBufferMemoryBindInfo.npBinds(this.address());
    }

    public VkSparseBufferMemoryBindInfo buffer(@NativeType(value="VkBuffer") long value) {
        VkSparseBufferMemoryBindInfo.nbuffer(this.address(), value);
        return this;
    }

    public VkSparseBufferMemoryBindInfo pBinds(@NativeType(value="VkSparseMemoryBind const *") VkSparseMemoryBind.Buffer value) {
        VkSparseBufferMemoryBindInfo.npBinds(this.address(), value);
        return this;
    }

    public VkSparseBufferMemoryBindInfo set(long buffer, VkSparseMemoryBind.Buffer pBinds) {
        this.buffer(buffer);
        this.pBinds(pBinds);
        return this;
    }

    public VkSparseBufferMemoryBindInfo set(VkSparseBufferMemoryBindInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkSparseBufferMemoryBindInfo malloc() {
        return new VkSparseBufferMemoryBindInfo(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkSparseBufferMemoryBindInfo calloc() {
        return new VkSparseBufferMemoryBindInfo(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkSparseBufferMemoryBindInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkSparseBufferMemoryBindInfo(MemoryUtil.memAddress(container), container);
    }

    public static VkSparseBufferMemoryBindInfo create(long address) {
        return new VkSparseBufferMemoryBindInfo(address, null);
    }

    public static @Nullable VkSparseBufferMemoryBindInfo createSafe(long address) {
        return address == 0L ? null : new VkSparseBufferMemoryBindInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkSparseBufferMemoryBindInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkSparseBufferMemoryBindInfo.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkSparseBufferMemoryBindInfo mallocStack() {
        return VkSparseBufferMemoryBindInfo.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkSparseBufferMemoryBindInfo callocStack() {
        return VkSparseBufferMemoryBindInfo.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkSparseBufferMemoryBindInfo mallocStack(MemoryStack stack) {
        return VkSparseBufferMemoryBindInfo.malloc(stack);
    }

    @Deprecated
    public static VkSparseBufferMemoryBindInfo callocStack(MemoryStack stack) {
        return VkSparseBufferMemoryBindInfo.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkSparseBufferMemoryBindInfo.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkSparseBufferMemoryBindInfo.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkSparseBufferMemoryBindInfo.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkSparseBufferMemoryBindInfo.calloc(capacity, stack);
    }

    public static VkSparseBufferMemoryBindInfo malloc(MemoryStack stack) {
        return new VkSparseBufferMemoryBindInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkSparseBufferMemoryBindInfo calloc(MemoryStack stack) {
        return new VkSparseBufferMemoryBindInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nbuffer(long struct) {
        return MemoryUtil.memGetLong(struct + (long)BUFFER);
    }

    public static int nbindCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)BINDCOUNT);
    }

    public static VkSparseMemoryBind.Buffer npBinds(long struct) {
        return VkSparseMemoryBind.create(MemoryUtil.memGetAddress(struct + (long)PBINDS), VkSparseBufferMemoryBindInfo.nbindCount(struct));
    }

    public static void nbuffer(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)BUFFER, value);
    }

    public static void nbindCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)BINDCOUNT, value);
    }

    public static void npBinds(long struct, VkSparseMemoryBind.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PBINDS, value.address());
        VkSparseBufferMemoryBindInfo.nbindCount(struct, value.remaining());
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PBINDS));
    }

    static {
        Struct.Layout layout = VkSparseBufferMemoryBindInfo.__struct(VkSparseBufferMemoryBindInfo.__member(8), VkSparseBufferMemoryBindInfo.__member(4), VkSparseBufferMemoryBindInfo.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        BUFFER = layout.offsetof(0);
        BINDCOUNT = layout.offsetof(1);
        PBINDS = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkSparseBufferMemoryBindInfo, Buffer>
    implements NativeResource {
        private static final VkSparseBufferMemoryBindInfo ELEMENT_FACTORY = VkSparseBufferMemoryBindInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkSparseBufferMemoryBindInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkBuffer")
        public long buffer() {
            return VkSparseBufferMemoryBindInfo.nbuffer(this.address());
        }

        @NativeType(value="uint32_t")
        public int bindCount() {
            return VkSparseBufferMemoryBindInfo.nbindCount(this.address());
        }

        @NativeType(value="VkSparseMemoryBind const *")
        public VkSparseMemoryBind.Buffer pBinds() {
            return VkSparseBufferMemoryBindInfo.npBinds(this.address());
        }

        public Buffer buffer(@NativeType(value="VkBuffer") long value) {
            VkSparseBufferMemoryBindInfo.nbuffer(this.address(), value);
            return this;
        }

        public Buffer pBinds(@NativeType(value="VkSparseMemoryBind const *") VkSparseMemoryBind.Buffer value) {
            VkSparseBufferMemoryBindInfo.npBinds(this.address(), value);
            return this;
        }
    }
}

