/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkSparseImageMemoryBind;

public class VkSparseImageMemoryBindInfo
extends Struct<VkSparseImageMemoryBindInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int IMAGE;
    public static final int BINDCOUNT;
    public static final int PBINDS;

    protected VkSparseImageMemoryBindInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkSparseImageMemoryBindInfo create(long address, @Nullable ByteBuffer container) {
        return new VkSparseImageMemoryBindInfo(address, container);
    }

    public VkSparseImageMemoryBindInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkSparseImageMemoryBindInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkImage")
    public long image() {
        return VkSparseImageMemoryBindInfo.nimage(this.address());
    }

    @NativeType(value="uint32_t")
    public int bindCount() {
        return VkSparseImageMemoryBindInfo.nbindCount(this.address());
    }

    @NativeType(value="VkSparseImageMemoryBind const *")
    public VkSparseImageMemoryBind.Buffer pBinds() {
        return VkSparseImageMemoryBindInfo.npBinds(this.address());
    }

    public VkSparseImageMemoryBindInfo image(@NativeType(value="VkImage") long value) {
        VkSparseImageMemoryBindInfo.nimage(this.address(), value);
        return this;
    }

    public VkSparseImageMemoryBindInfo pBinds(@NativeType(value="VkSparseImageMemoryBind const *") VkSparseImageMemoryBind.Buffer value) {
        VkSparseImageMemoryBindInfo.npBinds(this.address(), value);
        return this;
    }

    public VkSparseImageMemoryBindInfo set(long image, VkSparseImageMemoryBind.Buffer pBinds) {
        this.image(image);
        this.pBinds(pBinds);
        return this;
    }

    public VkSparseImageMemoryBindInfo set(VkSparseImageMemoryBindInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkSparseImageMemoryBindInfo malloc() {
        return new VkSparseImageMemoryBindInfo(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkSparseImageMemoryBindInfo calloc() {
        return new VkSparseImageMemoryBindInfo(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkSparseImageMemoryBindInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkSparseImageMemoryBindInfo(MemoryUtil.memAddress(container), container);
    }

    public static VkSparseImageMemoryBindInfo create(long address) {
        return new VkSparseImageMemoryBindInfo(address, null);
    }

    public static @Nullable VkSparseImageMemoryBindInfo createSafe(long address) {
        return address == 0L ? null : new VkSparseImageMemoryBindInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkSparseImageMemoryBindInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkSparseImageMemoryBindInfo.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkSparseImageMemoryBindInfo mallocStack() {
        return VkSparseImageMemoryBindInfo.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkSparseImageMemoryBindInfo callocStack() {
        return VkSparseImageMemoryBindInfo.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkSparseImageMemoryBindInfo mallocStack(MemoryStack stack) {
        return VkSparseImageMemoryBindInfo.malloc(stack);
    }

    @Deprecated
    public static VkSparseImageMemoryBindInfo callocStack(MemoryStack stack) {
        return VkSparseImageMemoryBindInfo.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkSparseImageMemoryBindInfo.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkSparseImageMemoryBindInfo.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkSparseImageMemoryBindInfo.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkSparseImageMemoryBindInfo.calloc(capacity, stack);
    }

    public static VkSparseImageMemoryBindInfo malloc(MemoryStack stack) {
        return new VkSparseImageMemoryBindInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkSparseImageMemoryBindInfo calloc(MemoryStack stack) {
        return new VkSparseImageMemoryBindInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nimage(long struct) {
        return MemoryUtil.memGetLong(struct + (long)IMAGE);
    }

    public static int nbindCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)BINDCOUNT);
    }

    public static VkSparseImageMemoryBind.Buffer npBinds(long struct) {
        return VkSparseImageMemoryBind.create(MemoryUtil.memGetAddress(struct + (long)PBINDS), VkSparseImageMemoryBindInfo.nbindCount(struct));
    }

    public static void nimage(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)IMAGE, value);
    }

    public static void nbindCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)BINDCOUNT, value);
    }

    public static void npBinds(long struct, VkSparseImageMemoryBind.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PBINDS, value.address());
        VkSparseImageMemoryBindInfo.nbindCount(struct, value.remaining());
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PBINDS));
    }

    static {
        Struct.Layout layout = VkSparseImageMemoryBindInfo.__struct(VkSparseImageMemoryBindInfo.__member(8), VkSparseImageMemoryBindInfo.__member(4), VkSparseImageMemoryBindInfo.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        IMAGE = layout.offsetof(0);
        BINDCOUNT = layout.offsetof(1);
        PBINDS = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkSparseImageMemoryBindInfo, Buffer>
    implements NativeResource {
        private static final VkSparseImageMemoryBindInfo ELEMENT_FACTORY = VkSparseImageMemoryBindInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkSparseImageMemoryBindInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkImage")
        public long image() {
            return VkSparseImageMemoryBindInfo.nimage(this.address());
        }

        @NativeType(value="uint32_t")
        public int bindCount() {
            return VkSparseImageMemoryBindInfo.nbindCount(this.address());
        }

        @NativeType(value="VkSparseImageMemoryBind const *")
        public VkSparseImageMemoryBind.Buffer pBinds() {
            return VkSparseImageMemoryBindInfo.npBinds(this.address());
        }

        public Buffer image(@NativeType(value="VkImage") long value) {
            VkSparseImageMemoryBindInfo.nimage(this.address(), value);
            return this;
        }

        public Buffer pBinds(@NativeType(value="VkSparseImageMemoryBind const *") VkSparseImageMemoryBind.Buffer value) {
            VkSparseImageMemoryBindInfo.npBinds(this.address(), value);
            return this;
        }
    }
}

