/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkAttachmentReference;

public class VkSubpassDescription
extends Struct<VkSubpassDescription>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FLAGS;
    public static final int PIPELINEBINDPOINT;
    public static final int INPUTATTACHMENTCOUNT;
    public static final int PINPUTATTACHMENTS;
    public static final int COLORATTACHMENTCOUNT;
    public static final int PCOLORATTACHMENTS;
    public static final int PRESOLVEATTACHMENTS;
    public static final int PDEPTHSTENCILATTACHMENT;
    public static final int PRESERVEATTACHMENTCOUNT;
    public static final int PPRESERVEATTACHMENTS;

    protected VkSubpassDescription(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkSubpassDescription create(long address, @Nullable ByteBuffer container) {
        return new VkSubpassDescription(address, container);
    }

    public VkSubpassDescription(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkSubpassDescription.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkSubpassDescriptionFlags")
    public int flags() {
        return VkSubpassDescription.nflags(this.address());
    }

    @NativeType(value="VkPipelineBindPoint")
    public int pipelineBindPoint() {
        return VkSubpassDescription.npipelineBindPoint(this.address());
    }

    @NativeType(value="uint32_t")
    public int inputAttachmentCount() {
        return VkSubpassDescription.ninputAttachmentCount(this.address());
    }

    @NativeType(value="VkAttachmentReference const *")
    public @Nullable VkAttachmentReference.Buffer pInputAttachments() {
        return VkSubpassDescription.npInputAttachments(this.address());
    }

    @NativeType(value="uint32_t")
    public int colorAttachmentCount() {
        return VkSubpassDescription.ncolorAttachmentCount(this.address());
    }

    @NativeType(value="VkAttachmentReference const *")
    public @Nullable VkAttachmentReference.Buffer pColorAttachments() {
        return VkSubpassDescription.npColorAttachments(this.address());
    }

    @NativeType(value="VkAttachmentReference const *")
    public @Nullable VkAttachmentReference.Buffer pResolveAttachments() {
        return VkSubpassDescription.npResolveAttachments(this.address());
    }

    @NativeType(value="VkAttachmentReference const *")
    public @Nullable VkAttachmentReference pDepthStencilAttachment() {
        return VkSubpassDescription.npDepthStencilAttachment(this.address());
    }

    @NativeType(value="uint32_t")
    public int preserveAttachmentCount() {
        return VkSubpassDescription.npreserveAttachmentCount(this.address());
    }

    @NativeType(value="uint32_t const *")
    public @Nullable IntBuffer pPreserveAttachments() {
        return VkSubpassDescription.npPreserveAttachments(this.address());
    }

    public VkSubpassDescription flags(@NativeType(value="VkSubpassDescriptionFlags") int value) {
        VkSubpassDescription.nflags(this.address(), value);
        return this;
    }

    public VkSubpassDescription pipelineBindPoint(@NativeType(value="VkPipelineBindPoint") int value) {
        VkSubpassDescription.npipelineBindPoint(this.address(), value);
        return this;
    }

    public VkSubpassDescription pInputAttachments(@NativeType(value="VkAttachmentReference const *") @Nullable VkAttachmentReference.Buffer value) {
        VkSubpassDescription.npInputAttachments(this.address(), value);
        return this;
    }

    public VkSubpassDescription colorAttachmentCount(@NativeType(value="uint32_t") int value) {
        VkSubpassDescription.ncolorAttachmentCount(this.address(), value);
        return this;
    }

    public VkSubpassDescription pColorAttachments(@NativeType(value="VkAttachmentReference const *") @Nullable VkAttachmentReference.Buffer value) {
        VkSubpassDescription.npColorAttachments(this.address(), value);
        return this;
    }

    public VkSubpassDescription pResolveAttachments(@NativeType(value="VkAttachmentReference const *") @Nullable VkAttachmentReference.Buffer value) {
        VkSubpassDescription.npResolveAttachments(this.address(), value);
        return this;
    }

    public VkSubpassDescription pDepthStencilAttachment(@NativeType(value="VkAttachmentReference const *") @Nullable VkAttachmentReference value) {
        VkSubpassDescription.npDepthStencilAttachment(this.address(), value);
        return this;
    }

    public VkSubpassDescription pPreserveAttachments(@NativeType(value="uint32_t const *") @Nullable IntBuffer value) {
        VkSubpassDescription.npPreserveAttachments(this.address(), value);
        return this;
    }

    public VkSubpassDescription set(int flags, int pipelineBindPoint, @Nullable VkAttachmentReference.Buffer pInputAttachments, int colorAttachmentCount, @Nullable VkAttachmentReference.Buffer pColorAttachments, @Nullable VkAttachmentReference.Buffer pResolveAttachments, @Nullable VkAttachmentReference pDepthStencilAttachment, @Nullable IntBuffer pPreserveAttachments) {
        this.flags(flags);
        this.pipelineBindPoint(pipelineBindPoint);
        this.pInputAttachments(pInputAttachments);
        this.colorAttachmentCount(colorAttachmentCount);
        this.pColorAttachments(pColorAttachments);
        this.pResolveAttachments(pResolveAttachments);
        this.pDepthStencilAttachment(pDepthStencilAttachment);
        this.pPreserveAttachments(pPreserveAttachments);
        return this;
    }

    public VkSubpassDescription set(VkSubpassDescription src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkSubpassDescription malloc() {
        return new VkSubpassDescription(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkSubpassDescription calloc() {
        return new VkSubpassDescription(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkSubpassDescription create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkSubpassDescription(MemoryUtil.memAddress(container), container);
    }

    public static VkSubpassDescription create(long address) {
        return new VkSubpassDescription(address, null);
    }

    public static @Nullable VkSubpassDescription createSafe(long address) {
        return address == 0L ? null : new VkSubpassDescription(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkSubpassDescription.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkSubpassDescription.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkSubpassDescription mallocStack() {
        return VkSubpassDescription.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkSubpassDescription callocStack() {
        return VkSubpassDescription.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkSubpassDescription mallocStack(MemoryStack stack) {
        return VkSubpassDescription.malloc(stack);
    }

    @Deprecated
    public static VkSubpassDescription callocStack(MemoryStack stack) {
        return VkSubpassDescription.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkSubpassDescription.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkSubpassDescription.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkSubpassDescription.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkSubpassDescription.calloc(capacity, stack);
    }

    public static VkSubpassDescription malloc(MemoryStack stack) {
        return new VkSubpassDescription(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkSubpassDescription calloc(MemoryStack stack) {
        return new VkSubpassDescription(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLAGS);
    }

    public static int npipelineBindPoint(long struct) {
        return MemoryUtil.memGetInt(struct + (long)PIPELINEBINDPOINT);
    }

    public static int ninputAttachmentCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)INPUTATTACHMENTCOUNT);
    }

    public static @Nullable VkAttachmentReference.Buffer npInputAttachments(long struct) {
        return VkAttachmentReference.createSafe(MemoryUtil.memGetAddress(struct + (long)PINPUTATTACHMENTS), VkSubpassDescription.ninputAttachmentCount(struct));
    }

    public static int ncolorAttachmentCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)COLORATTACHMENTCOUNT);
    }

    public static @Nullable VkAttachmentReference.Buffer npColorAttachments(long struct) {
        return VkAttachmentReference.createSafe(MemoryUtil.memGetAddress(struct + (long)PCOLORATTACHMENTS), VkSubpassDescription.ncolorAttachmentCount(struct));
    }

    public static @Nullable VkAttachmentReference.Buffer npResolveAttachments(long struct) {
        return VkAttachmentReference.createSafe(MemoryUtil.memGetAddress(struct + (long)PRESOLVEATTACHMENTS), VkSubpassDescription.ncolorAttachmentCount(struct));
    }

    public static @Nullable VkAttachmentReference npDepthStencilAttachment(long struct) {
        return VkAttachmentReference.createSafe(MemoryUtil.memGetAddress(struct + (long)PDEPTHSTENCILATTACHMENT));
    }

    public static int npreserveAttachmentCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)PRESERVEATTACHMENTCOUNT);
    }

    public static @Nullable IntBuffer npPreserveAttachments(long struct) {
        return MemoryUtil.memIntBufferSafe(MemoryUtil.memGetAddress(struct + (long)PPRESERVEATTACHMENTS), VkSubpassDescription.npreserveAttachmentCount(struct));
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FLAGS, value);
    }

    public static void npipelineBindPoint(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)PIPELINEBINDPOINT, value);
    }

    public static void ninputAttachmentCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)INPUTATTACHMENTCOUNT, value);
    }

    public static void npInputAttachments(long struct, @Nullable VkAttachmentReference.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PINPUTATTACHMENTS, MemoryUtil.memAddressSafe(value));
        VkSubpassDescription.ninputAttachmentCount(struct, value == null ? 0 : value.remaining());
    }

    public static void ncolorAttachmentCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)COLORATTACHMENTCOUNT, value);
    }

    public static void npColorAttachments(long struct, @Nullable VkAttachmentReference.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PCOLORATTACHMENTS, MemoryUtil.memAddressSafe(value));
    }

    public static void npResolveAttachments(long struct, @Nullable VkAttachmentReference.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PRESOLVEATTACHMENTS, MemoryUtil.memAddressSafe(value));
    }

    public static void npDepthStencilAttachment(long struct, @Nullable VkAttachmentReference value) {
        MemoryUtil.memPutAddress(struct + (long)PDEPTHSTENCILATTACHMENT, MemoryUtil.memAddressSafe(value));
    }

    public static void npreserveAttachmentCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)PRESERVEATTACHMENTCOUNT, value);
    }

    public static void npPreserveAttachments(long struct, @Nullable IntBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PPRESERVEATTACHMENTS, MemoryUtil.memAddressSafe(value));
        VkSubpassDescription.npreserveAttachmentCount(struct, value == null ? 0 : value.remaining());
    }

    public static void validate(long struct) {
        if (VkSubpassDescription.ninputAttachmentCount(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)PINPUTATTACHMENTS));
        }
        if (VkSubpassDescription.ncolorAttachmentCount(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)PCOLORATTACHMENTS));
        }
        if (VkSubpassDescription.npreserveAttachmentCount(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)PPRESERVEATTACHMENTS));
        }
    }

    static {
        Struct.Layout layout = VkSubpassDescription.__struct(VkSubpassDescription.__member(4), VkSubpassDescription.__member(4), VkSubpassDescription.__member(4), VkSubpassDescription.__member(POINTER_SIZE), VkSubpassDescription.__member(4), VkSubpassDescription.__member(POINTER_SIZE), VkSubpassDescription.__member(POINTER_SIZE), VkSubpassDescription.__member(POINTER_SIZE), VkSubpassDescription.__member(4), VkSubpassDescription.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FLAGS = layout.offsetof(0);
        PIPELINEBINDPOINT = layout.offsetof(1);
        INPUTATTACHMENTCOUNT = layout.offsetof(2);
        PINPUTATTACHMENTS = layout.offsetof(3);
        COLORATTACHMENTCOUNT = layout.offsetof(4);
        PCOLORATTACHMENTS = layout.offsetof(5);
        PRESOLVEATTACHMENTS = layout.offsetof(6);
        PDEPTHSTENCILATTACHMENT = layout.offsetof(7);
        PRESERVEATTACHMENTCOUNT = layout.offsetof(8);
        PPRESERVEATTACHMENTS = layout.offsetof(9);
    }

    public static class Buffer
    extends StructBuffer<VkSubpassDescription, Buffer>
    implements NativeResource {
        private static final VkSubpassDescription ELEMENT_FACTORY = VkSubpassDescription.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkSubpassDescription getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkSubpassDescriptionFlags")
        public int flags() {
            return VkSubpassDescription.nflags(this.address());
        }

        @NativeType(value="VkPipelineBindPoint")
        public int pipelineBindPoint() {
            return VkSubpassDescription.npipelineBindPoint(this.address());
        }

        @NativeType(value="uint32_t")
        public int inputAttachmentCount() {
            return VkSubpassDescription.ninputAttachmentCount(this.address());
        }

        @NativeType(value="VkAttachmentReference const *")
        public @Nullable VkAttachmentReference.Buffer pInputAttachments() {
            return VkSubpassDescription.npInputAttachments(this.address());
        }

        @NativeType(value="uint32_t")
        public int colorAttachmentCount() {
            return VkSubpassDescription.ncolorAttachmentCount(this.address());
        }

        @NativeType(value="VkAttachmentReference const *")
        public @Nullable VkAttachmentReference.Buffer pColorAttachments() {
            return VkSubpassDescription.npColorAttachments(this.address());
        }

        @NativeType(value="VkAttachmentReference const *")
        public @Nullable VkAttachmentReference.Buffer pResolveAttachments() {
            return VkSubpassDescription.npResolveAttachments(this.address());
        }

        @NativeType(value="VkAttachmentReference const *")
        public @Nullable VkAttachmentReference pDepthStencilAttachment() {
            return VkSubpassDescription.npDepthStencilAttachment(this.address());
        }

        @NativeType(value="uint32_t")
        public int preserveAttachmentCount() {
            return VkSubpassDescription.npreserveAttachmentCount(this.address());
        }

        @NativeType(value="uint32_t const *")
        public @Nullable IntBuffer pPreserveAttachments() {
            return VkSubpassDescription.npPreserveAttachments(this.address());
        }

        public Buffer flags(@NativeType(value="VkSubpassDescriptionFlags") int value) {
            VkSubpassDescription.nflags(this.address(), value);
            return this;
        }

        public Buffer pipelineBindPoint(@NativeType(value="VkPipelineBindPoint") int value) {
            VkSubpassDescription.npipelineBindPoint(this.address(), value);
            return this;
        }

        public Buffer pInputAttachments(@NativeType(value="VkAttachmentReference const *") @Nullable VkAttachmentReference.Buffer value) {
            VkSubpassDescription.npInputAttachments(this.address(), value);
            return this;
        }

        public Buffer colorAttachmentCount(@NativeType(value="uint32_t") int value) {
            VkSubpassDescription.ncolorAttachmentCount(this.address(), value);
            return this;
        }

        public Buffer pColorAttachments(@NativeType(value="VkAttachmentReference const *") @Nullable VkAttachmentReference.Buffer value) {
            VkSubpassDescription.npColorAttachments(this.address(), value);
            return this;
        }

        public Buffer pResolveAttachments(@NativeType(value="VkAttachmentReference const *") @Nullable VkAttachmentReference.Buffer value) {
            VkSubpassDescription.npResolveAttachments(this.address(), value);
            return this;
        }

        public Buffer pDepthStencilAttachment(@NativeType(value="VkAttachmentReference const *") @Nullable VkAttachmentReference value) {
            VkSubpassDescription.npDepthStencilAttachment(this.address(), value);
            return this;
        }

        public Buffer pPreserveAttachments(@NativeType(value="uint32_t const *") @Nullable IntBuffer value) {
            VkSubpassDescription.npPreserveAttachments(this.address(), value);
            return this;
        }
    }
}

