/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkVideoDecodeAV1PictureInfoKHR;
import org.lwjgl.vulkan.VkVideoDecodeH264PictureInfoKHR;
import org.lwjgl.vulkan.VkVideoDecodeH265PictureInfoKHR;
import org.lwjgl.vulkan.VkVideoInlineQueryInfoKHR;
import org.lwjgl.vulkan.VkVideoPictureResourceInfoKHR;
import org.lwjgl.vulkan.VkVideoReferenceSlotInfoKHR;

public class VkVideoDecodeInfoKHR
extends Struct<VkVideoDecodeInfoKHR>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int SRCBUFFER;
    public static final int SRCBUFFEROFFSET;
    public static final int SRCBUFFERRANGE;
    public static final int DSTPICTURERESOURCE;
    public static final int PSETUPREFERENCESLOT;
    public static final int REFERENCESLOTCOUNT;
    public static final int PREFERENCESLOTS;

    protected VkVideoDecodeInfoKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkVideoDecodeInfoKHR create(long address, @Nullable ByteBuffer container) {
        return new VkVideoDecodeInfoKHR(address, container);
    }

    public VkVideoDecodeInfoKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkVideoDecodeInfoKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkVideoDecodeInfoKHR.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkVideoDecodeInfoKHR.npNext(this.address());
    }

    @NativeType(value="VkVideoDecodeFlagsKHR")
    public int flags() {
        return VkVideoDecodeInfoKHR.nflags(this.address());
    }

    @NativeType(value="VkBuffer")
    public long srcBuffer() {
        return VkVideoDecodeInfoKHR.nsrcBuffer(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long srcBufferOffset() {
        return VkVideoDecodeInfoKHR.nsrcBufferOffset(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long srcBufferRange() {
        return VkVideoDecodeInfoKHR.nsrcBufferRange(this.address());
    }

    public VkVideoPictureResourceInfoKHR dstPictureResource() {
        return VkVideoDecodeInfoKHR.ndstPictureResource(this.address());
    }

    @NativeType(value="VkVideoReferenceSlotInfoKHR const *")
    public @Nullable VkVideoReferenceSlotInfoKHR pSetupReferenceSlot() {
        return VkVideoDecodeInfoKHR.npSetupReferenceSlot(this.address());
    }

    @NativeType(value="uint32_t")
    public int referenceSlotCount() {
        return VkVideoDecodeInfoKHR.nreferenceSlotCount(this.address());
    }

    @NativeType(value="VkVideoReferenceSlotInfoKHR const *")
    public @Nullable VkVideoReferenceSlotInfoKHR.Buffer pReferenceSlots() {
        return VkVideoDecodeInfoKHR.npReferenceSlots(this.address());
    }

    public VkVideoDecodeInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkVideoDecodeInfoKHR.nsType(this.address(), value);
        return this;
    }

    public VkVideoDecodeInfoKHR sType$Default() {
        return this.sType(1000024000);
    }

    public VkVideoDecodeInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkVideoDecodeInfoKHR.npNext(this.address(), value);
        return this;
    }

    public VkVideoDecodeInfoKHR pNext(VkVideoDecodeAV1PictureInfoKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkVideoDecodeInfoKHR pNext(VkVideoDecodeH264PictureInfoKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkVideoDecodeInfoKHR pNext(VkVideoDecodeH265PictureInfoKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkVideoDecodeInfoKHR pNext(VkVideoInlineQueryInfoKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkVideoDecodeInfoKHR flags(@NativeType(value="VkVideoDecodeFlagsKHR") int value) {
        VkVideoDecodeInfoKHR.nflags(this.address(), value);
        return this;
    }

    public VkVideoDecodeInfoKHR srcBuffer(@NativeType(value="VkBuffer") long value) {
        VkVideoDecodeInfoKHR.nsrcBuffer(this.address(), value);
        return this;
    }

    public VkVideoDecodeInfoKHR srcBufferOffset(@NativeType(value="VkDeviceSize") long value) {
        VkVideoDecodeInfoKHR.nsrcBufferOffset(this.address(), value);
        return this;
    }

    public VkVideoDecodeInfoKHR srcBufferRange(@NativeType(value="VkDeviceSize") long value) {
        VkVideoDecodeInfoKHR.nsrcBufferRange(this.address(), value);
        return this;
    }

    public VkVideoDecodeInfoKHR dstPictureResource(VkVideoPictureResourceInfoKHR value) {
        VkVideoDecodeInfoKHR.ndstPictureResource(this.address(), value);
        return this;
    }

    public VkVideoDecodeInfoKHR dstPictureResource(Consumer<VkVideoPictureResourceInfoKHR> consumer) {
        consumer.accept(this.dstPictureResource());
        return this;
    }

    public VkVideoDecodeInfoKHR pSetupReferenceSlot(@NativeType(value="VkVideoReferenceSlotInfoKHR const *") @Nullable VkVideoReferenceSlotInfoKHR value) {
        VkVideoDecodeInfoKHR.npSetupReferenceSlot(this.address(), value);
        return this;
    }

    public VkVideoDecodeInfoKHR pReferenceSlots(@NativeType(value="VkVideoReferenceSlotInfoKHR const *") @Nullable VkVideoReferenceSlotInfoKHR.Buffer value) {
        VkVideoDecodeInfoKHR.npReferenceSlots(this.address(), value);
        return this;
    }

    public VkVideoDecodeInfoKHR set(int sType, long pNext, int flags, long srcBuffer, long srcBufferOffset, long srcBufferRange, VkVideoPictureResourceInfoKHR dstPictureResource, @Nullable VkVideoReferenceSlotInfoKHR pSetupReferenceSlot, @Nullable VkVideoReferenceSlotInfoKHR.Buffer pReferenceSlots) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.srcBuffer(srcBuffer);
        this.srcBufferOffset(srcBufferOffset);
        this.srcBufferRange(srcBufferRange);
        this.dstPictureResource(dstPictureResource);
        this.pSetupReferenceSlot(pSetupReferenceSlot);
        this.pReferenceSlots(pReferenceSlots);
        return this;
    }

    public VkVideoDecodeInfoKHR set(VkVideoDecodeInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkVideoDecodeInfoKHR malloc() {
        return new VkVideoDecodeInfoKHR(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkVideoDecodeInfoKHR calloc() {
        return new VkVideoDecodeInfoKHR(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkVideoDecodeInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkVideoDecodeInfoKHR(MemoryUtil.memAddress(container), container);
    }

    public static VkVideoDecodeInfoKHR create(long address) {
        return new VkVideoDecodeInfoKHR(address, null);
    }

    public static @Nullable VkVideoDecodeInfoKHR createSafe(long address) {
        return address == 0L ? null : new VkVideoDecodeInfoKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkVideoDecodeInfoKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkVideoDecodeInfoKHR.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkVideoDecodeInfoKHR malloc(MemoryStack stack) {
        return new VkVideoDecodeInfoKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkVideoDecodeInfoKHR calloc(MemoryStack stack) {
        return new VkVideoDecodeInfoKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLAGS);
    }

    public static long nsrcBuffer(long struct) {
        return MemoryUtil.memGetLong(struct + (long)SRCBUFFER);
    }

    public static long nsrcBufferOffset(long struct) {
        return MemoryUtil.memGetLong(struct + (long)SRCBUFFEROFFSET);
    }

    public static long nsrcBufferRange(long struct) {
        return MemoryUtil.memGetLong(struct + (long)SRCBUFFERRANGE);
    }

    public static VkVideoPictureResourceInfoKHR ndstPictureResource(long struct) {
        return VkVideoPictureResourceInfoKHR.create(struct + (long)DSTPICTURERESOURCE);
    }

    public static @Nullable VkVideoReferenceSlotInfoKHR npSetupReferenceSlot(long struct) {
        return VkVideoReferenceSlotInfoKHR.createSafe(MemoryUtil.memGetAddress(struct + (long)PSETUPREFERENCESLOT));
    }

    public static int nreferenceSlotCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)REFERENCESLOTCOUNT);
    }

    public static @Nullable VkVideoReferenceSlotInfoKHR.Buffer npReferenceSlots(long struct) {
        return VkVideoReferenceSlotInfoKHR.createSafe(MemoryUtil.memGetAddress(struct + (long)PREFERENCESLOTS), VkVideoDecodeInfoKHR.nreferenceSlotCount(struct));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FLAGS, value);
    }

    public static void nsrcBuffer(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)SRCBUFFER, value);
    }

    public static void nsrcBufferOffset(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)SRCBUFFEROFFSET, value);
    }

    public static void nsrcBufferRange(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)SRCBUFFERRANGE, value);
    }

    public static void ndstPictureResource(long struct, VkVideoPictureResourceInfoKHR value) {
        MemoryUtil.memCopy(value.address(), struct + (long)DSTPICTURERESOURCE, VkVideoPictureResourceInfoKHR.SIZEOF);
    }

    public static void npSetupReferenceSlot(long struct, @Nullable VkVideoReferenceSlotInfoKHR value) {
        MemoryUtil.memPutAddress(struct + (long)PSETUPREFERENCESLOT, MemoryUtil.memAddressSafe(value));
    }

    public static void nreferenceSlotCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)REFERENCESLOTCOUNT, value);
    }

    public static void npReferenceSlots(long struct, @Nullable VkVideoReferenceSlotInfoKHR.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PREFERENCESLOTS, MemoryUtil.memAddressSafe(value));
        VkVideoDecodeInfoKHR.nreferenceSlotCount(struct, value == null ? 0 : value.remaining());
    }

    public static void validate(long struct) {
        if (VkVideoDecodeInfoKHR.nreferenceSlotCount(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)PREFERENCESLOTS));
        }
    }

    static {
        Struct.Layout layout = VkVideoDecodeInfoKHR.__struct(VkVideoDecodeInfoKHR.__member(4), VkVideoDecodeInfoKHR.__member(POINTER_SIZE), VkVideoDecodeInfoKHR.__member(4), VkVideoDecodeInfoKHR.__member(8), VkVideoDecodeInfoKHR.__member(8), VkVideoDecodeInfoKHR.__member(8), VkVideoDecodeInfoKHR.__member(VkVideoPictureResourceInfoKHR.SIZEOF, VkVideoPictureResourceInfoKHR.ALIGNOF), VkVideoDecodeInfoKHR.__member(POINTER_SIZE), VkVideoDecodeInfoKHR.__member(4), VkVideoDecodeInfoKHR.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        SRCBUFFER = layout.offsetof(3);
        SRCBUFFEROFFSET = layout.offsetof(4);
        SRCBUFFERRANGE = layout.offsetof(5);
        DSTPICTURERESOURCE = layout.offsetof(6);
        PSETUPREFERENCESLOT = layout.offsetof(7);
        REFERENCESLOTCOUNT = layout.offsetof(8);
        PREFERENCESLOTS = layout.offsetof(9);
    }

    public static class Buffer
    extends StructBuffer<VkVideoDecodeInfoKHR, Buffer>
    implements NativeResource {
        private static final VkVideoDecodeInfoKHR ELEMENT_FACTORY = VkVideoDecodeInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkVideoDecodeInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkVideoDecodeInfoKHR.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkVideoDecodeInfoKHR.npNext(this.address());
        }

        @NativeType(value="VkVideoDecodeFlagsKHR")
        public int flags() {
            return VkVideoDecodeInfoKHR.nflags(this.address());
        }

        @NativeType(value="VkBuffer")
        public long srcBuffer() {
            return VkVideoDecodeInfoKHR.nsrcBuffer(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long srcBufferOffset() {
            return VkVideoDecodeInfoKHR.nsrcBufferOffset(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long srcBufferRange() {
            return VkVideoDecodeInfoKHR.nsrcBufferRange(this.address());
        }

        public VkVideoPictureResourceInfoKHR dstPictureResource() {
            return VkVideoDecodeInfoKHR.ndstPictureResource(this.address());
        }

        @NativeType(value="VkVideoReferenceSlotInfoKHR const *")
        public @Nullable VkVideoReferenceSlotInfoKHR pSetupReferenceSlot() {
            return VkVideoDecodeInfoKHR.npSetupReferenceSlot(this.address());
        }

        @NativeType(value="uint32_t")
        public int referenceSlotCount() {
            return VkVideoDecodeInfoKHR.nreferenceSlotCount(this.address());
        }

        @NativeType(value="VkVideoReferenceSlotInfoKHR const *")
        public @Nullable VkVideoReferenceSlotInfoKHR.Buffer pReferenceSlots() {
            return VkVideoDecodeInfoKHR.npReferenceSlots(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkVideoDecodeInfoKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000024000);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkVideoDecodeInfoKHR.npNext(this.address(), value);
            return this;
        }

        public Buffer pNext(VkVideoDecodeAV1PictureInfoKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkVideoDecodeH264PictureInfoKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkVideoDecodeH265PictureInfoKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkVideoInlineQueryInfoKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer flags(@NativeType(value="VkVideoDecodeFlagsKHR") int value) {
            VkVideoDecodeInfoKHR.nflags(this.address(), value);
            return this;
        }

        public Buffer srcBuffer(@NativeType(value="VkBuffer") long value) {
            VkVideoDecodeInfoKHR.nsrcBuffer(this.address(), value);
            return this;
        }

        public Buffer srcBufferOffset(@NativeType(value="VkDeviceSize") long value) {
            VkVideoDecodeInfoKHR.nsrcBufferOffset(this.address(), value);
            return this;
        }

        public Buffer srcBufferRange(@NativeType(value="VkDeviceSize") long value) {
            VkVideoDecodeInfoKHR.nsrcBufferRange(this.address(), value);
            return this;
        }

        public Buffer dstPictureResource(VkVideoPictureResourceInfoKHR value) {
            VkVideoDecodeInfoKHR.ndstPictureResource(this.address(), value);
            return this;
        }

        public Buffer dstPictureResource(Consumer<VkVideoPictureResourceInfoKHR> consumer) {
            consumer.accept(this.dstPictureResource());
            return this;
        }

        public Buffer pSetupReferenceSlot(@NativeType(value="VkVideoReferenceSlotInfoKHR const *") @Nullable VkVideoReferenceSlotInfoKHR value) {
            VkVideoDecodeInfoKHR.npSetupReferenceSlot(this.address(), value);
            return this;
        }

        public Buffer pReferenceSlots(@NativeType(value="VkVideoReferenceSlotInfoKHR const *") @Nullable VkVideoReferenceSlotInfoKHR.Buffer value) {
            VkVideoDecodeInfoKHR.npReferenceSlots(this.address(), value);
            return this;
        }
    }
}

