/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.video.StdVideoEncodeAV1PictureInfo;

public class VkVideoEncodeAV1PictureInfoKHR
extends Struct<VkVideoEncodeAV1PictureInfoKHR>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int PREDICTIONMODE;
    public static final int RATECONTROLGROUP;
    public static final int CONSTANTQINDEX;
    public static final int PSTDPICTUREINFO;
    public static final int REFERENCENAMESLOTINDICES;
    public static final int PRIMARYREFERENCECDFONLY;
    public static final int GENERATEOBUEXTENSIONHEADER;

    protected VkVideoEncodeAV1PictureInfoKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkVideoEncodeAV1PictureInfoKHR create(long address, @Nullable ByteBuffer container) {
        return new VkVideoEncodeAV1PictureInfoKHR(address, container);
    }

    public VkVideoEncodeAV1PictureInfoKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkVideoEncodeAV1PictureInfoKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkVideoEncodeAV1PictureInfoKHR.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkVideoEncodeAV1PictureInfoKHR.npNext(this.address());
    }

    @NativeType(value="VkVideoEncodeAV1PredictionModeKHR")
    public int predictionMode() {
        return VkVideoEncodeAV1PictureInfoKHR.npredictionMode(this.address());
    }

    @NativeType(value="VkVideoEncodeAV1RateControlGroupKHR")
    public int rateControlGroup() {
        return VkVideoEncodeAV1PictureInfoKHR.nrateControlGroup(this.address());
    }

    @NativeType(value="uint32_t")
    public int constantQIndex() {
        return VkVideoEncodeAV1PictureInfoKHR.nconstantQIndex(this.address());
    }

    @NativeType(value="StdVideoEncodeAV1PictureInfo const *")
    public StdVideoEncodeAV1PictureInfo pStdPictureInfo() {
        return VkVideoEncodeAV1PictureInfoKHR.npStdPictureInfo(this.address());
    }

    @NativeType(value="int32_t[VK_MAX_VIDEO_AV1_REFERENCES_PER_FRAME_KHR]")
    public IntBuffer referenceNameSlotIndices() {
        return VkVideoEncodeAV1PictureInfoKHR.nreferenceNameSlotIndices(this.address());
    }

    @NativeType(value="int32_t")
    public int referenceNameSlotIndices(int index) {
        return VkVideoEncodeAV1PictureInfoKHR.nreferenceNameSlotIndices(this.address(), index);
    }

    @NativeType(value="VkBool32")
    public boolean primaryReferenceCdfOnly() {
        return VkVideoEncodeAV1PictureInfoKHR.nprimaryReferenceCdfOnly(this.address()) != 0;
    }

    @NativeType(value="VkBool32")
    public boolean generateObuExtensionHeader() {
        return VkVideoEncodeAV1PictureInfoKHR.ngenerateObuExtensionHeader(this.address()) != 0;
    }

    public VkVideoEncodeAV1PictureInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkVideoEncodeAV1PictureInfoKHR.nsType(this.address(), value);
        return this;
    }

    public VkVideoEncodeAV1PictureInfoKHR sType$Default() {
        return this.sType(1000513002);
    }

    public VkVideoEncodeAV1PictureInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkVideoEncodeAV1PictureInfoKHR.npNext(this.address(), value);
        return this;
    }

    public VkVideoEncodeAV1PictureInfoKHR predictionMode(@NativeType(value="VkVideoEncodeAV1PredictionModeKHR") int value) {
        VkVideoEncodeAV1PictureInfoKHR.npredictionMode(this.address(), value);
        return this;
    }

    public VkVideoEncodeAV1PictureInfoKHR rateControlGroup(@NativeType(value="VkVideoEncodeAV1RateControlGroupKHR") int value) {
        VkVideoEncodeAV1PictureInfoKHR.nrateControlGroup(this.address(), value);
        return this;
    }

    public VkVideoEncodeAV1PictureInfoKHR constantQIndex(@NativeType(value="uint32_t") int value) {
        VkVideoEncodeAV1PictureInfoKHR.nconstantQIndex(this.address(), value);
        return this;
    }

    public VkVideoEncodeAV1PictureInfoKHR pStdPictureInfo(@NativeType(value="StdVideoEncodeAV1PictureInfo const *") StdVideoEncodeAV1PictureInfo value) {
        VkVideoEncodeAV1PictureInfoKHR.npStdPictureInfo(this.address(), value);
        return this;
    }

    public VkVideoEncodeAV1PictureInfoKHR referenceNameSlotIndices(@NativeType(value="int32_t[VK_MAX_VIDEO_AV1_REFERENCES_PER_FRAME_KHR]") IntBuffer value) {
        VkVideoEncodeAV1PictureInfoKHR.nreferenceNameSlotIndices(this.address(), value);
        return this;
    }

    public VkVideoEncodeAV1PictureInfoKHR referenceNameSlotIndices(int index, @NativeType(value="int32_t") int value) {
        VkVideoEncodeAV1PictureInfoKHR.nreferenceNameSlotIndices(this.address(), index, value);
        return this;
    }

    public VkVideoEncodeAV1PictureInfoKHR primaryReferenceCdfOnly(@NativeType(value="VkBool32") boolean value) {
        VkVideoEncodeAV1PictureInfoKHR.nprimaryReferenceCdfOnly(this.address(), value ? 1 : 0);
        return this;
    }

    public VkVideoEncodeAV1PictureInfoKHR generateObuExtensionHeader(@NativeType(value="VkBool32") boolean value) {
        VkVideoEncodeAV1PictureInfoKHR.ngenerateObuExtensionHeader(this.address(), value ? 1 : 0);
        return this;
    }

    public VkVideoEncodeAV1PictureInfoKHR set(int sType, long pNext, int predictionMode, int rateControlGroup, int constantQIndex, StdVideoEncodeAV1PictureInfo pStdPictureInfo, IntBuffer referenceNameSlotIndices, boolean primaryReferenceCdfOnly, boolean generateObuExtensionHeader) {
        this.sType(sType);
        this.pNext(pNext);
        this.predictionMode(predictionMode);
        this.rateControlGroup(rateControlGroup);
        this.constantQIndex(constantQIndex);
        this.pStdPictureInfo(pStdPictureInfo);
        this.referenceNameSlotIndices(referenceNameSlotIndices);
        this.primaryReferenceCdfOnly(primaryReferenceCdfOnly);
        this.generateObuExtensionHeader(generateObuExtensionHeader);
        return this;
    }

    public VkVideoEncodeAV1PictureInfoKHR set(VkVideoEncodeAV1PictureInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkVideoEncodeAV1PictureInfoKHR malloc() {
        return new VkVideoEncodeAV1PictureInfoKHR(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkVideoEncodeAV1PictureInfoKHR calloc() {
        return new VkVideoEncodeAV1PictureInfoKHR(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkVideoEncodeAV1PictureInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkVideoEncodeAV1PictureInfoKHR(MemoryUtil.memAddress(container), container);
    }

    public static VkVideoEncodeAV1PictureInfoKHR create(long address) {
        return new VkVideoEncodeAV1PictureInfoKHR(address, null);
    }

    public static @Nullable VkVideoEncodeAV1PictureInfoKHR createSafe(long address) {
        return address == 0L ? null : new VkVideoEncodeAV1PictureInfoKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkVideoEncodeAV1PictureInfoKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkVideoEncodeAV1PictureInfoKHR.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkVideoEncodeAV1PictureInfoKHR malloc(MemoryStack stack) {
        return new VkVideoEncodeAV1PictureInfoKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkVideoEncodeAV1PictureInfoKHR calloc(MemoryStack stack) {
        return new VkVideoEncodeAV1PictureInfoKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int npredictionMode(long struct) {
        return MemoryUtil.memGetInt(struct + (long)PREDICTIONMODE);
    }

    public static int nrateControlGroup(long struct) {
        return MemoryUtil.memGetInt(struct + (long)RATECONTROLGROUP);
    }

    public static int nconstantQIndex(long struct) {
        return MemoryUtil.memGetInt(struct + (long)CONSTANTQINDEX);
    }

    public static StdVideoEncodeAV1PictureInfo npStdPictureInfo(long struct) {
        return StdVideoEncodeAV1PictureInfo.create(MemoryUtil.memGetAddress(struct + (long)PSTDPICTUREINFO));
    }

    public static IntBuffer nreferenceNameSlotIndices(long struct) {
        return MemoryUtil.memIntBuffer(struct + (long)REFERENCENAMESLOTINDICES, 7);
    }

    public static int nreferenceNameSlotIndices(long struct, int index) {
        return MemoryUtil.memGetInt(struct + (long)REFERENCENAMESLOTINDICES + Checks.check(index, 7) * 4L);
    }

    public static int nprimaryReferenceCdfOnly(long struct) {
        return MemoryUtil.memGetInt(struct + (long)PRIMARYREFERENCECDFONLY);
    }

    public static int ngenerateObuExtensionHeader(long struct) {
        return MemoryUtil.memGetInt(struct + (long)GENERATEOBUEXTENSIONHEADER);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void npredictionMode(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)PREDICTIONMODE, value);
    }

    public static void nrateControlGroup(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)RATECONTROLGROUP, value);
    }

    public static void nconstantQIndex(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)CONSTANTQINDEX, value);
    }

    public static void npStdPictureInfo(long struct, StdVideoEncodeAV1PictureInfo value) {
        MemoryUtil.memPutAddress(struct + (long)PSTDPICTUREINFO, value.address());
    }

    public static void nreferenceNameSlotIndices(long struct, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 7);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)REFERENCENAMESLOTINDICES, value.remaining() * 4);
    }

    public static void nreferenceNameSlotIndices(long struct, int index, int value) {
        MemoryUtil.memPutInt(struct + (long)REFERENCENAMESLOTINDICES + Checks.check(index, 7) * 4L, value);
    }

    public static void nprimaryReferenceCdfOnly(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)PRIMARYREFERENCECDFONLY, value);
    }

    public static void ngenerateObuExtensionHeader(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)GENERATEOBUEXTENSIONHEADER, value);
    }

    public static void validate(long struct) {
        long pStdPictureInfo = MemoryUtil.memGetAddress(struct + (long)PSTDPICTUREINFO);
        Checks.check(pStdPictureInfo);
        StdVideoEncodeAV1PictureInfo.validate(pStdPictureInfo);
    }

    static {
        Struct.Layout layout = VkVideoEncodeAV1PictureInfoKHR.__struct(VkVideoEncodeAV1PictureInfoKHR.__member(4), VkVideoEncodeAV1PictureInfoKHR.__member(POINTER_SIZE), VkVideoEncodeAV1PictureInfoKHR.__member(4), VkVideoEncodeAV1PictureInfoKHR.__member(4), VkVideoEncodeAV1PictureInfoKHR.__member(4), VkVideoEncodeAV1PictureInfoKHR.__member(POINTER_SIZE), VkVideoEncodeAV1PictureInfoKHR.__array(4, 7), VkVideoEncodeAV1PictureInfoKHR.__member(4), VkVideoEncodeAV1PictureInfoKHR.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        PREDICTIONMODE = layout.offsetof(2);
        RATECONTROLGROUP = layout.offsetof(3);
        CONSTANTQINDEX = layout.offsetof(4);
        PSTDPICTUREINFO = layout.offsetof(5);
        REFERENCENAMESLOTINDICES = layout.offsetof(6);
        PRIMARYREFERENCECDFONLY = layout.offsetof(7);
        GENERATEOBUEXTENSIONHEADER = layout.offsetof(8);
    }

    public static class Buffer
    extends StructBuffer<VkVideoEncodeAV1PictureInfoKHR, Buffer>
    implements NativeResource {
        private static final VkVideoEncodeAV1PictureInfoKHR ELEMENT_FACTORY = VkVideoEncodeAV1PictureInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkVideoEncodeAV1PictureInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkVideoEncodeAV1PictureInfoKHR.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkVideoEncodeAV1PictureInfoKHR.npNext(this.address());
        }

        @NativeType(value="VkVideoEncodeAV1PredictionModeKHR")
        public int predictionMode() {
            return VkVideoEncodeAV1PictureInfoKHR.npredictionMode(this.address());
        }

        @NativeType(value="VkVideoEncodeAV1RateControlGroupKHR")
        public int rateControlGroup() {
            return VkVideoEncodeAV1PictureInfoKHR.nrateControlGroup(this.address());
        }

        @NativeType(value="uint32_t")
        public int constantQIndex() {
            return VkVideoEncodeAV1PictureInfoKHR.nconstantQIndex(this.address());
        }

        @NativeType(value="StdVideoEncodeAV1PictureInfo const *")
        public StdVideoEncodeAV1PictureInfo pStdPictureInfo() {
            return VkVideoEncodeAV1PictureInfoKHR.npStdPictureInfo(this.address());
        }

        @NativeType(value="int32_t[VK_MAX_VIDEO_AV1_REFERENCES_PER_FRAME_KHR]")
        public IntBuffer referenceNameSlotIndices() {
            return VkVideoEncodeAV1PictureInfoKHR.nreferenceNameSlotIndices(this.address());
        }

        @NativeType(value="int32_t")
        public int referenceNameSlotIndices(int index) {
            return VkVideoEncodeAV1PictureInfoKHR.nreferenceNameSlotIndices(this.address(), index);
        }

        @NativeType(value="VkBool32")
        public boolean primaryReferenceCdfOnly() {
            return VkVideoEncodeAV1PictureInfoKHR.nprimaryReferenceCdfOnly(this.address()) != 0;
        }

        @NativeType(value="VkBool32")
        public boolean generateObuExtensionHeader() {
            return VkVideoEncodeAV1PictureInfoKHR.ngenerateObuExtensionHeader(this.address()) != 0;
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkVideoEncodeAV1PictureInfoKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000513002);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkVideoEncodeAV1PictureInfoKHR.npNext(this.address(), value);
            return this;
        }

        public Buffer predictionMode(@NativeType(value="VkVideoEncodeAV1PredictionModeKHR") int value) {
            VkVideoEncodeAV1PictureInfoKHR.npredictionMode(this.address(), value);
            return this;
        }

        public Buffer rateControlGroup(@NativeType(value="VkVideoEncodeAV1RateControlGroupKHR") int value) {
            VkVideoEncodeAV1PictureInfoKHR.nrateControlGroup(this.address(), value);
            return this;
        }

        public Buffer constantQIndex(@NativeType(value="uint32_t") int value) {
            VkVideoEncodeAV1PictureInfoKHR.nconstantQIndex(this.address(), value);
            return this;
        }

        public Buffer pStdPictureInfo(@NativeType(value="StdVideoEncodeAV1PictureInfo const *") StdVideoEncodeAV1PictureInfo value) {
            VkVideoEncodeAV1PictureInfoKHR.npStdPictureInfo(this.address(), value);
            return this;
        }

        public Buffer referenceNameSlotIndices(@NativeType(value="int32_t[VK_MAX_VIDEO_AV1_REFERENCES_PER_FRAME_KHR]") IntBuffer value) {
            VkVideoEncodeAV1PictureInfoKHR.nreferenceNameSlotIndices(this.address(), value);
            return this;
        }

        public Buffer referenceNameSlotIndices(int index, @NativeType(value="int32_t") int value) {
            VkVideoEncodeAV1PictureInfoKHR.nreferenceNameSlotIndices(this.address(), index, value);
            return this;
        }

        public Buffer primaryReferenceCdfOnly(@NativeType(value="VkBool32") boolean value) {
            VkVideoEncodeAV1PictureInfoKHR.nprimaryReferenceCdfOnly(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer generateObuExtensionHeader(@NativeType(value="VkBool32") boolean value) {
            VkVideoEncodeAV1PictureInfoKHR.ngenerateObuExtensionHeader(this.address(), value ? 1 : 0);
            return this;
        }
    }
}

