/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkVideoEncodeH265FrameSizeKHR
extends Struct<VkVideoEncodeH265FrameSizeKHR>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FRAMEISIZE;
    public static final int FRAMEPSIZE;
    public static final int FRAMEBSIZE;

    protected VkVideoEncodeH265FrameSizeKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkVideoEncodeH265FrameSizeKHR create(long address, @Nullable ByteBuffer container) {
        return new VkVideoEncodeH265FrameSizeKHR(address, container);
    }

    public VkVideoEncodeH265FrameSizeKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkVideoEncodeH265FrameSizeKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int frameISize() {
        return VkVideoEncodeH265FrameSizeKHR.nframeISize(this.address());
    }

    @NativeType(value="uint32_t")
    public int framePSize() {
        return VkVideoEncodeH265FrameSizeKHR.nframePSize(this.address());
    }

    @NativeType(value="uint32_t")
    public int frameBSize() {
        return VkVideoEncodeH265FrameSizeKHR.nframeBSize(this.address());
    }

    public VkVideoEncodeH265FrameSizeKHR frameISize(@NativeType(value="uint32_t") int value) {
        VkVideoEncodeH265FrameSizeKHR.nframeISize(this.address(), value);
        return this;
    }

    public VkVideoEncodeH265FrameSizeKHR framePSize(@NativeType(value="uint32_t") int value) {
        VkVideoEncodeH265FrameSizeKHR.nframePSize(this.address(), value);
        return this;
    }

    public VkVideoEncodeH265FrameSizeKHR frameBSize(@NativeType(value="uint32_t") int value) {
        VkVideoEncodeH265FrameSizeKHR.nframeBSize(this.address(), value);
        return this;
    }

    public VkVideoEncodeH265FrameSizeKHR set(int frameISize, int framePSize, int frameBSize) {
        this.frameISize(frameISize);
        this.framePSize(framePSize);
        this.frameBSize(frameBSize);
        return this;
    }

    public VkVideoEncodeH265FrameSizeKHR set(VkVideoEncodeH265FrameSizeKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkVideoEncodeH265FrameSizeKHR malloc() {
        return new VkVideoEncodeH265FrameSizeKHR(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkVideoEncodeH265FrameSizeKHR calloc() {
        return new VkVideoEncodeH265FrameSizeKHR(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkVideoEncodeH265FrameSizeKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkVideoEncodeH265FrameSizeKHR(MemoryUtil.memAddress(container), container);
    }

    public static VkVideoEncodeH265FrameSizeKHR create(long address) {
        return new VkVideoEncodeH265FrameSizeKHR(address, null);
    }

    public static @Nullable VkVideoEncodeH265FrameSizeKHR createSafe(long address) {
        return address == 0L ? null : new VkVideoEncodeH265FrameSizeKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkVideoEncodeH265FrameSizeKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkVideoEncodeH265FrameSizeKHR.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkVideoEncodeH265FrameSizeKHR malloc(MemoryStack stack) {
        return new VkVideoEncodeH265FrameSizeKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkVideoEncodeH265FrameSizeKHR calloc(MemoryStack stack) {
        return new VkVideoEncodeH265FrameSizeKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nframeISize(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FRAMEISIZE);
    }

    public static int nframePSize(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FRAMEPSIZE);
    }

    public static int nframeBSize(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FRAMEBSIZE);
    }

    public static void nframeISize(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FRAMEISIZE, value);
    }

    public static void nframePSize(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FRAMEPSIZE, value);
    }

    public static void nframeBSize(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FRAMEBSIZE, value);
    }

    static {
        Struct.Layout layout = VkVideoEncodeH265FrameSizeKHR.__struct(VkVideoEncodeH265FrameSizeKHR.__member(4), VkVideoEncodeH265FrameSizeKHR.__member(4), VkVideoEncodeH265FrameSizeKHR.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FRAMEISIZE = layout.offsetof(0);
        FRAMEPSIZE = layout.offsetof(1);
        FRAMEBSIZE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkVideoEncodeH265FrameSizeKHR, Buffer>
    implements NativeResource {
        private static final VkVideoEncodeH265FrameSizeKHR ELEMENT_FACTORY = VkVideoEncodeH265FrameSizeKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkVideoEncodeH265FrameSizeKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint32_t")
        public int frameISize() {
            return VkVideoEncodeH265FrameSizeKHR.nframeISize(this.address());
        }

        @NativeType(value="uint32_t")
        public int framePSize() {
            return VkVideoEncodeH265FrameSizeKHR.nframePSize(this.address());
        }

        @NativeType(value="uint32_t")
        public int frameBSize() {
            return VkVideoEncodeH265FrameSizeKHR.nframeBSize(this.address());
        }

        public Buffer frameISize(@NativeType(value="uint32_t") int value) {
            VkVideoEncodeH265FrameSizeKHR.nframeISize(this.address(), value);
            return this;
        }

        public Buffer framePSize(@NativeType(value="uint32_t") int value) {
            VkVideoEncodeH265FrameSizeKHR.nframePSize(this.address(), value);
            return this;
        }

        public Buffer frameBSize(@NativeType(value="uint32_t") int value) {
            VkVideoEncodeH265FrameSizeKHR.nframeBSize(this.address(), value);
            return this;
        }
    }
}

