/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkVideoEncodeAV1PictureInfoKHR;
import org.lwjgl.vulkan.VkVideoEncodeH264PictureInfoKHR;
import org.lwjgl.vulkan.VkVideoEncodeH265PictureInfoKHR;
import org.lwjgl.vulkan.VkVideoEncodeQuantizationMapInfoKHR;
import org.lwjgl.vulkan.VkVideoInlineQueryInfoKHR;
import org.lwjgl.vulkan.VkVideoPictureResourceInfoKHR;
import org.lwjgl.vulkan.VkVideoReferenceSlotInfoKHR;

public class VkVideoEncodeInfoKHR
extends Struct<VkVideoEncodeInfoKHR>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int DSTBUFFER;
    public static final int DSTBUFFEROFFSET;
    public static final int DSTBUFFERRANGE;
    public static final int SRCPICTURERESOURCE;
    public static final int PSETUPREFERENCESLOT;
    public static final int REFERENCESLOTCOUNT;
    public static final int PREFERENCESLOTS;
    public static final int PRECEDINGEXTERNALLYENCODEDBYTES;

    protected VkVideoEncodeInfoKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkVideoEncodeInfoKHR create(long address, @Nullable ByteBuffer container) {
        return new VkVideoEncodeInfoKHR(address, container);
    }

    public VkVideoEncodeInfoKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkVideoEncodeInfoKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkVideoEncodeInfoKHR.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkVideoEncodeInfoKHR.npNext(this.address());
    }

    @NativeType(value="VkVideoEncodeFlagsKHR")
    public int flags() {
        return VkVideoEncodeInfoKHR.nflags(this.address());
    }

    @NativeType(value="VkBuffer")
    public long dstBuffer() {
        return VkVideoEncodeInfoKHR.ndstBuffer(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long dstBufferOffset() {
        return VkVideoEncodeInfoKHR.ndstBufferOffset(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long dstBufferRange() {
        return VkVideoEncodeInfoKHR.ndstBufferRange(this.address());
    }

    public VkVideoPictureResourceInfoKHR srcPictureResource() {
        return VkVideoEncodeInfoKHR.nsrcPictureResource(this.address());
    }

    @NativeType(value="VkVideoReferenceSlotInfoKHR const *")
    public @Nullable VkVideoReferenceSlotInfoKHR pSetupReferenceSlot() {
        return VkVideoEncodeInfoKHR.npSetupReferenceSlot(this.address());
    }

    @NativeType(value="uint32_t")
    public int referenceSlotCount() {
        return VkVideoEncodeInfoKHR.nreferenceSlotCount(this.address());
    }

    @NativeType(value="VkVideoReferenceSlotInfoKHR const *")
    public @Nullable VkVideoReferenceSlotInfoKHR.Buffer pReferenceSlots() {
        return VkVideoEncodeInfoKHR.npReferenceSlots(this.address());
    }

    @NativeType(value="uint32_t")
    public int precedingExternallyEncodedBytes() {
        return VkVideoEncodeInfoKHR.nprecedingExternallyEncodedBytes(this.address());
    }

    public VkVideoEncodeInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkVideoEncodeInfoKHR.nsType(this.address(), value);
        return this;
    }

    public VkVideoEncodeInfoKHR sType$Default() {
        return this.sType(1000299000);
    }

    public VkVideoEncodeInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkVideoEncodeInfoKHR.npNext(this.address(), value);
        return this;
    }

    public VkVideoEncodeInfoKHR pNext(VkVideoEncodeAV1PictureInfoKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkVideoEncodeInfoKHR pNext(VkVideoEncodeH264PictureInfoKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkVideoEncodeInfoKHR pNext(VkVideoEncodeH265PictureInfoKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkVideoEncodeInfoKHR pNext(VkVideoEncodeQuantizationMapInfoKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkVideoEncodeInfoKHR pNext(VkVideoInlineQueryInfoKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkVideoEncodeInfoKHR flags(@NativeType(value="VkVideoEncodeFlagsKHR") int value) {
        VkVideoEncodeInfoKHR.nflags(this.address(), value);
        return this;
    }

    public VkVideoEncodeInfoKHR dstBuffer(@NativeType(value="VkBuffer") long value) {
        VkVideoEncodeInfoKHR.ndstBuffer(this.address(), value);
        return this;
    }

    public VkVideoEncodeInfoKHR dstBufferOffset(@NativeType(value="VkDeviceSize") long value) {
        VkVideoEncodeInfoKHR.ndstBufferOffset(this.address(), value);
        return this;
    }

    public VkVideoEncodeInfoKHR dstBufferRange(@NativeType(value="VkDeviceSize") long value) {
        VkVideoEncodeInfoKHR.ndstBufferRange(this.address(), value);
        return this;
    }

    public VkVideoEncodeInfoKHR srcPictureResource(VkVideoPictureResourceInfoKHR value) {
        VkVideoEncodeInfoKHR.nsrcPictureResource(this.address(), value);
        return this;
    }

    public VkVideoEncodeInfoKHR srcPictureResource(Consumer<VkVideoPictureResourceInfoKHR> consumer) {
        consumer.accept(this.srcPictureResource());
        return this;
    }

    public VkVideoEncodeInfoKHR pSetupReferenceSlot(@NativeType(value="VkVideoReferenceSlotInfoKHR const *") @Nullable VkVideoReferenceSlotInfoKHR value) {
        VkVideoEncodeInfoKHR.npSetupReferenceSlot(this.address(), value);
        return this;
    }

    public VkVideoEncodeInfoKHR pReferenceSlots(@NativeType(value="VkVideoReferenceSlotInfoKHR const *") @Nullable VkVideoReferenceSlotInfoKHR.Buffer value) {
        VkVideoEncodeInfoKHR.npReferenceSlots(this.address(), value);
        return this;
    }

    public VkVideoEncodeInfoKHR precedingExternallyEncodedBytes(@NativeType(value="uint32_t") int value) {
        VkVideoEncodeInfoKHR.nprecedingExternallyEncodedBytes(this.address(), value);
        return this;
    }

    public VkVideoEncodeInfoKHR set(int sType, long pNext, int flags, long dstBuffer, long dstBufferOffset, long dstBufferRange, VkVideoPictureResourceInfoKHR srcPictureResource, @Nullable VkVideoReferenceSlotInfoKHR pSetupReferenceSlot, @Nullable VkVideoReferenceSlotInfoKHR.Buffer pReferenceSlots, int precedingExternallyEncodedBytes) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.dstBuffer(dstBuffer);
        this.dstBufferOffset(dstBufferOffset);
        this.dstBufferRange(dstBufferRange);
        this.srcPictureResource(srcPictureResource);
        this.pSetupReferenceSlot(pSetupReferenceSlot);
        this.pReferenceSlots(pReferenceSlots);
        this.precedingExternallyEncodedBytes(precedingExternallyEncodedBytes);
        return this;
    }

    public VkVideoEncodeInfoKHR set(VkVideoEncodeInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkVideoEncodeInfoKHR malloc() {
        return new VkVideoEncodeInfoKHR(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkVideoEncodeInfoKHR calloc() {
        return new VkVideoEncodeInfoKHR(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkVideoEncodeInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkVideoEncodeInfoKHR(MemoryUtil.memAddress(container), container);
    }

    public static VkVideoEncodeInfoKHR create(long address) {
        return new VkVideoEncodeInfoKHR(address, null);
    }

    public static @Nullable VkVideoEncodeInfoKHR createSafe(long address) {
        return address == 0L ? null : new VkVideoEncodeInfoKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkVideoEncodeInfoKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkVideoEncodeInfoKHR.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkVideoEncodeInfoKHR malloc(MemoryStack stack) {
        return new VkVideoEncodeInfoKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkVideoEncodeInfoKHR calloc(MemoryStack stack) {
        return new VkVideoEncodeInfoKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLAGS);
    }

    public static long ndstBuffer(long struct) {
        return MemoryUtil.memGetLong(struct + (long)DSTBUFFER);
    }

    public static long ndstBufferOffset(long struct) {
        return MemoryUtil.memGetLong(struct + (long)DSTBUFFEROFFSET);
    }

    public static long ndstBufferRange(long struct) {
        return MemoryUtil.memGetLong(struct + (long)DSTBUFFERRANGE);
    }

    public static VkVideoPictureResourceInfoKHR nsrcPictureResource(long struct) {
        return VkVideoPictureResourceInfoKHR.create(struct + (long)SRCPICTURERESOURCE);
    }

    public static @Nullable VkVideoReferenceSlotInfoKHR npSetupReferenceSlot(long struct) {
        return VkVideoReferenceSlotInfoKHR.createSafe(MemoryUtil.memGetAddress(struct + (long)PSETUPREFERENCESLOT));
    }

    public static int nreferenceSlotCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)REFERENCESLOTCOUNT);
    }

    public static @Nullable VkVideoReferenceSlotInfoKHR.Buffer npReferenceSlots(long struct) {
        return VkVideoReferenceSlotInfoKHR.createSafe(MemoryUtil.memGetAddress(struct + (long)PREFERENCESLOTS), VkVideoEncodeInfoKHR.nreferenceSlotCount(struct));
    }

    public static int nprecedingExternallyEncodedBytes(long struct) {
        return MemoryUtil.memGetInt(struct + (long)PRECEDINGEXTERNALLYENCODEDBYTES);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FLAGS, value);
    }

    public static void ndstBuffer(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)DSTBUFFER, value);
    }

    public static void ndstBufferOffset(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)DSTBUFFEROFFSET, value);
    }

    public static void ndstBufferRange(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)DSTBUFFERRANGE, value);
    }

    public static void nsrcPictureResource(long struct, VkVideoPictureResourceInfoKHR value) {
        MemoryUtil.memCopy(value.address(), struct + (long)SRCPICTURERESOURCE, VkVideoPictureResourceInfoKHR.SIZEOF);
    }

    public static void npSetupReferenceSlot(long struct, @Nullable VkVideoReferenceSlotInfoKHR value) {
        MemoryUtil.memPutAddress(struct + (long)PSETUPREFERENCESLOT, MemoryUtil.memAddressSafe(value));
    }

    public static void nreferenceSlotCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)REFERENCESLOTCOUNT, value);
    }

    public static void npReferenceSlots(long struct, @Nullable VkVideoReferenceSlotInfoKHR.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PREFERENCESLOTS, MemoryUtil.memAddressSafe(value));
        VkVideoEncodeInfoKHR.nreferenceSlotCount(struct, value == null ? 0 : value.remaining());
    }

    public static void nprecedingExternallyEncodedBytes(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)PRECEDINGEXTERNALLYENCODEDBYTES, value);
    }

    public static void validate(long struct) {
        if (VkVideoEncodeInfoKHR.nreferenceSlotCount(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)PREFERENCESLOTS));
        }
    }

    static {
        Struct.Layout layout = VkVideoEncodeInfoKHR.__struct(VkVideoEncodeInfoKHR.__member(4), VkVideoEncodeInfoKHR.__member(POINTER_SIZE), VkVideoEncodeInfoKHR.__member(4), VkVideoEncodeInfoKHR.__member(8), VkVideoEncodeInfoKHR.__member(8), VkVideoEncodeInfoKHR.__member(8), VkVideoEncodeInfoKHR.__member(VkVideoPictureResourceInfoKHR.SIZEOF, VkVideoPictureResourceInfoKHR.ALIGNOF), VkVideoEncodeInfoKHR.__member(POINTER_SIZE), VkVideoEncodeInfoKHR.__member(4), VkVideoEncodeInfoKHR.__member(POINTER_SIZE), VkVideoEncodeInfoKHR.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        DSTBUFFER = layout.offsetof(3);
        DSTBUFFEROFFSET = layout.offsetof(4);
        DSTBUFFERRANGE = layout.offsetof(5);
        SRCPICTURERESOURCE = layout.offsetof(6);
        PSETUPREFERENCESLOT = layout.offsetof(7);
        REFERENCESLOTCOUNT = layout.offsetof(8);
        PREFERENCESLOTS = layout.offsetof(9);
        PRECEDINGEXTERNALLYENCODEDBYTES = layout.offsetof(10);
    }

    public static class Buffer
    extends StructBuffer<VkVideoEncodeInfoKHR, Buffer>
    implements NativeResource {
        private static final VkVideoEncodeInfoKHR ELEMENT_FACTORY = VkVideoEncodeInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkVideoEncodeInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkVideoEncodeInfoKHR.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkVideoEncodeInfoKHR.npNext(this.address());
        }

        @NativeType(value="VkVideoEncodeFlagsKHR")
        public int flags() {
            return VkVideoEncodeInfoKHR.nflags(this.address());
        }

        @NativeType(value="VkBuffer")
        public long dstBuffer() {
            return VkVideoEncodeInfoKHR.ndstBuffer(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long dstBufferOffset() {
            return VkVideoEncodeInfoKHR.ndstBufferOffset(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long dstBufferRange() {
            return VkVideoEncodeInfoKHR.ndstBufferRange(this.address());
        }

        public VkVideoPictureResourceInfoKHR srcPictureResource() {
            return VkVideoEncodeInfoKHR.nsrcPictureResource(this.address());
        }

        @NativeType(value="VkVideoReferenceSlotInfoKHR const *")
        public @Nullable VkVideoReferenceSlotInfoKHR pSetupReferenceSlot() {
            return VkVideoEncodeInfoKHR.npSetupReferenceSlot(this.address());
        }

        @NativeType(value="uint32_t")
        public int referenceSlotCount() {
            return VkVideoEncodeInfoKHR.nreferenceSlotCount(this.address());
        }

        @NativeType(value="VkVideoReferenceSlotInfoKHR const *")
        public @Nullable VkVideoReferenceSlotInfoKHR.Buffer pReferenceSlots() {
            return VkVideoEncodeInfoKHR.npReferenceSlots(this.address());
        }

        @NativeType(value="uint32_t")
        public int precedingExternallyEncodedBytes() {
            return VkVideoEncodeInfoKHR.nprecedingExternallyEncodedBytes(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkVideoEncodeInfoKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000299000);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkVideoEncodeInfoKHR.npNext(this.address(), value);
            return this;
        }

        public Buffer pNext(VkVideoEncodeAV1PictureInfoKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkVideoEncodeH264PictureInfoKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkVideoEncodeH265PictureInfoKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkVideoEncodeQuantizationMapInfoKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkVideoInlineQueryInfoKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer flags(@NativeType(value="VkVideoEncodeFlagsKHR") int value) {
            VkVideoEncodeInfoKHR.nflags(this.address(), value);
            return this;
        }

        public Buffer dstBuffer(@NativeType(value="VkBuffer") long value) {
            VkVideoEncodeInfoKHR.ndstBuffer(this.address(), value);
            return this;
        }

        public Buffer dstBufferOffset(@NativeType(value="VkDeviceSize") long value) {
            VkVideoEncodeInfoKHR.ndstBufferOffset(this.address(), value);
            return this;
        }

        public Buffer dstBufferRange(@NativeType(value="VkDeviceSize") long value) {
            VkVideoEncodeInfoKHR.ndstBufferRange(this.address(), value);
            return this;
        }

        public Buffer srcPictureResource(VkVideoPictureResourceInfoKHR value) {
            VkVideoEncodeInfoKHR.nsrcPictureResource(this.address(), value);
            return this;
        }

        public Buffer srcPictureResource(Consumer<VkVideoPictureResourceInfoKHR> consumer) {
            consumer.accept(this.srcPictureResource());
            return this;
        }

        public Buffer pSetupReferenceSlot(@NativeType(value="VkVideoReferenceSlotInfoKHR const *") @Nullable VkVideoReferenceSlotInfoKHR value) {
            VkVideoEncodeInfoKHR.npSetupReferenceSlot(this.address(), value);
            return this;
        }

        public Buffer pReferenceSlots(@NativeType(value="VkVideoReferenceSlotInfoKHR const *") @Nullable VkVideoReferenceSlotInfoKHR.Buffer value) {
            VkVideoEncodeInfoKHR.npReferenceSlots(this.address(), value);
            return this;
        }

        public Buffer precedingExternallyEncodedBytes(@NativeType(value="uint32_t") int value) {
            VkVideoEncodeInfoKHR.nprecedingExternallyEncodedBytes(this.address(), value);
            return this;
        }
    }
}

