/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkWin32SurfaceCreateInfoKHR
extends Struct<VkWin32SurfaceCreateInfoKHR>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int HINSTANCE;
    public static final int HWND;

    protected VkWin32SurfaceCreateInfoKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkWin32SurfaceCreateInfoKHR create(long address, @Nullable ByteBuffer container) {
        return new VkWin32SurfaceCreateInfoKHR(address, container);
    }

    public VkWin32SurfaceCreateInfoKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkWin32SurfaceCreateInfoKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkWin32SurfaceCreateInfoKHR.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkWin32SurfaceCreateInfoKHR.npNext(this.address());
    }

    @NativeType(value="VkWin32SurfaceCreateFlagsKHR")
    public int flags() {
        return VkWin32SurfaceCreateInfoKHR.nflags(this.address());
    }

    @NativeType(value="HINSTANCE")
    public long hinstance() {
        return VkWin32SurfaceCreateInfoKHR.nhinstance(this.address());
    }

    @NativeType(value="HWND")
    public long hwnd() {
        return VkWin32SurfaceCreateInfoKHR.nhwnd(this.address());
    }

    public VkWin32SurfaceCreateInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkWin32SurfaceCreateInfoKHR.nsType(this.address(), value);
        return this;
    }

    public VkWin32SurfaceCreateInfoKHR sType$Default() {
        return this.sType(1000009000);
    }

    public VkWin32SurfaceCreateInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkWin32SurfaceCreateInfoKHR.npNext(this.address(), value);
        return this;
    }

    public VkWin32SurfaceCreateInfoKHR flags(@NativeType(value="VkWin32SurfaceCreateFlagsKHR") int value) {
        VkWin32SurfaceCreateInfoKHR.nflags(this.address(), value);
        return this;
    }

    public VkWin32SurfaceCreateInfoKHR hinstance(@NativeType(value="HINSTANCE") long value) {
        VkWin32SurfaceCreateInfoKHR.nhinstance(this.address(), value);
        return this;
    }

    public VkWin32SurfaceCreateInfoKHR hwnd(@NativeType(value="HWND") long value) {
        VkWin32SurfaceCreateInfoKHR.nhwnd(this.address(), value);
        return this;
    }

    public VkWin32SurfaceCreateInfoKHR set(int sType, long pNext, int flags, long hinstance, long hwnd) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.hinstance(hinstance);
        this.hwnd(hwnd);
        return this;
    }

    public VkWin32SurfaceCreateInfoKHR set(VkWin32SurfaceCreateInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkWin32SurfaceCreateInfoKHR malloc() {
        return new VkWin32SurfaceCreateInfoKHR(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkWin32SurfaceCreateInfoKHR calloc() {
        return new VkWin32SurfaceCreateInfoKHR(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkWin32SurfaceCreateInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkWin32SurfaceCreateInfoKHR(MemoryUtil.memAddress(container), container);
    }

    public static VkWin32SurfaceCreateInfoKHR create(long address) {
        return new VkWin32SurfaceCreateInfoKHR(address, null);
    }

    public static @Nullable VkWin32SurfaceCreateInfoKHR createSafe(long address) {
        return address == 0L ? null : new VkWin32SurfaceCreateInfoKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkWin32SurfaceCreateInfoKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkWin32SurfaceCreateInfoKHR.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkWin32SurfaceCreateInfoKHR mallocStack() {
        return VkWin32SurfaceCreateInfoKHR.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkWin32SurfaceCreateInfoKHR callocStack() {
        return VkWin32SurfaceCreateInfoKHR.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkWin32SurfaceCreateInfoKHR mallocStack(MemoryStack stack) {
        return VkWin32SurfaceCreateInfoKHR.malloc(stack);
    }

    @Deprecated
    public static VkWin32SurfaceCreateInfoKHR callocStack(MemoryStack stack) {
        return VkWin32SurfaceCreateInfoKHR.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkWin32SurfaceCreateInfoKHR.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkWin32SurfaceCreateInfoKHR.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkWin32SurfaceCreateInfoKHR.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkWin32SurfaceCreateInfoKHR.calloc(capacity, stack);
    }

    public static VkWin32SurfaceCreateInfoKHR malloc(MemoryStack stack) {
        return new VkWin32SurfaceCreateInfoKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkWin32SurfaceCreateInfoKHR calloc(MemoryStack stack) {
        return new VkWin32SurfaceCreateInfoKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLAGS);
    }

    public static long nhinstance(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)HINSTANCE);
    }

    public static long nhwnd(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)HWND);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FLAGS, value);
    }

    public static void nhinstance(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)HINSTANCE, Checks.check(value));
    }

    public static void nhwnd(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)HWND, Checks.check(value));
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)HINSTANCE));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)HWND));
    }

    static {
        Struct.Layout layout = VkWin32SurfaceCreateInfoKHR.__struct(VkWin32SurfaceCreateInfoKHR.__member(4), VkWin32SurfaceCreateInfoKHR.__member(POINTER_SIZE), VkWin32SurfaceCreateInfoKHR.__member(4), VkWin32SurfaceCreateInfoKHR.__member(POINTER_SIZE), VkWin32SurfaceCreateInfoKHR.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        HINSTANCE = layout.offsetof(3);
        HWND = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkWin32SurfaceCreateInfoKHR, Buffer>
    implements NativeResource {
        private static final VkWin32SurfaceCreateInfoKHR ELEMENT_FACTORY = VkWin32SurfaceCreateInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkWin32SurfaceCreateInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkWin32SurfaceCreateInfoKHR.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkWin32SurfaceCreateInfoKHR.npNext(this.address());
        }

        @NativeType(value="VkWin32SurfaceCreateFlagsKHR")
        public int flags() {
            return VkWin32SurfaceCreateInfoKHR.nflags(this.address());
        }

        @NativeType(value="HINSTANCE")
        public long hinstance() {
            return VkWin32SurfaceCreateInfoKHR.nhinstance(this.address());
        }

        @NativeType(value="HWND")
        public long hwnd() {
            return VkWin32SurfaceCreateInfoKHR.nhwnd(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkWin32SurfaceCreateInfoKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000009000);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkWin32SurfaceCreateInfoKHR.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkWin32SurfaceCreateFlagsKHR") int value) {
            VkWin32SurfaceCreateInfoKHR.nflags(this.address(), value);
            return this;
        }

        public Buffer hinstance(@NativeType(value="HINSTANCE") long value) {
            VkWin32SurfaceCreateInfoKHR.nhinstance(this.address(), value);
            return this;
        }

        public Buffer hwnd(@NativeType(value="HWND") long value) {
            VkWin32SurfaceCreateInfoKHR.nhwnd(this.address(), value);
            return this;
        }
    }
}

