/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkDescriptorBufferInfo;
import org.lwjgl.vulkan.VkDescriptorImageInfo;
import org.lwjgl.vulkan.VkWriteDescriptorSetAccelerationStructureKHR;
import org.lwjgl.vulkan.VkWriteDescriptorSetAccelerationStructureNV;
import org.lwjgl.vulkan.VkWriteDescriptorSetInlineUniformBlock;
import org.lwjgl.vulkan.VkWriteDescriptorSetInlineUniformBlockEXT;

public class VkWriteDescriptorSet
extends Struct<VkWriteDescriptorSet>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int DSTSET;
    public static final int DSTBINDING;
    public static final int DSTARRAYELEMENT;
    public static final int DESCRIPTORCOUNT;
    public static final int DESCRIPTORTYPE;
    public static final int PIMAGEINFO;
    public static final int PBUFFERINFO;
    public static final int PTEXELBUFFERVIEW;

    protected VkWriteDescriptorSet(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkWriteDescriptorSet create(long address, @Nullable ByteBuffer container) {
        return new VkWriteDescriptorSet(address, container);
    }

    public VkWriteDescriptorSet(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkWriteDescriptorSet.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkWriteDescriptorSet.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkWriteDescriptorSet.npNext(this.address());
    }

    @NativeType(value="VkDescriptorSet")
    public long dstSet() {
        return VkWriteDescriptorSet.ndstSet(this.address());
    }

    @NativeType(value="uint32_t")
    public int dstBinding() {
        return VkWriteDescriptorSet.ndstBinding(this.address());
    }

    @NativeType(value="uint32_t")
    public int dstArrayElement() {
        return VkWriteDescriptorSet.ndstArrayElement(this.address());
    }

    @NativeType(value="uint32_t")
    public int descriptorCount() {
        return VkWriteDescriptorSet.ndescriptorCount(this.address());
    }

    @NativeType(value="VkDescriptorType")
    public int descriptorType() {
        return VkWriteDescriptorSet.ndescriptorType(this.address());
    }

    @NativeType(value="VkDescriptorImageInfo const *")
    public @Nullable VkDescriptorImageInfo.Buffer pImageInfo() {
        return VkWriteDescriptorSet.npImageInfo(this.address());
    }

    @NativeType(value="VkDescriptorBufferInfo const *")
    public @Nullable VkDescriptorBufferInfo.Buffer pBufferInfo() {
        return VkWriteDescriptorSet.npBufferInfo(this.address());
    }

    @NativeType(value="VkBufferView const *")
    public @Nullable LongBuffer pTexelBufferView() {
        return VkWriteDescriptorSet.npTexelBufferView(this.address());
    }

    public VkWriteDescriptorSet sType(@NativeType(value="VkStructureType") int value) {
        VkWriteDescriptorSet.nsType(this.address(), value);
        return this;
    }

    public VkWriteDescriptorSet sType$Default() {
        return this.sType(35);
    }

    public VkWriteDescriptorSet pNext(@NativeType(value="void const *") long value) {
        VkWriteDescriptorSet.npNext(this.address(), value);
        return this;
    }

    public VkWriteDescriptorSet pNext(VkWriteDescriptorSetAccelerationStructureKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkWriteDescriptorSet pNext(VkWriteDescriptorSetAccelerationStructureNV value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkWriteDescriptorSet pNext(VkWriteDescriptorSetInlineUniformBlock value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkWriteDescriptorSet pNext(VkWriteDescriptorSetInlineUniformBlockEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkWriteDescriptorSet dstSet(@NativeType(value="VkDescriptorSet") long value) {
        VkWriteDescriptorSet.ndstSet(this.address(), value);
        return this;
    }

    public VkWriteDescriptorSet dstBinding(@NativeType(value="uint32_t") int value) {
        VkWriteDescriptorSet.ndstBinding(this.address(), value);
        return this;
    }

    public VkWriteDescriptorSet dstArrayElement(@NativeType(value="uint32_t") int value) {
        VkWriteDescriptorSet.ndstArrayElement(this.address(), value);
        return this;
    }

    public VkWriteDescriptorSet descriptorCount(@NativeType(value="uint32_t") int value) {
        VkWriteDescriptorSet.ndescriptorCount(this.address(), value);
        return this;
    }

    public VkWriteDescriptorSet descriptorType(@NativeType(value="VkDescriptorType") int value) {
        VkWriteDescriptorSet.ndescriptorType(this.address(), value);
        return this;
    }

    public VkWriteDescriptorSet pImageInfo(@NativeType(value="VkDescriptorImageInfo const *") @Nullable VkDescriptorImageInfo.Buffer value) {
        VkWriteDescriptorSet.npImageInfo(this.address(), value);
        return this;
    }

    public VkWriteDescriptorSet pBufferInfo(@NativeType(value="VkDescriptorBufferInfo const *") @Nullable VkDescriptorBufferInfo.Buffer value) {
        VkWriteDescriptorSet.npBufferInfo(this.address(), value);
        return this;
    }

    public VkWriteDescriptorSet pTexelBufferView(@NativeType(value="VkBufferView const *") @Nullable LongBuffer value) {
        VkWriteDescriptorSet.npTexelBufferView(this.address(), value);
        return this;
    }

    public VkWriteDescriptorSet set(int sType, long pNext, long dstSet, int dstBinding, int dstArrayElement, int descriptorCount, int descriptorType, @Nullable VkDescriptorImageInfo.Buffer pImageInfo, @Nullable VkDescriptorBufferInfo.Buffer pBufferInfo, @Nullable LongBuffer pTexelBufferView) {
        this.sType(sType);
        this.pNext(pNext);
        this.dstSet(dstSet);
        this.dstBinding(dstBinding);
        this.dstArrayElement(dstArrayElement);
        this.descriptorCount(descriptorCount);
        this.descriptorType(descriptorType);
        this.pImageInfo(pImageInfo);
        this.pBufferInfo(pBufferInfo);
        this.pTexelBufferView(pTexelBufferView);
        return this;
    }

    public VkWriteDescriptorSet set(VkWriteDescriptorSet src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkWriteDescriptorSet malloc() {
        return new VkWriteDescriptorSet(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkWriteDescriptorSet calloc() {
        return new VkWriteDescriptorSet(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkWriteDescriptorSet create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkWriteDescriptorSet(MemoryUtil.memAddress(container), container);
    }

    public static VkWriteDescriptorSet create(long address) {
        return new VkWriteDescriptorSet(address, null);
    }

    public static @Nullable VkWriteDescriptorSet createSafe(long address) {
        return address == 0L ? null : new VkWriteDescriptorSet(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkWriteDescriptorSet.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkWriteDescriptorSet.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkWriteDescriptorSet mallocStack() {
        return VkWriteDescriptorSet.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkWriteDescriptorSet callocStack() {
        return VkWriteDescriptorSet.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkWriteDescriptorSet mallocStack(MemoryStack stack) {
        return VkWriteDescriptorSet.malloc(stack);
    }

    @Deprecated
    public static VkWriteDescriptorSet callocStack(MemoryStack stack) {
        return VkWriteDescriptorSet.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkWriteDescriptorSet.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkWriteDescriptorSet.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkWriteDescriptorSet.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkWriteDescriptorSet.calloc(capacity, stack);
    }

    public static VkWriteDescriptorSet malloc(MemoryStack stack) {
        return new VkWriteDescriptorSet(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkWriteDescriptorSet calloc(MemoryStack stack) {
        return new VkWriteDescriptorSet(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static long ndstSet(long struct) {
        return MemoryUtil.memGetLong(struct + (long)DSTSET);
    }

    public static int ndstBinding(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DSTBINDING);
    }

    public static int ndstArrayElement(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DSTARRAYELEMENT);
    }

    public static int ndescriptorCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DESCRIPTORCOUNT);
    }

    public static int ndescriptorType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DESCRIPTORTYPE);
    }

    public static @Nullable VkDescriptorImageInfo.Buffer npImageInfo(long struct) {
        return VkDescriptorImageInfo.createSafe(MemoryUtil.memGetAddress(struct + (long)PIMAGEINFO), VkWriteDescriptorSet.ndescriptorCount(struct));
    }

    public static @Nullable VkDescriptorBufferInfo.Buffer npBufferInfo(long struct) {
        return VkDescriptorBufferInfo.createSafe(MemoryUtil.memGetAddress(struct + (long)PBUFFERINFO), VkWriteDescriptorSet.ndescriptorCount(struct));
    }

    public static @Nullable LongBuffer npTexelBufferView(long struct) {
        return MemoryUtil.memLongBufferSafe(MemoryUtil.memGetAddress(struct + (long)PTEXELBUFFERVIEW), VkWriteDescriptorSet.ndescriptorCount(struct));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void ndstSet(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)DSTSET, value);
    }

    public static void ndstBinding(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DSTBINDING, value);
    }

    public static void ndstArrayElement(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DSTARRAYELEMENT, value);
    }

    public static void ndescriptorCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DESCRIPTORCOUNT, value);
    }

    public static void ndescriptorType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DESCRIPTORTYPE, value);
    }

    public static void npImageInfo(long struct, @Nullable VkDescriptorImageInfo.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PIMAGEINFO, MemoryUtil.memAddressSafe(value));
    }

    public static void npBufferInfo(long struct, @Nullable VkDescriptorBufferInfo.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PBUFFERINFO, MemoryUtil.memAddressSafe(value));
    }

    public static void npTexelBufferView(long struct, @Nullable LongBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PTEXELBUFFERVIEW, MemoryUtil.memAddressSafe(value));
    }

    static {
        Struct.Layout layout = VkWriteDescriptorSet.__struct(VkWriteDescriptorSet.__member(4), VkWriteDescriptorSet.__member(POINTER_SIZE), VkWriteDescriptorSet.__member(8), VkWriteDescriptorSet.__member(4), VkWriteDescriptorSet.__member(4), VkWriteDescriptorSet.__member(4), VkWriteDescriptorSet.__member(4), VkWriteDescriptorSet.__member(POINTER_SIZE), VkWriteDescriptorSet.__member(POINTER_SIZE), VkWriteDescriptorSet.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        DSTSET = layout.offsetof(2);
        DSTBINDING = layout.offsetof(3);
        DSTARRAYELEMENT = layout.offsetof(4);
        DESCRIPTORCOUNT = layout.offsetof(5);
        DESCRIPTORTYPE = layout.offsetof(6);
        PIMAGEINFO = layout.offsetof(7);
        PBUFFERINFO = layout.offsetof(8);
        PTEXELBUFFERVIEW = layout.offsetof(9);
    }

    public static class Buffer
    extends StructBuffer<VkWriteDescriptorSet, Buffer>
    implements NativeResource {
        private static final VkWriteDescriptorSet ELEMENT_FACTORY = VkWriteDescriptorSet.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkWriteDescriptorSet getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkWriteDescriptorSet.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkWriteDescriptorSet.npNext(this.address());
        }

        @NativeType(value="VkDescriptorSet")
        public long dstSet() {
            return VkWriteDescriptorSet.ndstSet(this.address());
        }

        @NativeType(value="uint32_t")
        public int dstBinding() {
            return VkWriteDescriptorSet.ndstBinding(this.address());
        }

        @NativeType(value="uint32_t")
        public int dstArrayElement() {
            return VkWriteDescriptorSet.ndstArrayElement(this.address());
        }

        @NativeType(value="uint32_t")
        public int descriptorCount() {
            return VkWriteDescriptorSet.ndescriptorCount(this.address());
        }

        @NativeType(value="VkDescriptorType")
        public int descriptorType() {
            return VkWriteDescriptorSet.ndescriptorType(this.address());
        }

        @NativeType(value="VkDescriptorImageInfo const *")
        public @Nullable VkDescriptorImageInfo.Buffer pImageInfo() {
            return VkWriteDescriptorSet.npImageInfo(this.address());
        }

        @NativeType(value="VkDescriptorBufferInfo const *")
        public @Nullable VkDescriptorBufferInfo.Buffer pBufferInfo() {
            return VkWriteDescriptorSet.npBufferInfo(this.address());
        }

        @NativeType(value="VkBufferView const *")
        public @Nullable LongBuffer pTexelBufferView() {
            return VkWriteDescriptorSet.npTexelBufferView(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkWriteDescriptorSet.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(35);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkWriteDescriptorSet.npNext(this.address(), value);
            return this;
        }

        public Buffer pNext(VkWriteDescriptorSetAccelerationStructureKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkWriteDescriptorSetAccelerationStructureNV value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkWriteDescriptorSetInlineUniformBlock value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkWriteDescriptorSetInlineUniformBlockEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer dstSet(@NativeType(value="VkDescriptorSet") long value) {
            VkWriteDescriptorSet.ndstSet(this.address(), value);
            return this;
        }

        public Buffer dstBinding(@NativeType(value="uint32_t") int value) {
            VkWriteDescriptorSet.ndstBinding(this.address(), value);
            return this;
        }

        public Buffer dstArrayElement(@NativeType(value="uint32_t") int value) {
            VkWriteDescriptorSet.ndstArrayElement(this.address(), value);
            return this;
        }

        public Buffer descriptorCount(@NativeType(value="uint32_t") int value) {
            VkWriteDescriptorSet.ndescriptorCount(this.address(), value);
            return this;
        }

        public Buffer descriptorType(@NativeType(value="VkDescriptorType") int value) {
            VkWriteDescriptorSet.ndescriptorType(this.address(), value);
            return this;
        }

        public Buffer pImageInfo(@NativeType(value="VkDescriptorImageInfo const *") @Nullable VkDescriptorImageInfo.Buffer value) {
            VkWriteDescriptorSet.npImageInfo(this.address(), value);
            return this;
        }

        public Buffer pBufferInfo(@NativeType(value="VkDescriptorBufferInfo const *") @Nullable VkDescriptorBufferInfo.Buffer value) {
            VkWriteDescriptorSet.npBufferInfo(this.address(), value);
            return this;
        }

        public Buffer pTexelBufferView(@NativeType(value="VkBufferView const *") @Nullable LongBuffer value) {
            VkWriteDescriptorSet.npTexelBufferView(this.address(), value);
            return this;
        }
    }
}

