/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkWriteDescriptorSetAccelerationStructureKHR
extends Struct<VkWriteDescriptorSetAccelerationStructureKHR>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int ACCELERATIONSTRUCTURECOUNT;
    public static final int PACCELERATIONSTRUCTURES;

    protected VkWriteDescriptorSetAccelerationStructureKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkWriteDescriptorSetAccelerationStructureKHR create(long address, @Nullable ByteBuffer container) {
        return new VkWriteDescriptorSetAccelerationStructureKHR(address, container);
    }

    public VkWriteDescriptorSetAccelerationStructureKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkWriteDescriptorSetAccelerationStructureKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkWriteDescriptorSetAccelerationStructureKHR.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkWriteDescriptorSetAccelerationStructureKHR.npNext(this.address());
    }

    @NativeType(value="uint32_t")
    public int accelerationStructureCount() {
        return VkWriteDescriptorSetAccelerationStructureKHR.naccelerationStructureCount(this.address());
    }

    @NativeType(value="VkAccelerationStructureKHR const *")
    public @Nullable LongBuffer pAccelerationStructures() {
        return VkWriteDescriptorSetAccelerationStructureKHR.npAccelerationStructures(this.address());
    }

    public VkWriteDescriptorSetAccelerationStructureKHR sType(@NativeType(value="VkStructureType") int value) {
        VkWriteDescriptorSetAccelerationStructureKHR.nsType(this.address(), value);
        return this;
    }

    public VkWriteDescriptorSetAccelerationStructureKHR sType$Default() {
        return this.sType(1000150007);
    }

    public VkWriteDescriptorSetAccelerationStructureKHR pNext(@NativeType(value="void const *") long value) {
        VkWriteDescriptorSetAccelerationStructureKHR.npNext(this.address(), value);
        return this;
    }

    public VkWriteDescriptorSetAccelerationStructureKHR accelerationStructureCount(@NativeType(value="uint32_t") int value) {
        VkWriteDescriptorSetAccelerationStructureKHR.naccelerationStructureCount(this.address(), value);
        return this;
    }

    public VkWriteDescriptorSetAccelerationStructureKHR pAccelerationStructures(@NativeType(value="VkAccelerationStructureKHR const *") @Nullable LongBuffer value) {
        VkWriteDescriptorSetAccelerationStructureKHR.npAccelerationStructures(this.address(), value);
        return this;
    }

    public VkWriteDescriptorSetAccelerationStructureKHR set(int sType, long pNext, int accelerationStructureCount, @Nullable LongBuffer pAccelerationStructures) {
        this.sType(sType);
        this.pNext(pNext);
        this.accelerationStructureCount(accelerationStructureCount);
        this.pAccelerationStructures(pAccelerationStructures);
        return this;
    }

    public VkWriteDescriptorSetAccelerationStructureKHR set(VkWriteDescriptorSetAccelerationStructureKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkWriteDescriptorSetAccelerationStructureKHR malloc() {
        return new VkWriteDescriptorSetAccelerationStructureKHR(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkWriteDescriptorSetAccelerationStructureKHR calloc() {
        return new VkWriteDescriptorSetAccelerationStructureKHR(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkWriteDescriptorSetAccelerationStructureKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkWriteDescriptorSetAccelerationStructureKHR(MemoryUtil.memAddress(container), container);
    }

    public static VkWriteDescriptorSetAccelerationStructureKHR create(long address) {
        return new VkWriteDescriptorSetAccelerationStructureKHR(address, null);
    }

    public static @Nullable VkWriteDescriptorSetAccelerationStructureKHR createSafe(long address) {
        return address == 0L ? null : new VkWriteDescriptorSetAccelerationStructureKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkWriteDescriptorSetAccelerationStructureKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkWriteDescriptorSetAccelerationStructureKHR.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkWriteDescriptorSetAccelerationStructureKHR malloc(MemoryStack stack) {
        return new VkWriteDescriptorSetAccelerationStructureKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkWriteDescriptorSetAccelerationStructureKHR calloc(MemoryStack stack) {
        return new VkWriteDescriptorSetAccelerationStructureKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int naccelerationStructureCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ACCELERATIONSTRUCTURECOUNT);
    }

    public static @Nullable LongBuffer npAccelerationStructures(long struct) {
        return MemoryUtil.memLongBufferSafe(MemoryUtil.memGetAddress(struct + (long)PACCELERATIONSTRUCTURES), VkWriteDescriptorSetAccelerationStructureKHR.naccelerationStructureCount(struct));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void naccelerationStructureCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)ACCELERATIONSTRUCTURECOUNT, value);
    }

    public static void npAccelerationStructures(long struct, @Nullable LongBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PACCELERATIONSTRUCTURES, MemoryUtil.memAddressSafe(value));
        if (value != null) {
            VkWriteDescriptorSetAccelerationStructureKHR.naccelerationStructureCount(struct, value.remaining());
        }
    }

    static {
        Struct.Layout layout = VkWriteDescriptorSetAccelerationStructureKHR.__struct(VkWriteDescriptorSetAccelerationStructureKHR.__member(4), VkWriteDescriptorSetAccelerationStructureKHR.__member(POINTER_SIZE), VkWriteDescriptorSetAccelerationStructureKHR.__member(4), VkWriteDescriptorSetAccelerationStructureKHR.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        ACCELERATIONSTRUCTURECOUNT = layout.offsetof(2);
        PACCELERATIONSTRUCTURES = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkWriteDescriptorSetAccelerationStructureKHR, Buffer>
    implements NativeResource {
        private static final VkWriteDescriptorSetAccelerationStructureKHR ELEMENT_FACTORY = VkWriteDescriptorSetAccelerationStructureKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkWriteDescriptorSetAccelerationStructureKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkWriteDescriptorSetAccelerationStructureKHR.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkWriteDescriptorSetAccelerationStructureKHR.npNext(this.address());
        }

        @NativeType(value="uint32_t")
        public int accelerationStructureCount() {
            return VkWriteDescriptorSetAccelerationStructureKHR.naccelerationStructureCount(this.address());
        }

        @NativeType(value="VkAccelerationStructureKHR const *")
        public @Nullable LongBuffer pAccelerationStructures() {
            return VkWriteDescriptorSetAccelerationStructureKHR.npAccelerationStructures(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkWriteDescriptorSetAccelerationStructureKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000150007);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkWriteDescriptorSetAccelerationStructureKHR.npNext(this.address(), value);
            return this;
        }

        public Buffer accelerationStructureCount(@NativeType(value="uint32_t") int value) {
            VkWriteDescriptorSetAccelerationStructureKHR.naccelerationStructureCount(this.address(), value);
            return this;
        }

        public Buffer pAccelerationStructures(@NativeType(value="VkAccelerationStructureKHR const *") @Nullable LongBuffer value) {
            VkWriteDescriptorSetAccelerationStructureKHR.npAccelerationStructures(this.address(), value);
            return this;
        }
    }
}

