/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkXYColorEXT
extends Struct<VkXYColorEXT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int X;
    public static final int Y;

    protected VkXYColorEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkXYColorEXT create(long address, @Nullable ByteBuffer container) {
        return new VkXYColorEXT(address, container);
    }

    public VkXYColorEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkXYColorEXT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public float x() {
        return VkXYColorEXT.nx(this.address());
    }

    public float y() {
        return VkXYColorEXT.ny(this.address());
    }

    public VkXYColorEXT x(float value) {
        VkXYColorEXT.nx(this.address(), value);
        return this;
    }

    public VkXYColorEXT y(float value) {
        VkXYColorEXT.ny(this.address(), value);
        return this;
    }

    public VkXYColorEXT set(float x, float y) {
        this.x(x);
        this.y(y);
        return this;
    }

    public VkXYColorEXT set(VkXYColorEXT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkXYColorEXT malloc() {
        return new VkXYColorEXT(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkXYColorEXT calloc() {
        return new VkXYColorEXT(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkXYColorEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkXYColorEXT(MemoryUtil.memAddress(container), container);
    }

    public static VkXYColorEXT create(long address) {
        return new VkXYColorEXT(address, null);
    }

    public static @Nullable VkXYColorEXT createSafe(long address) {
        return address == 0L ? null : new VkXYColorEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkXYColorEXT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkXYColorEXT.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkXYColorEXT mallocStack() {
        return VkXYColorEXT.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkXYColorEXT callocStack() {
        return VkXYColorEXT.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkXYColorEXT mallocStack(MemoryStack stack) {
        return VkXYColorEXT.malloc(stack);
    }

    @Deprecated
    public static VkXYColorEXT callocStack(MemoryStack stack) {
        return VkXYColorEXT.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkXYColorEXT.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkXYColorEXT.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkXYColorEXT.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkXYColorEXT.calloc(capacity, stack);
    }

    public static VkXYColorEXT malloc(MemoryStack stack) {
        return new VkXYColorEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkXYColorEXT calloc(MemoryStack stack) {
        return new VkXYColorEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static float nx(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)X);
    }

    public static float ny(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)Y);
    }

    public static void nx(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)X, value);
    }

    public static void ny(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)Y, value);
    }

    static {
        Struct.Layout layout = VkXYColorEXT.__struct(VkXYColorEXT.__member(4), VkXYColorEXT.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        X = layout.offsetof(0);
        Y = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VkXYColorEXT, Buffer>
    implements NativeResource {
        private static final VkXYColorEXT ELEMENT_FACTORY = VkXYColorEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkXYColorEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public float x() {
            return VkXYColorEXT.nx(this.address());
        }

        public float y() {
            return VkXYColorEXT.ny(this.address());
        }

        public Buffer x(float value) {
            VkXYColorEXT.nx(this.address(), value);
            return this;
        }

        public Buffer y(float value) {
            VkXYColorEXT.ny(this.address(), value);
            return this;
        }
    }
}

