/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan.video;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.video.StdVideoEncodeAV1ExtensionHeader;
import org.lwjgl.vulkan.video.StdVideoEncodeAV1ReferenceInfoFlags;

public class StdVideoEncodeAV1ReferenceInfo
extends Struct<StdVideoEncodeAV1ReferenceInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FLAGS;
    public static final int REFFRAMEID;
    public static final int FRAME_TYPE;
    public static final int ORDERHINT;
    public static final int RESERVED1;
    public static final int PEXTENSIONHEADER;

    protected StdVideoEncodeAV1ReferenceInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected StdVideoEncodeAV1ReferenceInfo create(long address, @Nullable ByteBuffer container) {
        return new StdVideoEncodeAV1ReferenceInfo(address, container);
    }

    public StdVideoEncodeAV1ReferenceInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), StdVideoEncodeAV1ReferenceInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public StdVideoEncodeAV1ReferenceInfoFlags flags() {
        return StdVideoEncodeAV1ReferenceInfo.nflags(this.address());
    }

    @NativeType(value="uint32_t")
    public int RefFrameId() {
        return StdVideoEncodeAV1ReferenceInfo.nRefFrameId(this.address());
    }

    @NativeType(value="StdVideoAV1FrameType")
    public int frame_type() {
        return StdVideoEncodeAV1ReferenceInfo.nframe_type(this.address());
    }

    @NativeType(value="uint8_t")
    public byte OrderHint() {
        return StdVideoEncodeAV1ReferenceInfo.nOrderHint(this.address());
    }

    @NativeType(value="StdVideoEncodeAV1ExtensionHeader const *")
    public StdVideoEncodeAV1ExtensionHeader pExtensionHeader() {
        return StdVideoEncodeAV1ReferenceInfo.npExtensionHeader(this.address());
    }

    public StdVideoEncodeAV1ReferenceInfo flags(StdVideoEncodeAV1ReferenceInfoFlags value) {
        StdVideoEncodeAV1ReferenceInfo.nflags(this.address(), value);
        return this;
    }

    public StdVideoEncodeAV1ReferenceInfo flags(Consumer<StdVideoEncodeAV1ReferenceInfoFlags> consumer) {
        consumer.accept(this.flags());
        return this;
    }

    public StdVideoEncodeAV1ReferenceInfo RefFrameId(@NativeType(value="uint32_t") int value) {
        StdVideoEncodeAV1ReferenceInfo.nRefFrameId(this.address(), value);
        return this;
    }

    public StdVideoEncodeAV1ReferenceInfo frame_type(@NativeType(value="StdVideoAV1FrameType") int value) {
        StdVideoEncodeAV1ReferenceInfo.nframe_type(this.address(), value);
        return this;
    }

    public StdVideoEncodeAV1ReferenceInfo OrderHint(@NativeType(value="uint8_t") byte value) {
        StdVideoEncodeAV1ReferenceInfo.nOrderHint(this.address(), value);
        return this;
    }

    public StdVideoEncodeAV1ReferenceInfo pExtensionHeader(@NativeType(value="StdVideoEncodeAV1ExtensionHeader const *") StdVideoEncodeAV1ExtensionHeader value) {
        StdVideoEncodeAV1ReferenceInfo.npExtensionHeader(this.address(), value);
        return this;
    }

    public StdVideoEncodeAV1ReferenceInfo set(StdVideoEncodeAV1ReferenceInfoFlags flags, int RefFrameId, int frame_type, byte OrderHint, StdVideoEncodeAV1ExtensionHeader pExtensionHeader) {
        this.flags(flags);
        this.RefFrameId(RefFrameId);
        this.frame_type(frame_type);
        this.OrderHint(OrderHint);
        this.pExtensionHeader(pExtensionHeader);
        return this;
    }

    public StdVideoEncodeAV1ReferenceInfo set(StdVideoEncodeAV1ReferenceInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static StdVideoEncodeAV1ReferenceInfo malloc() {
        return new StdVideoEncodeAV1ReferenceInfo(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static StdVideoEncodeAV1ReferenceInfo calloc() {
        return new StdVideoEncodeAV1ReferenceInfo(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static StdVideoEncodeAV1ReferenceInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new StdVideoEncodeAV1ReferenceInfo(MemoryUtil.memAddress(container), container);
    }

    public static StdVideoEncodeAV1ReferenceInfo create(long address) {
        return new StdVideoEncodeAV1ReferenceInfo(address, null);
    }

    public static @Nullable StdVideoEncodeAV1ReferenceInfo createSafe(long address) {
        return address == 0L ? null : new StdVideoEncodeAV1ReferenceInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(StdVideoEncodeAV1ReferenceInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = StdVideoEncodeAV1ReferenceInfo.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static StdVideoEncodeAV1ReferenceInfo malloc(MemoryStack stack) {
        return new StdVideoEncodeAV1ReferenceInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static StdVideoEncodeAV1ReferenceInfo calloc(MemoryStack stack) {
        return new StdVideoEncodeAV1ReferenceInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static StdVideoEncodeAV1ReferenceInfoFlags nflags(long struct) {
        return StdVideoEncodeAV1ReferenceInfoFlags.create(struct + (long)FLAGS);
    }

    public static int nRefFrameId(long struct) {
        return MemoryUtil.memGetInt(struct + (long)REFFRAMEID);
    }

    public static int nframe_type(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FRAME_TYPE);
    }

    public static byte nOrderHint(long struct) {
        return MemoryUtil.memGetByte(struct + (long)ORDERHINT);
    }

    public static ByteBuffer nreserved1(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)RESERVED1, 3);
    }

    public static byte nreserved1(long struct, int index) {
        return MemoryUtil.memGetByte(struct + (long)RESERVED1 + Checks.check(index, 3) * 1L);
    }

    public static StdVideoEncodeAV1ExtensionHeader npExtensionHeader(long struct) {
        return StdVideoEncodeAV1ExtensionHeader.create(MemoryUtil.memGetAddress(struct + (long)PEXTENSIONHEADER));
    }

    public static void nflags(long struct, StdVideoEncodeAV1ReferenceInfoFlags value) {
        MemoryUtil.memCopy(value.address(), struct + (long)FLAGS, StdVideoEncodeAV1ReferenceInfoFlags.SIZEOF);
    }

    public static void nRefFrameId(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)REFFRAMEID, value);
    }

    public static void nframe_type(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FRAME_TYPE, value);
    }

    public static void nOrderHint(long struct, byte value) {
        MemoryUtil.memPutByte(struct + (long)ORDERHINT, value);
    }

    public static void nreserved1(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 3);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)RESERVED1, value.remaining() * 1);
    }

    public static void nreserved1(long struct, int index, byte value) {
        MemoryUtil.memPutByte(struct + (long)RESERVED1 + Checks.check(index, 3) * 1L, value);
    }

    public static void npExtensionHeader(long struct, StdVideoEncodeAV1ExtensionHeader value) {
        MemoryUtil.memPutAddress(struct + (long)PEXTENSIONHEADER, value.address());
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PEXTENSIONHEADER));
    }

    static {
        Struct.Layout layout = StdVideoEncodeAV1ReferenceInfo.__struct(StdVideoEncodeAV1ReferenceInfo.__member(StdVideoEncodeAV1ReferenceInfoFlags.SIZEOF, StdVideoEncodeAV1ReferenceInfoFlags.ALIGNOF), StdVideoEncodeAV1ReferenceInfo.__member(4), StdVideoEncodeAV1ReferenceInfo.__member(4), StdVideoEncodeAV1ReferenceInfo.__member(1), StdVideoEncodeAV1ReferenceInfo.__array(1, 3), StdVideoEncodeAV1ReferenceInfo.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FLAGS = layout.offsetof(0);
        REFFRAMEID = layout.offsetof(1);
        FRAME_TYPE = layout.offsetof(2);
        ORDERHINT = layout.offsetof(3);
        RESERVED1 = layout.offsetof(4);
        PEXTENSIONHEADER = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<StdVideoEncodeAV1ReferenceInfo, Buffer>
    implements NativeResource {
        private static final StdVideoEncodeAV1ReferenceInfo ELEMENT_FACTORY = StdVideoEncodeAV1ReferenceInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected StdVideoEncodeAV1ReferenceInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public StdVideoEncodeAV1ReferenceInfoFlags flags() {
            return StdVideoEncodeAV1ReferenceInfo.nflags(this.address());
        }

        @NativeType(value="uint32_t")
        public int RefFrameId() {
            return StdVideoEncodeAV1ReferenceInfo.nRefFrameId(this.address());
        }

        @NativeType(value="StdVideoAV1FrameType")
        public int frame_type() {
            return StdVideoEncodeAV1ReferenceInfo.nframe_type(this.address());
        }

        @NativeType(value="uint8_t")
        public byte OrderHint() {
            return StdVideoEncodeAV1ReferenceInfo.nOrderHint(this.address());
        }

        @NativeType(value="StdVideoEncodeAV1ExtensionHeader const *")
        public StdVideoEncodeAV1ExtensionHeader pExtensionHeader() {
            return StdVideoEncodeAV1ReferenceInfo.npExtensionHeader(this.address());
        }

        public Buffer flags(StdVideoEncodeAV1ReferenceInfoFlags value) {
            StdVideoEncodeAV1ReferenceInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer flags(Consumer<StdVideoEncodeAV1ReferenceInfoFlags> consumer) {
            consumer.accept(this.flags());
            return this;
        }

        public Buffer RefFrameId(@NativeType(value="uint32_t") int value) {
            StdVideoEncodeAV1ReferenceInfo.nRefFrameId(this.address(), value);
            return this;
        }

        public Buffer frame_type(@NativeType(value="StdVideoAV1FrameType") int value) {
            StdVideoEncodeAV1ReferenceInfo.nframe_type(this.address(), value);
            return this;
        }

        public Buffer OrderHint(@NativeType(value="uint8_t") byte value) {
            StdVideoEncodeAV1ReferenceInfo.nOrderHint(this.address(), value);
            return this;
        }

        public Buffer pExtensionHeader(@NativeType(value="StdVideoEncodeAV1ExtensionHeader const *") StdVideoEncodeAV1ExtensionHeader value) {
            StdVideoEncodeAV1ReferenceInfo.npExtensionHeader(this.address(), value);
            return this;
        }
    }
}

