/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan.video;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class StdVideoEncodeH265LongTermRefPics
extends Struct<StdVideoEncodeH265LongTermRefPics>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int NUM_LONG_TERM_SPS;
    public static final int NUM_LONG_TERM_PICS;
    public static final int LT_IDX_SPS;
    public static final int POC_LSB_LT;
    public static final int USED_BY_CURR_PIC_LT_FLAG;
    public static final int DELTA_POC_MSB_PRESENT_FLAG;
    public static final int DELTA_POC_MSB_CYCLE_LT;

    protected StdVideoEncodeH265LongTermRefPics(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected StdVideoEncodeH265LongTermRefPics create(long address, @Nullable ByteBuffer container) {
        return new StdVideoEncodeH265LongTermRefPics(address, container);
    }

    public StdVideoEncodeH265LongTermRefPics(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), StdVideoEncodeH265LongTermRefPics.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint8_t")
    public byte num_long_term_sps() {
        return StdVideoEncodeH265LongTermRefPics.nnum_long_term_sps(this.address());
    }

    @NativeType(value="uint8_t")
    public byte num_long_term_pics() {
        return StdVideoEncodeH265LongTermRefPics.nnum_long_term_pics(this.address());
    }

    @NativeType(value="uint8_t[STD_VIDEO_H265_MAX_LONG_TERM_REF_PICS_SPS]")
    public ByteBuffer lt_idx_sps() {
        return StdVideoEncodeH265LongTermRefPics.nlt_idx_sps(this.address());
    }

    @NativeType(value="uint8_t")
    public byte lt_idx_sps(int index) {
        return StdVideoEncodeH265LongTermRefPics.nlt_idx_sps(this.address(), index);
    }

    @NativeType(value="uint8_t[STD_VIDEO_H265_MAX_LONG_TERM_PICS]")
    public ByteBuffer poc_lsb_lt() {
        return StdVideoEncodeH265LongTermRefPics.npoc_lsb_lt(this.address());
    }

    @NativeType(value="uint8_t")
    public byte poc_lsb_lt(int index) {
        return StdVideoEncodeH265LongTermRefPics.npoc_lsb_lt(this.address(), index);
    }

    @NativeType(value="uint16_t")
    public short used_by_curr_pic_lt_flag() {
        return StdVideoEncodeH265LongTermRefPics.nused_by_curr_pic_lt_flag(this.address());
    }

    @NativeType(value="uint8_t[STD_VIDEO_H265_MAX_DELTA_POC]")
    public ByteBuffer delta_poc_msb_present_flag() {
        return StdVideoEncodeH265LongTermRefPics.ndelta_poc_msb_present_flag(this.address());
    }

    @NativeType(value="uint8_t")
    public byte delta_poc_msb_present_flag(int index) {
        return StdVideoEncodeH265LongTermRefPics.ndelta_poc_msb_present_flag(this.address(), index);
    }

    @NativeType(value="uint8_t[STD_VIDEO_H265_MAX_DELTA_POC]")
    public ByteBuffer delta_poc_msb_cycle_lt() {
        return StdVideoEncodeH265LongTermRefPics.ndelta_poc_msb_cycle_lt(this.address());
    }

    @NativeType(value="uint8_t")
    public byte delta_poc_msb_cycle_lt(int index) {
        return StdVideoEncodeH265LongTermRefPics.ndelta_poc_msb_cycle_lt(this.address(), index);
    }

    public StdVideoEncodeH265LongTermRefPics num_long_term_sps(@NativeType(value="uint8_t") byte value) {
        StdVideoEncodeH265LongTermRefPics.nnum_long_term_sps(this.address(), value);
        return this;
    }

    public StdVideoEncodeH265LongTermRefPics num_long_term_pics(@NativeType(value="uint8_t") byte value) {
        StdVideoEncodeH265LongTermRefPics.nnum_long_term_pics(this.address(), value);
        return this;
    }

    public StdVideoEncodeH265LongTermRefPics lt_idx_sps(@NativeType(value="uint8_t[STD_VIDEO_H265_MAX_LONG_TERM_REF_PICS_SPS]") ByteBuffer value) {
        StdVideoEncodeH265LongTermRefPics.nlt_idx_sps(this.address(), value);
        return this;
    }

    public StdVideoEncodeH265LongTermRefPics lt_idx_sps(int index, @NativeType(value="uint8_t") byte value) {
        StdVideoEncodeH265LongTermRefPics.nlt_idx_sps(this.address(), index, value);
        return this;
    }

    public StdVideoEncodeH265LongTermRefPics poc_lsb_lt(@NativeType(value="uint8_t[STD_VIDEO_H265_MAX_LONG_TERM_PICS]") ByteBuffer value) {
        StdVideoEncodeH265LongTermRefPics.npoc_lsb_lt(this.address(), value);
        return this;
    }

    public StdVideoEncodeH265LongTermRefPics poc_lsb_lt(int index, @NativeType(value="uint8_t") byte value) {
        StdVideoEncodeH265LongTermRefPics.npoc_lsb_lt(this.address(), index, value);
        return this;
    }

    public StdVideoEncodeH265LongTermRefPics used_by_curr_pic_lt_flag(@NativeType(value="uint16_t") short value) {
        StdVideoEncodeH265LongTermRefPics.nused_by_curr_pic_lt_flag(this.address(), value);
        return this;
    }

    public StdVideoEncodeH265LongTermRefPics delta_poc_msb_present_flag(@NativeType(value="uint8_t[STD_VIDEO_H265_MAX_DELTA_POC]") ByteBuffer value) {
        StdVideoEncodeH265LongTermRefPics.ndelta_poc_msb_present_flag(this.address(), value);
        return this;
    }

    public StdVideoEncodeH265LongTermRefPics delta_poc_msb_present_flag(int index, @NativeType(value="uint8_t") byte value) {
        StdVideoEncodeH265LongTermRefPics.ndelta_poc_msb_present_flag(this.address(), index, value);
        return this;
    }

    public StdVideoEncodeH265LongTermRefPics delta_poc_msb_cycle_lt(@NativeType(value="uint8_t[STD_VIDEO_H265_MAX_DELTA_POC]") ByteBuffer value) {
        StdVideoEncodeH265LongTermRefPics.ndelta_poc_msb_cycle_lt(this.address(), value);
        return this;
    }

    public StdVideoEncodeH265LongTermRefPics delta_poc_msb_cycle_lt(int index, @NativeType(value="uint8_t") byte value) {
        StdVideoEncodeH265LongTermRefPics.ndelta_poc_msb_cycle_lt(this.address(), index, value);
        return this;
    }

    public StdVideoEncodeH265LongTermRefPics set(byte num_long_term_sps, byte num_long_term_pics, ByteBuffer lt_idx_sps, ByteBuffer poc_lsb_lt, short used_by_curr_pic_lt_flag, ByteBuffer delta_poc_msb_present_flag, ByteBuffer delta_poc_msb_cycle_lt) {
        this.num_long_term_sps(num_long_term_sps);
        this.num_long_term_pics(num_long_term_pics);
        this.lt_idx_sps(lt_idx_sps);
        this.poc_lsb_lt(poc_lsb_lt);
        this.used_by_curr_pic_lt_flag(used_by_curr_pic_lt_flag);
        this.delta_poc_msb_present_flag(delta_poc_msb_present_flag);
        this.delta_poc_msb_cycle_lt(delta_poc_msb_cycle_lt);
        return this;
    }

    public StdVideoEncodeH265LongTermRefPics set(StdVideoEncodeH265LongTermRefPics src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static StdVideoEncodeH265LongTermRefPics malloc() {
        return new StdVideoEncodeH265LongTermRefPics(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static StdVideoEncodeH265LongTermRefPics calloc() {
        return new StdVideoEncodeH265LongTermRefPics(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static StdVideoEncodeH265LongTermRefPics create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new StdVideoEncodeH265LongTermRefPics(MemoryUtil.memAddress(container), container);
    }

    public static StdVideoEncodeH265LongTermRefPics create(long address) {
        return new StdVideoEncodeH265LongTermRefPics(address, null);
    }

    public static @Nullable StdVideoEncodeH265LongTermRefPics createSafe(long address) {
        return address == 0L ? null : new StdVideoEncodeH265LongTermRefPics(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(StdVideoEncodeH265LongTermRefPics.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = StdVideoEncodeH265LongTermRefPics.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static StdVideoEncodeH265LongTermRefPics malloc(MemoryStack stack) {
        return new StdVideoEncodeH265LongTermRefPics(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static StdVideoEncodeH265LongTermRefPics calloc(MemoryStack stack) {
        return new StdVideoEncodeH265LongTermRefPics(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static byte nnum_long_term_sps(long struct) {
        return MemoryUtil.memGetByte(struct + (long)NUM_LONG_TERM_SPS);
    }

    public static byte nnum_long_term_pics(long struct) {
        return MemoryUtil.memGetByte(struct + (long)NUM_LONG_TERM_PICS);
    }

    public static ByteBuffer nlt_idx_sps(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)LT_IDX_SPS, 32);
    }

    public static byte nlt_idx_sps(long struct, int index) {
        return MemoryUtil.memGetByte(struct + (long)LT_IDX_SPS + Checks.check(index, 32) * 1L);
    }

    public static ByteBuffer npoc_lsb_lt(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)POC_LSB_LT, 16);
    }

    public static byte npoc_lsb_lt(long struct, int index) {
        return MemoryUtil.memGetByte(struct + (long)POC_LSB_LT + Checks.check(index, 16) * 1L);
    }

    public static short nused_by_curr_pic_lt_flag(long struct) {
        return MemoryUtil.memGetShort(struct + (long)USED_BY_CURR_PIC_LT_FLAG);
    }

    public static ByteBuffer ndelta_poc_msb_present_flag(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)DELTA_POC_MSB_PRESENT_FLAG, 48);
    }

    public static byte ndelta_poc_msb_present_flag(long struct, int index) {
        return MemoryUtil.memGetByte(struct + (long)DELTA_POC_MSB_PRESENT_FLAG + Checks.check(index, 48) * 1L);
    }

    public static ByteBuffer ndelta_poc_msb_cycle_lt(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)DELTA_POC_MSB_CYCLE_LT, 48);
    }

    public static byte ndelta_poc_msb_cycle_lt(long struct, int index) {
        return MemoryUtil.memGetByte(struct + (long)DELTA_POC_MSB_CYCLE_LT + Checks.check(index, 48) * 1L);
    }

    public static void nnum_long_term_sps(long struct, byte value) {
        MemoryUtil.memPutByte(struct + (long)NUM_LONG_TERM_SPS, value);
    }

    public static void nnum_long_term_pics(long struct, byte value) {
        MemoryUtil.memPutByte(struct + (long)NUM_LONG_TERM_PICS, value);
    }

    public static void nlt_idx_sps(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 32);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)LT_IDX_SPS, value.remaining() * 1);
    }

    public static void nlt_idx_sps(long struct, int index, byte value) {
        MemoryUtil.memPutByte(struct + (long)LT_IDX_SPS + Checks.check(index, 32) * 1L, value);
    }

    public static void npoc_lsb_lt(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 16);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)POC_LSB_LT, value.remaining() * 1);
    }

    public static void npoc_lsb_lt(long struct, int index, byte value) {
        MemoryUtil.memPutByte(struct + (long)POC_LSB_LT + Checks.check(index, 16) * 1L, value);
    }

    public static void nused_by_curr_pic_lt_flag(long struct, short value) {
        MemoryUtil.memPutShort(struct + (long)USED_BY_CURR_PIC_LT_FLAG, value);
    }

    public static void ndelta_poc_msb_present_flag(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 48);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)DELTA_POC_MSB_PRESENT_FLAG, value.remaining() * 1);
    }

    public static void ndelta_poc_msb_present_flag(long struct, int index, byte value) {
        MemoryUtil.memPutByte(struct + (long)DELTA_POC_MSB_PRESENT_FLAG + Checks.check(index, 48) * 1L, value);
    }

    public static void ndelta_poc_msb_cycle_lt(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 48);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)DELTA_POC_MSB_CYCLE_LT, value.remaining() * 1);
    }

    public static void ndelta_poc_msb_cycle_lt(long struct, int index, byte value) {
        MemoryUtil.memPutByte(struct + (long)DELTA_POC_MSB_CYCLE_LT + Checks.check(index, 48) * 1L, value);
    }

    static {
        Struct.Layout layout = StdVideoEncodeH265LongTermRefPics.__struct(StdVideoEncodeH265LongTermRefPics.__member(1), StdVideoEncodeH265LongTermRefPics.__member(1), StdVideoEncodeH265LongTermRefPics.__array(1, 32), StdVideoEncodeH265LongTermRefPics.__array(1, 16), StdVideoEncodeH265LongTermRefPics.__member(2), StdVideoEncodeH265LongTermRefPics.__array(1, 48), StdVideoEncodeH265LongTermRefPics.__array(1, 48));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        NUM_LONG_TERM_SPS = layout.offsetof(0);
        NUM_LONG_TERM_PICS = layout.offsetof(1);
        LT_IDX_SPS = layout.offsetof(2);
        POC_LSB_LT = layout.offsetof(3);
        USED_BY_CURR_PIC_LT_FLAG = layout.offsetof(4);
        DELTA_POC_MSB_PRESENT_FLAG = layout.offsetof(5);
        DELTA_POC_MSB_CYCLE_LT = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<StdVideoEncodeH265LongTermRefPics, Buffer>
    implements NativeResource {
        private static final StdVideoEncodeH265LongTermRefPics ELEMENT_FACTORY = StdVideoEncodeH265LongTermRefPics.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected StdVideoEncodeH265LongTermRefPics getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint8_t")
        public byte num_long_term_sps() {
            return StdVideoEncodeH265LongTermRefPics.nnum_long_term_sps(this.address());
        }

        @NativeType(value="uint8_t")
        public byte num_long_term_pics() {
            return StdVideoEncodeH265LongTermRefPics.nnum_long_term_pics(this.address());
        }

        @NativeType(value="uint8_t[STD_VIDEO_H265_MAX_LONG_TERM_REF_PICS_SPS]")
        public ByteBuffer lt_idx_sps() {
            return StdVideoEncodeH265LongTermRefPics.nlt_idx_sps(this.address());
        }

        @NativeType(value="uint8_t")
        public byte lt_idx_sps(int index) {
            return StdVideoEncodeH265LongTermRefPics.nlt_idx_sps(this.address(), index);
        }

        @NativeType(value="uint8_t[STD_VIDEO_H265_MAX_LONG_TERM_PICS]")
        public ByteBuffer poc_lsb_lt() {
            return StdVideoEncodeH265LongTermRefPics.npoc_lsb_lt(this.address());
        }

        @NativeType(value="uint8_t")
        public byte poc_lsb_lt(int index) {
            return StdVideoEncodeH265LongTermRefPics.npoc_lsb_lt(this.address(), index);
        }

        @NativeType(value="uint16_t")
        public short used_by_curr_pic_lt_flag() {
            return StdVideoEncodeH265LongTermRefPics.nused_by_curr_pic_lt_flag(this.address());
        }

        @NativeType(value="uint8_t[STD_VIDEO_H265_MAX_DELTA_POC]")
        public ByteBuffer delta_poc_msb_present_flag() {
            return StdVideoEncodeH265LongTermRefPics.ndelta_poc_msb_present_flag(this.address());
        }

        @NativeType(value="uint8_t")
        public byte delta_poc_msb_present_flag(int index) {
            return StdVideoEncodeH265LongTermRefPics.ndelta_poc_msb_present_flag(this.address(), index);
        }

        @NativeType(value="uint8_t[STD_VIDEO_H265_MAX_DELTA_POC]")
        public ByteBuffer delta_poc_msb_cycle_lt() {
            return StdVideoEncodeH265LongTermRefPics.ndelta_poc_msb_cycle_lt(this.address());
        }

        @NativeType(value="uint8_t")
        public byte delta_poc_msb_cycle_lt(int index) {
            return StdVideoEncodeH265LongTermRefPics.ndelta_poc_msb_cycle_lt(this.address(), index);
        }

        public Buffer num_long_term_sps(@NativeType(value="uint8_t") byte value) {
            StdVideoEncodeH265LongTermRefPics.nnum_long_term_sps(this.address(), value);
            return this;
        }

        public Buffer num_long_term_pics(@NativeType(value="uint8_t") byte value) {
            StdVideoEncodeH265LongTermRefPics.nnum_long_term_pics(this.address(), value);
            return this;
        }

        public Buffer lt_idx_sps(@NativeType(value="uint8_t[STD_VIDEO_H265_MAX_LONG_TERM_REF_PICS_SPS]") ByteBuffer value) {
            StdVideoEncodeH265LongTermRefPics.nlt_idx_sps(this.address(), value);
            return this;
        }

        public Buffer lt_idx_sps(int index, @NativeType(value="uint8_t") byte value) {
            StdVideoEncodeH265LongTermRefPics.nlt_idx_sps(this.address(), index, value);
            return this;
        }

        public Buffer poc_lsb_lt(@NativeType(value="uint8_t[STD_VIDEO_H265_MAX_LONG_TERM_PICS]") ByteBuffer value) {
            StdVideoEncodeH265LongTermRefPics.npoc_lsb_lt(this.address(), value);
            return this;
        }

        public Buffer poc_lsb_lt(int index, @NativeType(value="uint8_t") byte value) {
            StdVideoEncodeH265LongTermRefPics.npoc_lsb_lt(this.address(), index, value);
            return this;
        }

        public Buffer used_by_curr_pic_lt_flag(@NativeType(value="uint16_t") short value) {
            StdVideoEncodeH265LongTermRefPics.nused_by_curr_pic_lt_flag(this.address(), value);
            return this;
        }

        public Buffer delta_poc_msb_present_flag(@NativeType(value="uint8_t[STD_VIDEO_H265_MAX_DELTA_POC]") ByteBuffer value) {
            StdVideoEncodeH265LongTermRefPics.ndelta_poc_msb_present_flag(this.address(), value);
            return this;
        }

        public Buffer delta_poc_msb_present_flag(int index, @NativeType(value="uint8_t") byte value) {
            StdVideoEncodeH265LongTermRefPics.ndelta_poc_msb_present_flag(this.address(), index, value);
            return this;
        }

        public Buffer delta_poc_msb_cycle_lt(@NativeType(value="uint8_t[STD_VIDEO_H265_MAX_DELTA_POC]") ByteBuffer value) {
            StdVideoEncodeH265LongTermRefPics.ndelta_poc_msb_cycle_lt(this.address(), value);
            return this;
        }

        public Buffer delta_poc_msb_cycle_lt(int index, @NativeType(value="uint8_t") byte value) {
            StdVideoEncodeH265LongTermRefPics.ndelta_poc_msb_cycle_lt(this.address(), index, value);
            return this;
        }
    }
}

