/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.flappybird;

import com.arizotaz.flappybird.decor.FlappyBirdWindowTheme;
import com.arizotaz.flappybird.game.MainProcess;
import com.arizotaz.lotus.Lotus;
import com.arizotaz.lotus.UserSettings;
import com.arizotaz.lotus.managers.WindowManager;
import com.arizotaz.lotus.resources.ICON;
import com.arizotaz.lotus.struc.Process;
import com.arizotaz.lotus.theme.windows98.Windows98WindowTheme;
import com.arizotaz.lotus.ui.elements.Element;
import com.arizotaz.lotus.utils.Fs;
import com.arizotaz.lotus.utils.TextShorts;
import com.arizotaz.lotus.window.Window;
import com.arizotaz.lotus.window.WindowTheme;
import com.arizotaz.lotus.window.diologs.WindowDiolog;
import com.arizotaz.lotus.window.theme.abyss.AbyssWindowTheme;

public class MainWindow
extends Process {
    private Window window;
    private MainProcess main;

    @Override
    public void Start() {
        UserSettings.SetSettingsFile(Fs.FileUnite(Lotus.singleton.FileLocations().AppStorage(), "settings.txt"));
        WindowManager wm = Lotus.singleton.WindowManager();
        this.window = wm.GetWindow(wm.CreateWindow("Flappy Bird", 1280, 720, this.ID()));
        this.window.Init();
        Element.CreateWindowParms();
        this.window.IdleFps(15);
        this.window.LimitFPS(165);
        if (UserSettings.GetBoolean("window.fullscreen")) {
            this.window.SetFullScreen(UserSettings.GetBoolean("window.fullscreen"));
        }
        this.window.Process();
        this.window.RenderObjects().SetColor(40.0f);
        this.window.RenderObjects().DrawRect(0.0f, 0.0f, this.window.CanvasWidth(), this.window.CanvasHeight(), 0.0f);
        this.window.Render(true);
        if (!UserSettings.Exists("window.theme")) {
            UserSettings.SetInt("window.theme", 0);
        }
        switch (UserSettings.GetInt("window.theme")) {
            case 0: {
                this.window.SetTheme(new FlappyBirdWindowTheme(this.window));
                break;
            }
            case 1: {
                this.window.SetTheme(new Windows98WindowTheme(this.window));
                break;
            }
            case 2: {
                this.window.SetTheme(new AbyssWindowTheme(this.window));
            }
        }
        if (!Lotus.singleton.Platform().IsMac()) {
            try {
                this.window.SetIcon("com/arizotaz/flappybird/assets/bird.png");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.main = new MainProcess(this.window);
    }

    @Override
    public void Update() {
        Element.Reset();
        this.window.TextureEngine().Update();
        this.window.AudioManager().Update();
        this.window.Process();
        if (this.window.drawToWindow > 0) {
            this.window.RenderObjects().SetColor(40.0f);
            this.window.RenderObjects().DrawRect(0.0f, 0.0f, this.window.CanvasWidth(), this.window.CanvasHeight(), 0.0f);
        }
        this.main.Update();
        this.main.Render();
        this.main.Events();
        this.window.Render(this.main.ElementRenderer().HasChanged());
        if (this.window.WantsToClose()) {
            this.QuitProcess();
        }
    }

    @Override
    public void Exit() {
        this.main.Exit();
        this.window.CleanUp();
    }

    @Override
    public void Exception(Exception e) {
        super.Exception(e);
        WindowTheme theme = null;
        try {
            theme = this.window.GetTheme();
        }
        catch (Exception exception) {
            // empty catch block
        }
        WindowDiolog.Message("Exception", TextShorts.StackTraceToString(e), ICON.Texture("icon.warn"), theme);
    }

    @Override
    public void IllegalError(Error e) {
        super.IllegalError(e);
        WindowTheme theme = null;
        try {
            theme = this.window.GetTheme();
        }
        catch (Exception exception) {
            // empty catch block
        }
        WindowDiolog.Message("Illegal Error", TextShorts.StackTraceToString(e), ICON.Texture("icon.error"), theme);
    }
}

