/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.flappybird.game;

import com.arizotaz.flappybird.game.Bird;
import com.arizotaz.flappybird.game.Game;
import com.arizotaz.flappybird.game.MainProcess;
import com.arizotaz.gameacc.BoxCollider2D;
import com.arizotaz.lotus.Lotus;
import com.arizotaz.lotus.window.Window;

public class Pipe {
    private MainProcess process;
    private Game game;
    private Window window;
    private BoxCollider2D good;
    private BoxCollider2D topPipe;
    private BoxCollider2D bottomPipe;
    private Bird bird;
    private boolean collected = false;
    private float pipeSpeed = 1.0f;
    private float x;
    private float y;
    private float mouthSize = 0.0f;

    public Pipe(MainProcess process, float x, float y, float mouthSize) {
        this.process = process;
        this.window = Lotus.singleton.WindowManager().GetCurrentWindow();
        this.game = process.Game();
        this.bird = this.game.Bird();
        this.x = x;
        this.y = y;
        this.mouthSize = mouthSize;
    }

    public void Tick() {
        float pipeWidth = 2.0f;
        float pipeHeight = 10.0f;
        this.topPipe = new BoxCollider2D(this.x - this.game.xDistance(), this.y + this.mouthSize / 2.0f + pipeHeight / 2.0f, pipeWidth, pipeHeight);
        this.bottomPipe = new BoxCollider2D(this.x - this.game.xDistance(), this.y - this.mouthSize / 2.0f - pipeHeight / 2.0f, pipeWidth, pipeHeight);
        this.good = new BoxCollider2D(this.x - this.game.xDistance(), this.y, pipeWidth, this.mouthSize);
        if (this.topPipe.IsColliding(this.bird.Collider()) || this.bottomPipe.IsColliding(this.bird.Collider())) {
            this.game.Lose();
        }
        if (this.good.IsColliding(this.bird.Collider()) && !this.collected) {
            this.collected = true;
            this.game.AddPoint();
        }
    }

    public void Render() {
        float pipeWidth = 2.0f;
        float pipeHeight = 10.0f;
        this.window.RenderObjects().SetColor(255.0f);
        this.window.RenderObjects().DrawImage("pipe", (this.x - this.game.xDistance()) * this.game.RenderScale(), (this.y + pipeHeight / 2.0f + this.mouthSize / 2.0f) * this.game.RenderScale(), pipeWidth * this.game.RenderScale(), pipeHeight * this.game.RenderScale(), 180.0f, true);
        this.window.RenderObjects().DrawImage("pipe", (this.x - this.game.xDistance()) * this.game.RenderScale(), (this.y - pipeHeight / 2.0f - this.mouthSize / 2.0f) * this.game.RenderScale(), pipeWidth * this.game.RenderScale(), pipeHeight * this.game.RenderScale(), 0.0f, true);
    }

    public boolean HasPast() {
        return this.x - this.game.xDistance() < -3.0f;
    }
}

