/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.flappybird.menus;

import com.arizotaz.flappybird.game.Game;
import com.arizotaz.flappybird.game.MainProcess;
import com.arizotaz.lotus.Lotus;
import com.arizotaz.lotus.Text;
import com.arizotaz.lotus.UserSettings;
import com.arizotaz.lotus.texture.Texture;
import com.arizotaz.lotus.ui.Menu;
import com.arizotaz.lotus.ui.elements.Button;
import com.arizotaz.lotus.ui.elements.Element;
import com.arizotaz.lotus.ui.elements.ElementRenderer;
import com.arizotaz.lotus.ui.elements.TextDisplay;
import com.arizotaz.lotus.window.Window;

public class LoseMenu
extends Menu {
    Window window;
    MainProcess process;
    ElementRenderer elm;
    Game game;
    Button mainMenu;
    int highscore;

    public LoseMenu(MainProcess process) {
        this.process = process;
    }

    @Override
    public void Open() {
        this.window = Lotus.singleton.WindowManager().GetCurrentWindow();
        this.elm = this.process.ElementRenderer();
        this.game = this.process.Game();
        this.highscore = UserSettings.GetInt("highscore");
        this.CreatePage();
    }

    @Override
    public void Update() {
        if (this.window.SizeChanged()) {
            this.CreatePage();
        }
    }

    @Override
    public void Render() {
        Texture tex = this.window.TextureEngine().GetTexture("background");
        if (tex != null && tex.GLCreated()) {
            float ratio = (float)tex.Width() / (float)tex.Height();
            this.window.RenderObjects().SetColor(255.0f);
            this.window.RenderObjects().DrawImage("background", 0.0f, 0.0f, this.window.CanvasHeight() * ratio, this.window.CanvasHeight(), 0.0f);
        } else {
            this.window.RenderObjects().DrawImage("background", 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        }
    }

    @Override
    public void Events() {
        if (this.mainMenu.Clicked()) {
            this.menuManager.GoTo(0L);
            this.menuManager.ClearHistory();
        }
    }

    @Override
    public void Leave() {
    }

    public void CreatePage() {
        this.elm.ClearCycle();
        float renderScale = this.window.CanvasWidth() / 30.0f;
        Text text = new Text("Your bird died a horrible death");
        text.SetFont(MainProcess.mainFont);
        text.Align(1, 2);
        text.MaxWidth(this.window.CanvasWidth());
        text.Color(255);
        text.FontSize(renderScale);
        this.elm.AddElement(new TextDisplay(text, 0.0f, renderScale));
        text = new Text("Score: " + this.game.Points());
        text.SetFont(MainProcess.mainFont);
        text.Align(1, 2);
        text.Color(255);
        text.FontSize(renderScale / 2.0f);
        this.elm.AddElement(new TextDisplay(text, 0.0f, renderScale / 4.0f));
        text = new Text("Highscore: " + this.highscore);
        text.SetFont(MainProcess.mainFont);
        text.Align(1, 2);
        text.Color(255);
        text.FontSize(renderScale / 2.0f);
        this.elm.AddElement(new TextDisplay(text, 0.0f, -renderScale / 4.0f));
        this.mainMenu = Element.Button();
        this.mainMenu.Set("Back to main menu", 0.0f, -renderScale, renderScale * 10.0f, renderScale / 1.5f);
        this.elm.AddElement(this.mainMenu);
    }
}

