/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.flappybird.menus;

import com.arizotaz.flappybird.decor.FlappyBirdWindowTheme;
import com.arizotaz.flappybird.game.MainProcess;
import com.arizotaz.lotus.Lotus;
import com.arizotaz.lotus.Text;
import com.arizotaz.lotus.UserSettings;
import com.arizotaz.lotus.texture.Texture;
import com.arizotaz.lotus.theme.windows98.Windows98WindowTheme;
import com.arizotaz.lotus.ui.Menu;
import com.arizotaz.lotus.ui.elements.Button;
import com.arizotaz.lotus.ui.elements.Element;
import com.arizotaz.lotus.ui.elements.ElementRenderer;
import com.arizotaz.lotus.ui.elements.Panel;
import com.arizotaz.lotus.ui.elements.TextDisplay;
import com.arizotaz.lotus.window.Window;

public class MainMenu
extends Menu {
    private Window window;
    private MainProcess process;
    private ElementRenderer elm;
    private Button startButton;
    private Button optionsButton;
    private Button infoButton;
    private Button quitButton;
    private boolean showOptions = false;
    private float pageScale = 0.0f;
    private Button basicTheme;
    private Button win98Theme;
    private Button closeOptions;

    public MainMenu(MainProcess process) {
        this.process = process;
    }

    @Override
    public void Open() {
        this.window = Lotus.singleton.WindowManager().GetCurrentWindow();
        this.elm = this.process.ElementRenderer();
        this.CreatePage();
    }

    private void CreatePage() {
        this.pageScale = this.window.CanvasWidth() / 30.0f;
        this.elm.ClearCycle();
        Text text = new Text("Flappy Bird");
        text.SetFont(MainProcess.mainFont);
        text.Align(1, 2);
        text.MaxWidth(this.window.CanvasWidth());
        text.Color(255);
        text.FontSize(this.pageScale * 2.0f);
        this.elm.AddElement(new TextDisplay(text, 0.0f, this.pageScale));
        float bw = 8.0f;
        float bh = 1.0f;
        float padding = 0.5f * this.pageScale;
        this.startButton = Element.Button();
        this.startButton.Set("Start Game", 0.0f, 0.0f, this.pageScale * bw, this.pageScale * bh);
        this.elm.AddElement(this.startButton);
        this.optionsButton = Element.Button();
        this.optionsButton.Set("Options", 0.0f, -this.pageScale * bh - padding, this.pageScale * bw, this.pageScale * bh);
        this.elm.AddElement(this.optionsButton);
        this.infoButton = Element.Button();
        this.infoButton.Set("Info", 0.0f, (-this.pageScale * bh - padding) * 2.0f, this.pageScale * bw, this.pageScale * bh);
        this.elm.AddElement(this.infoButton);
        this.quitButton = Element.Button();
        this.quitButton.Set("Quit", 0.0f, (-this.pageScale * bh - padding) * 3.0f, this.pageScale * bw, this.pageScale * bh);
        this.elm.AddElement(this.quitButton);
        if (this.showOptions) {
            this.CreateOptionsPage();
        }
    }

    public void CreateOptionsPage() {
        this.elm.AddElement(new Panel(0.0f, 0.0f, this.window.CanvasWidth(), this.window.CanvasHeight(), 0.0f, 0, 140));
        Text text = new Text("Window Theme");
        text.SetFont(MainProcess.mainFont);
        text.Align(1, 2);
        text.MaxWidth(this.window.CanvasWidth());
        text.Color(255);
        text.FontSize(this.pageScale);
        this.elm.AddElement(new TextDisplay(text, 0.0f, this.pageScale));
        float bw = this.pageScale * 10.0f;
        float bh = this.pageScale / 1.5f;
        this.basicTheme = Element.Button();
        this.win98Theme = Element.Button();
        if (!Lotus.singleton.Platform().IsMac()) {
            this.basicTheme.Set("Basic", -bw / 2.0f, 0.0f, bw, bh);
            this.win98Theme.Set("Windows 98", bw / 2.0f, 0.0f, bw, bh);
            this.elm.AddElement(this.basicTheme);
            this.elm.AddElement(this.win98Theme);
        } else {
            this.basicTheme.Set("Basic", 0.0f, 0.0f, bw, bh);
            this.elm.AddElement(this.basicTheme);
        }
        bh = this.pageScale / 2.0f;
        this.closeOptions = Element.Button();
        this.closeOptions.Set("Close", 0.0f, -this.window.CanvasHeight() / 2.0f + bh / 2.0f, this.window.CanvasWidth(), bh);
        this.elm.AddElement(this.closeOptions);
    }

    @Override
    public void Update() {
        if (this.window.SizeChanged()) {
            this.CreatePage();
        }
    }

    @Override
    public void Render() {
        Texture tex = this.window.TextureEngine().GetTexture("background");
        if (tex != null && tex.GLCreated()) {
            float ratio = (float)tex.Width() / (float)tex.Height();
            this.window.RenderObjects().SetColor(255.0f);
            this.window.RenderObjects().DrawImage("background", 0.0f, 0.0f, this.window.CanvasHeight() * ratio, this.window.CanvasHeight(), 0.0f);
        } else {
            this.window.RenderObjects().DrawImage("background", 0.0f, 0.0f, 1.0f, 1.0f, 0.0f);
        }
    }

    @Override
    public void Events() {
        if (this.showOptions) {
            if (this.basicTheme.Clicked()) {
                this.window.Translate().Set(0.0, 0.0);
                this.window.RenderOffset().Set(0.0, 0.0);
                this.window.SetWindowSize((int)this.window.Width(), (int)this.window.Height() - 50);
                this.window.SetTheme(new FlappyBirdWindowTheme(this.window));
                this.CreatePage();
                UserSettings.SetInt("window.theme", 0);
            }
            if (this.win98Theme.Clicked()) {
                this.window.SetWindowSize((int)this.window.Width(), (int)this.window.Height() + 50);
                this.window.SetTheme(new Windows98WindowTheme(this.window));
                this.CreatePage();
                UserSettings.SetInt("window.theme", 1);
            }
            if (this.closeOptions.Clicked()) {
                this.ToggleOptionsMenu();
            }
        }
        if (this.startButton.Clicked()) {
            this.menuManager.GoTo(10L);
        }
        if (this.optionsButton.Clicked()) {
            this.ToggleOptionsMenu();
        }
        if (this.infoButton.Clicked()) {
            this.menuManager.GoTo(20L);
        }
        if (this.quitButton.Clicked()) {
            Lotus.singleton.ProcessManager().GetCurrentProces().QuitProcess();
        }
    }

    private void ToggleOptionsMenu() {
        this.showOptions = !this.showOptions;
        this.CreatePage();
    }

    @Override
    public void Leave() {
    }
}

