/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.gameacc;

import com.arizotaz.lotus.utils.Fs;
import com.arizotaz.lotus.window.KeyboardInput;
import com.arizotaz.lotus.window.Window;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class KeyManager {
    private Window window;
    private KeyboardInput kbi;
    private HashMap<String, ArrayList<Integer>> keyBinds;

    public KeyManager(Window window) {
        this.window = window;
        this.kbi = this.window.KeyboardInput();
        this.keyBinds = new HashMap();
    }

    public boolean RegisterKey(String id, int key) {
        this.CreateList(id);
        return this.AddKeyToList(id, key);
    }

    public boolean RevokeKey(String id, int key) {
        if (this.ListExists(id) && this.ListContainsKey(id, key)) {
            boolean val = false;
            ArrayList<Integer> list = this.GetList(id);
            int i = 0;
            while (i < list.size()) {
                int k = list.get(i);
                if (k == key) {
                    list.remove(i);
                    val = true;
                    continue;
                }
                ++i;
            }
            return val;
        }
        return false;
    }

    public void SaveToFile(File file) {
        String txt = "";
        for (Map.Entry<String, ArrayList<Integer>> me : this.keyBinds.entrySet()) {
            String id = me.getKey();
            String value = "";
            ArrayList<Integer> list = this.GetList(id);
            int i = 0;
            while (i < list.size()) {
                value = String.valueOf(value) + list.get(i);
                if (i < list.size() - 1) {
                    value = String.valueOf(value) + ",";
                }
                ++i;
            }
            String lineItem = String.valueOf(id) + "=" + value + "\n";
            txt = String.valueOf(txt) + lineItem;
        }
        Fs.WriteText(file, txt);
    }

    public void LoadFromFile(File file) {
        String fileData = Fs.ReadText(file);
        String[] lines = fileData.split("\n");
        int l = 0;
        while (l < lines.length) {
            String line = lines[l];
            String id = line.split("=")[0];
            String value = line.split("=")[1];
            String[] keys = value.split(",");
            int k = 0;
            while (k < keys.length) {
                this.RegisterKey(id, Integer.parseInt(keys[k]));
                ++k;
            }
            ++l;
        }
    }

    public void ClearList() {
        this.keyBinds = new HashMap();
    }

    public boolean KeyDown(String id) {
        if (this.ListExists(id)) {
            ArrayList<Integer> list = this.GetList(id);
            boolean val = false;
            int i = 0;
            while (i < list.size()) {
                int key = list.get(i);
                if (this.kbi.IsKeyDown(key)) {
                    val = true;
                }
                ++i;
            }
            return val;
        }
        return false;
    }

    public boolean KeyPressed(String id) {
        if (this.ListExists(id)) {
            ArrayList<Integer> list = this.GetList(id);
            boolean val = false;
            int i = 0;
            while (i < list.size()) {
                int key = list.get(i);
                if (this.kbi.IsPressed(key)) {
                    val = true;
                }
                ++i;
            }
            return val;
        }
        return false;
    }

    private boolean ListContainsKey(String id, int key) {
        return this.GetList(id).contains(key);
    }

    private boolean AddKeyToList(String id, int key) {
        if (!this.ListContainsKey(id, key)) {
            this.GetList(id).add(key);
            return true;
        }
        return false;
    }

    private ArrayList<Integer> GetList(String id) {
        return this.keyBinds.get(id);
    }

    private boolean ListExists(String id) {
        return this.GetList(id) != null;
    }

    private void CreateList(String id) {
        if (!this.ListExists(id)) {
            this.keyBinds.put(id, new ArrayList());
        }
    }
}

