/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.lotus;

import com.arizotaz.lotus.Lotus;
import com.arizotaz.lotus.OSPlatform;
import com.arizotaz.lotus.utils.Fs;
import com.arizotaz.lotus.utils.Tools;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Optional;

public class FileDirs {
    private OSPlatform platform = null;
    private boolean readOnlyRoot = false;
    private File userHome;
    private File systemAppData;
    private File userDesktop;
    private File userDocuments;
    private File userPictures;
    private File tmpLocation;
    private File textureCache;
    private File engineFolder;
    private File engineRepoFolder;
    private File appLocation = new File("").getAbsoluteFile();
    private File resourcesFolder = new File(this.appLocation.getAbsolutePath());
    private File engineDataFolder;
    private File applicDataFolder;
    private File localStorage;

    public FileDirs() {
        File execDir;
        Optional<String> execPath;
        if (Lotus.singleton.Platform().IsMac() && (execPath = ProcessHandle.current().info().command()).isPresent() && (execDir = new File(execPath.get())).getAbsolutePath().contains(".app/")) {
            this.appLocation = execDir.getAbsoluteFile();
            String resourcesPath = execPath.get().replaceAll("Contents/MacOS/.*$", "Contents/Resources");
            this.resourcesFolder = new File(resourcesPath);
        }
        this.TestReadOnlyRoot();
        this.userHome = new File(System.getProperty("user.home")).getAbsoluteFile();
        this.platform = Lotus.singleton.Platform();
        this.systemAppData = new File(this.appLocation.getAbsolutePath() + "/AppData");
        if (this.platform.IsWindows()) {
            this.systemAppData = new File(System.getProperty("user.home") + "/AppData/Roaming");
        }
        if (this.platform.IsMac()) {
            this.systemAppData = new File(System.getProperty("user.home") + "/Library/Application Support");
        }
        if (this.platform.IsLinux()) {
            this.systemAppData = new File(System.getProperty("user.home") + "/.appData/");
        }
        this.engineFolder = new File(this.systemAppData.getAbsolutePath() + "/Lotus");
        this.engineRepoFolder = new File(this.engineFolder.getAbsolutePath() + "/app");
        this.engineDataFolder = new File(this.engineRepoFolder.getAbsolutePath() + "/" + Lotus.singleton.AppInfo().ID());
        this.SetAppDataLocation(new File(this.engineDataFolder.getAbsolutePath()));
        this.SetUserFolders();
    }

    public void CreateDirs() {
        this.engineDataFolder.mkdirs();
        this.applicDataFolder.mkdirs();
        this.textureCache.mkdirs();
        this.tmpLocation.mkdirs();
    }

    public void SetAppDataLocation(File file) {
        this.applicDataFolder = file;
        this.textureCache = Fs.FileUnite(this.applicDataFolder, "TCache");
        this.tmpLocation = Fs.FileUnite(this.applicDataFolder, "tmp");
        this.localStorage = this.readOnlyRoot ? this.AppStorage() : this.ExecutableDirectory();
        this.CreateDirs();
    }

    public File ExecutableDirectory() {
        return this.appLocation;
    }

    public File ResourcesFolder() {
        return this.resourcesFolder;
    }

    public File LocalStorage() {
        return this.localStorage;
    }

    public File AppStorage() {
        return this.applicDataFolder;
    }

    public File UserHome() {
        return this.userHome;
    }

    public File SystemAppData() {
        return this.systemAppData;
    }

    public File TempDir() {
        return this.tmpLocation;
    }

    public File TextureCache() {
        return this.textureCache;
    }

    public File EngineFolder() {
        return this.engineFolder;
    }

    public File EngineRepoFolder() {
        return this.engineRepoFolder;
    }

    public File EngineDataLocation() {
        return this.engineDataFolder;
    }

    public File Desktop() {
        return this.userDesktop;
    }

    public File Documents() {
        return this.userDocuments;
    }

    public File Pictures() {
        return this.userPictures;
    }

    public void SetUserFolders() {
        BufferedReader reader;
        Process process;
        this.userDesktop = new File(System.getProperty("user.home") + "/Desktop/");
        this.userDocuments = new File(System.getProperty("user.home") + "/Documents/");
        this.userPictures = new File(System.getProperty("user.home") + "/Pictures/");
        if (Lotus.singleton.Platform().IsWindows()) {
            String command = "powershell -command \"[Environment]::GetFolderPath('\"Desktop\"'); [Environment]::GetFolderPath('\"MyDocuments\"'); [Environment]::GetFolderPath('\"MyPictures\"')\"";
            try {
                String line;
                process = Runtime.getRuntime().exec(command);
                reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                Object result = "";
                while ((line = reader.readLine()) != null) {
                    result = (String)result + line + "\n";
                }
                reader.close();
                String[] locs = ((String)result).split("\n");
                this.userDesktop = new File(locs[0]);
                this.userDocuments = new File(locs[1]);
                this.userPictures = new File(locs[2]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.platform.IsMac()) {
            String path;
            ProcessBuilder pb;
            try {
                pb = new ProcessBuilder("osascript", "-e", "get POSIX path of (path to desktop folder)");
                process = pb.start();
                reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                path = reader.readLine();
                process.waitFor();
                this.userDesktop = new File(path);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                pb = new ProcessBuilder("osascript", "-e", "get POSIX path of (path to documents folder)");
                process = pb.start();
                reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                path = reader.readLine();
                process.waitFor();
                this.userDocuments = new File(path);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                pb = new ProcessBuilder("osascript", "-e", "get POSIX path of (path to pictures folder)");
                process = pb.start();
                reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                path = reader.readLine();
                process.waitFor();
                this.userPictures = new File(path);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void TestReadOnlyRoot() {
        try {
            File f = Fs.FileUnite(this.ExecutableDirectory(), Tools.RandomSafeChars(24) + ".tmp");
            String challenge = Tools.RandomSafeChars(128);
            Fs.WriteText(f, challenge);
            this.readOnlyRoot = !Fs.ReadText(f).equals(challenge);
            f.delete();
        }
        catch (Exception e) {
            this.readOnlyRoot = true;
        }
    }

    public boolean ReadOnlyRoot() {
        return this.readOnlyRoot;
    }
}

