/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.lotus;

import com.arizotaz.lotus.Lotus;
import com.arizotaz.lotus.LotusDebug;
import com.arizotaz.lotus.Text;
import com.arizotaz.lotus.texture.TextureEngine;
import com.arizotaz.lotus.utils.FileDownload;
import com.arizotaz.lotus.utils.Fs;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class Font {
    private static Font defaultFont = null;
    private static HashMap<String, Font> fontMap = new HashMap();
    String name = "";
    String texture = "";
    boolean bold = false;
    boolean filter = true;
    float width = 0.0f;
    float height = 0.0f;
    float largestChar = 0.0f;
    HashMap<Character, Char> characters = new HashMap();

    public static Font GetFont(String id) {
        if (fontMap.get(id) != null) {
            return fontMap.get(id);
        }
        return defaultFont;
    }

    public static void SetDefault() {
        Font font = new Font("calibri");
        font.ImportLocal("com/arizotaz/lotus/resources/fonts/calibri.json");
        defaultFont = font;
        Text.defaultFont = "calibri";
    }

    public Font(String name) {
        this.name = name;
        if (this.name.equals("")) {
            this.name = "FONT" + Math.round(Math.random() * 1000000.0);
        }
    }

    public void ImportURL(String URL2) {
        if (!new File(Lotus.singleton.FileLocations().TextureCache().getAbsolutePath() + "/com.arizotaz.font." + this.name + ".json").exists()) {
            try {
                new FileDownload(URL2, new File(Lotus.singleton.FileLocations().TextureCache().getAbsolutePath() + "/com.arizotaz.font." + this.name + ".json")).Start();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.ImportData(Fs.ReadText(new File(Lotus.singleton.FileLocations().TextureCache().getAbsolutePath() + "/com.arizotaz.font." + this.name + ".json")));
    }

    public void ImportLocal(String ioLocation) {
        try {
            String dat = Fs.GetResourceFileAsString(ioLocation);
            this.ImportData(dat);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void ImportFile(File fileLocation) {
        if (fileLocation.exists()) {
            this.ImportData(Fs.ReadText(fileLocation));
        } else {
            LotusDebug.Error("Font at " + String.valueOf(fileLocation) + " does not exist");
        }
    }

    void ImportData(String result) {
        this.largestChar = 0.0f;
        this.width = 0.0f;
        this.height = 0.0f;
        try {
            JSONParser parser = new JSONParser();
            JSONObject json = null;
            json = (JSONObject)parser.parse(result);
            if (json.get("antialias") != null) {
                this.filter = Boolean.parseBoolean(String.valueOf(json.get("antialias")));
            }
            if (json.get("texture").toString().startsWith("http")) {
                TextureEngine.AddURLToGlobalList("lotus.engine.font." + this.name + ".texture", (String)json.get("texture"), this.filter);
                this.texture = "lotus.engine.font." + this.name + ".texture";
            } else {
                boolean outside = json.get("texture").toString().startsWith("./") || json.get("texture").toString().startsWith("/") || json.get("texture").toString().substring(0, 2).contains(":");
                TextureEngine.AddToGlobalList("lotus.engine.font." + this.name + ".texture", json.get("texture").toString(), outside, this.filter);
                this.texture = "lotus.engine.font." + this.name + ".texture";
            }
            this.width = Float.parseFloat(String.valueOf(json.get("width")));
            this.height = Float.parseFloat(String.valueOf(json.get("height")));
            JSONObject characters = (JSONObject)json.get("characters");
            for (String key : characters.keySet()) {
                JSONObject charDat = (JSONObject)characters.get(key);
                Char charObject = new Char(key.toCharArray()[0], Integer.parseInt(String.valueOf(charDat.get("x"))), Integer.parseInt(String.valueOf(charDat.get("y"))), Integer.parseInt(String.valueOf(charDat.get("width"))), Integer.parseInt(String.valueOf(charDat.get("height"))), Integer.parseInt(String.valueOf(charDat.get("originX"))), Integer.parseInt(String.valueOf(charDat.get("originY"))), Integer.parseInt(String.valueOf(charDat.get("advance"))));
                if ((float)Integer.parseInt(String.valueOf(charDat.get("height"))) > this.largestChar) {
                    this.largestChar = Integer.parseInt(String.valueOf(charDat.get("height")));
                }
                this.characters.put(Character.valueOf(key.toCharArray()[0]), charObject);
            }
            fontMap.put(this.name, this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String Name() {
        return this.name;
    }

    public String Texture() {
        return this.texture;
    }

    public Char GetChar(char c) {
        return this.characters.get(Character.valueOf(c));
    }

    public float Width() {
        return this.width;
    }

    public float Height() {
        return this.height;
    }

    public float LargestCharHeight() {
        return this.largestChar;
    }

    public class Char {
        char character;
        int x = 0;
        int y = 0;
        int width = 0;
        int height = 0;
        int originX = 0;
        int originY = 0;
        int advance = 0;

        public Char(char character, int x, int y, int w, int h, int ox, int oy, int ad) {
            this.character = character;
            this.x = x;
            this.y = y;
            this.width = w;
            this.height = h;
            this.originX = ox;
            this.originY = oy;
            this.advance = ad;
        }

        public int x() {
            return this.x;
        }

        public int y() {
            return this.y;
        }

        public int width() {
            return this.width;
        }

        public int height() {
            return this.height;
        }

        public int originX() {
            return this.originX;
        }

        public int originY() {
            return this.originY;
        }

        public int advance() {
            return this.advance;
        }
    }
}

