/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.lotus;

import com.arizotaz.lotus.Lotus;
import com.arizotaz.lotus.texture.TextureEngine;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class OSPlatform {
    private String OS_NAME = System.getProperty("os.name");
    private String ARCH = System.getProperty("os.arch");
    private int platformID = -1;
    private OSType type;

    public OSPlatform() {
        if (this.IsWindows()) {
            if (this.IsX86()) {
                this.type = OSType.Windows_x86_64;
            } else if (this.IsARM64()) {
                this.type = OSType.Windows_Arm64;
            }
        }
        if (this.IsMac()) {
            if (this.IsX86()) {
                this.type = OSType.Mac_OSX_x86_64;
            } else if (this.IsARM64()) {
                this.type = OSType.Mac_OSX_Arm64;
            }
        }
        if (this.IsLinux()) {
            if (this.IsX86()) {
                this.type = OSType.Linux_x86_64;
            } else if (this.IsARM64()) {
                this.type = OSType.Linux_Arm64;
            }
        }
    }

    public boolean IsWindows() {
        return this.OS_NAME.startsWith("Windows");
    }

    public boolean IsMac() {
        return this.OS_NAME.startsWith("Mac");
    }

    public boolean IsLinux() {
        return this.OS_NAME.contains("nix") || this.OS_NAME.contains("nux") || this.OS_NAME.contains("aix");
    }

    public boolean IsX86() {
        return this.ARCH.equals("x86_64");
    }

    public boolean IsARM64() {
        return this.ARCH.equals("aarch64");
    }

    public String LoadDesktopWallpaperAsTexture() {
        if (this.IsWindows()) {
            String loc = Lotus.singleton.FileLocations().SystemAppData().getAbsolutePath() + "/Microsoft/Windows/Themes/TranscodedWallpaper";
            if (new File(loc).exists()) {
                TextureEngine.AddToGlobalList("OS.DESKTOP", loc, true, true);
                return "OS.DESKTOP";
            }
            return "engine.missing";
        }
        return "engine.missing";
    }

    public String OSName() {
        if (this.IsWindows()) {
            return "Windows";
        }
        if (this.IsMac()) {
            return "Mac";
        }
        if (this.IsLinux()) {
            return "Linux";
        }
        return "Unknown OS";
    }

    public String ArchitectureName() {
        if (this.IsARM64()) {
            return "Arm64";
        }
        if (this.IsX86()) {
            return "x86_64";
        }
        return "Unknown Architecture";
    }

    public String OSText() {
        if (this.type == OSType.Mac_OSX_Arm64) {
            return "Mac OS X Apple Silicon";
        }
        if (this.type == OSType.Mac_OSX_Arm64) {
            return "Mac OS X Intel Based";
        }
        return this.OSName() + " " + this.ArchitectureName();
    }

    public static enum OSType {
        Windows_x86_64(0),
        Windows_Arm64(1),
        Mac_OSX_x86_64(2),
        Mac_OSX_Arm64(3),
        Linux_x86_64(4),
        Linux_Arm64(5);

        private int value;
        private static Map map;

        private OSType(int value) {
            this.value = value;
        }

        public static OSType valueOf(int pageType) {
            return (OSType)((Object)map.get(pageType));
        }

        public int getValue() {
            return this.value;
        }

        static {
            map = new HashMap();
            for (OSType pageType : OSType.values()) {
                map.put(pageType.value, pageType);
            }
        }
    }
}

