/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.lotus.audio;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import org.lwjgl.openal.AL10;
import org.lwjgl.stb.STBVorbis;
import org.lwjgl.stb.STBVorbisInfo;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class AudioClip {
    private int bufferId;
    private final List<Integer> activeSources = new ArrayList<Integer>();

    public void loadOgg(String oggFilePath, boolean outsideOfJar) throws IOException {
        ByteBuffer vorbis;
        if (!outsideOfJar) {
            if (!((String)oggFilePath).startsWith("/")) {
                oggFilePath = "/" + (String)oggFilePath;
            }
            vorbis = AudioClip.ioResourceToByteBuffer((String)oggFilePath, 4096);
        } else {
            vorbis = MemoryUtil.memAlloc(Files.readAllBytes(Paths.get((String)oggFilePath, new String[0])).length);
            vorbis.put(Files.readAllBytes(Paths.get((String)oggFilePath, new String[0])));
            vorbis.flip();
        }
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer error = stack.mallocInt(1);
            long decoder = STBVorbis.stb_vorbis_open_memory(vorbis, error, null);
            if (decoder == 0L) {
                throw new RuntimeException("Failed to open OGG stream. Error code: " + error.get(0));
            }
            STBVorbisInfo info = STBVorbisInfo.malloc(stack);
            STBVorbis.stb_vorbis_get_info(decoder, info);
            int channels = info.channels();
            int sampleRate = info.sample_rate();
            int samples = STBVorbis.stb_vorbis_stream_length_in_samples(decoder);
            ShortBuffer pcm = MemoryUtil.memAllocShort(samples * channels);
            STBVorbis.stb_vorbis_get_samples_short_interleaved(decoder, channels, pcm);
            STBVorbis.stb_vorbis_close(decoder);
            this.bufferId = AL10.alGenBuffers();
            int format = channels == 1 ? 4353 : 4355;
            AL10.alBufferData(this.bufferId, format, pcm, sampleRate);
            MemoryUtil.memFree(pcm);
        }
    }

    public void Play(float gain, float pitch) {
        int sourceId = AL10.alGenSources();
        if (AL10.alGetError() != 0 || sourceId == 0) {
            System.err.println("Failed to create OpenAL source \u2014 limit reached?");
            return;
        }
        AL10.alSourcei(sourceId, 4105, this.bufferId);
        AL10.alSourcef(sourceId, 4106, gain);
        AL10.alSourcef(sourceId, 4099, pitch);
        AL10.alSourcePlay(sourceId);
        this.activeSources.add(sourceId);
    }

    public void CleanupFinishedSources() {
        try {
            Iterator<Integer> it = this.activeSources.iterator();
            while (it.hasNext()) {
                int sourceId = it.next();
                int state = AL10.alGetSourcei(sourceId, 4112);
                if (state == 4114) continue;
                AL10.alDeleteSources(sourceId);
                it.remove();
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
    }

    public void CleanupSources() {
        for (int sourceId : this.activeSources) {
            AL10.alSourceStop(sourceId);
            AL10.alDeleteSources(sourceId);
        }
        this.activeSources.clear();
    }

    public void CleanupSound() {
        AL10.alDeleteBuffers(this.bufferId);
    }

    public static ByteBuffer ioResourceToByteBuffer(String resource, int bufferSize) throws IOException {
        ByteBuffer buffer;
        try (InputStream source = AudioClip.class.getResourceAsStream(resource);
             ReadableByteChannel rbc = Channels.newChannel(source);){
            int bytes;
            buffer = MemoryUtil.memAlloc(bufferSize);
            while ((bytes = rbc.read(buffer)) != -1) {
                if (buffer.remaining() != 0) continue;
                buffer = AudioClip.resizeBuffer(buffer, buffer.capacity() * 2);
            }
            buffer.flip();
        }
        return buffer;
    }

    private static ByteBuffer resizeBuffer(ByteBuffer buffer, int newCapacity) {
        ByteBuffer newBuffer = MemoryUtil.memAlloc(newCapacity);
        buffer.flip();
        newBuffer.put(buffer);
        MemoryUtil.memFree(buffer);
        return newBuffer;
    }
}

