/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.lotus.audio;

import com.arizotaz.lotus.Lotus;
import com.arizotaz.lotus.audio.AudioClip;
import com.arizotaz.lotus.window.Window;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import org.lwjgl.openal.AL;
import org.lwjgl.openal.ALC;
import org.lwjgl.openal.ALC10;

public class AudioManager {
    private static long device;
    private static long context;
    private static boolean inited;
    private HashMap<String, AudioEntry> clipList = new HashMap();
    private ArrayList<LoadEntry> loadQueue = new ArrayList();
    private HashMap<String, AudioClip> audioFiles = new HashMap();
    private int cleanID = 0;

    public AudioManager(Lotus singleton, Window window) {
    }

    public static void Init() {
        if (inited) {
            return;
        }
        device = ALC10.alcOpenDevice((ByteBuffer)null);
        if (device == 0L) {
            throw new IllegalStateException("Failed to open OpenAL device");
        }
        context = ALC10.alcCreateContext(device, (IntBuffer)null);
        ALC10.alcMakeContextCurrent(context);
        AL.createCapabilities(ALC.createCapabilities(device));
        inited = true;
    }

    public static void Cleanup() {
        ALC10.alcDestroyContext(context);
        ALC10.alcCloseDevice(device);
    }

    public void Update() {
        String[] audioIDs;
        AudioClip clip;
        if (this.loadQueue.size() > 0) {
            LoadEntry entry = this.loadQueue.get(0);
            clip = new AudioClip();
            AudioManager.Init();
            try {
                clip.loadOgg(entry.Entry().File(), entry.Entry().outsideOfJar);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.audioFiles.put(entry.entry.id, clip);
            if (entry.ShouldPlayOnLoad().booleanValue()) {
                clip.Play(entry.Volume(), entry.Pitch());
            }
            this.loadQueue.remove(0);
        }
        if (this.cleanID >= (audioIDs = this.audioFiles.keySet().toArray(new String[0])).length) {
            this.cleanID = 0;
        } else {
            clip = this.audioFiles.get(audioIDs[this.cleanID]);
            if (clip != null) {
                clip.CleanupFinishedSources();
            }
            ++this.cleanID;
        }
    }

    public void AddAudioFile(String id, String fileLocation, boolean outsideOfJar) {
        this.AddAudioFile(id, 0, fileLocation, outsideOfJar);
    }

    public void AddAudioFile(String id, int channelID, String fileLocation, boolean outsideOfJar) {
        this.clipList.put(id, new AudioEntry(id, channelID, fileLocation, outsideOfJar));
    }

    public void PlaySound(String id, float volume, float pitch) {
        if (this.clipList.get(id) == null) {
            return;
        }
        if (this.audioFiles.get(id) == null) {
            LoadEntry entry = new LoadEntry(this.clipList.get(id));
            entry.PlayWhenDone(volume, pitch);
            this.loadQueue.add(entry);
        } else {
            this.audioFiles.get(id).Play(volume, pitch);
        }
    }

    public void StopSound(String id) {
    }

    public void StopSound(int ChannelID) {
    }

    static {
        inited = false;
    }

    private class LoadEntry {
        private AudioEntry entry;
        private boolean playWhenDone = false;
        private float volume = 1.0f;
        private float pitch = 1.0f;

        public LoadEntry(AudioEntry entry) {
            this.entry = entry;
        }

        public void PlayWhenDone() {
            this.playWhenDone = true;
        }

        public void PlayWhenDone(float volume, float pitch) {
            this.PlayWhenDone();
            this.volume = volume;
            this.pitch = pitch;
        }

        public AudioEntry Entry() {
            return this.entry;
        }

        public Boolean ShouldPlayOnLoad() {
            return this.playWhenDone;
        }

        public float Volume() {
            return this.volume;
        }

        public float Pitch() {
            return this.pitch;
        }
    }

    private class AudioEntry {
        private String id;
        private int channel;
        private String fileLocation;
        private boolean outsideOfJar;

        public AudioEntry(String id, int channelID, String fileLocation, boolean outsideOfJar) {
            this.id = id;
            this.channel = channelID;
            this.fileLocation = fileLocation;
            this.outsideOfJar = outsideOfJar;
        }

        public String ID() {
            return this.id;
        }

        public int Channel() {
            return this.channel;
        }

        public String File() {
            return this.fileLocation;
        }

        public Boolean IsLocatedExternally() {
            return this.outsideOfJar;
        }
    }
}

