/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.lotus.gamepad;

import java.nio.ByteBuffer;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWGamepadState;

public class Controller {
    public static final int Button_A = 0;
    public static final int Button_B = 1;
    public static final int Button_X = 2;
    public static final int Button_Y = 3;
    public static final int Left_Bumper = 4;
    public static final int Right_Bumber = 5;
    public static final int Select = 6;
    public static final int Start = 7;
    public static final int Guide = 8;
    public static final int LeftStick = 9;
    public static final int RightStick = 10;
    public static final int DPad_UP = 11;
    public static final int DPad_RIGHT = 12;
    public static final int DPad_DOWN = 13;
    public static final int DPad_LEFT = 14;
    public static final int LeftJoystick_X = 15;
    public static final int LeftJoystick_Y = 16;
    public static final int RightJoystick_X = 17;
    public static final int RightJoystick_Y = 18;
    public static final int LeftTrigger = 19;
    public static final int RightTrigger = 20;
    private int id;
    private String name;
    private byte[] buttons = new byte[15];
    private float[] axes = new float[6];
    private ByteBuffer buffer;
    private GLFWGamepadState state;

    public Controller(int jid) {
        this.id = jid;
        this.name = GLFW.glfwGetGamepadName(this.id);
        System.out.println(this.name);
        this.buffer = ByteBuffer.allocateDirect(1048);
        this.state = new GLFWGamepadState(this.buffer);
    }

    public void GetStates() {
        int i;
        GLFW.glfwGetGamepadState(this.id, this.state);
        for (i = 0; i < this.buttons.length; ++i) {
            this.buttons[i] = this.state.buttons(i);
        }
        for (i = 0; i < this.axes.length; ++i) {
            this.axes[i] = this.state.axes(i);
        }
    }

    public void Disconnected() {
    }

    public boolean IsAxis(int button) {
        return button >= 15;
    }

    public float Axis(int axis) {
        return this.axes[axis - 15];
    }

    public boolean Button(int button) {
        return this.buttons[button] == 1;
    }

    public float Value(int button) {
        if (this.IsAxis(button)) {
            return this.Axis(button);
        }
        return this.Button(button) ? 1.0f : 0.0f;
    }

    public float LXStick() {
        return this.axes[0];
    }

    public float LYStick() {
        return this.axes[1];
    }

    public float RXStick() {
        return this.axes[2];
    }

    public float RYStick() {
        return this.axes[3];
    }

    public float LTrigger() {
        return this.axes[4];
    }

    public float RTrigger() {
        return this.axes[5];
    }

    public boolean A() {
        return this.buttons[0] == 1;
    }

    public boolean B() {
        return this.buttons[1] == 1;
    }

    public boolean X() {
        return this.buttons[2] == 1;
    }

    public boolean Y() {
        return this.buttons[3] == 1;
    }

    public boolean LBumber() {
        return this.buttons[4] == 1;
    }

    public boolean RBumper() {
        return this.buttons[5] == 1;
    }

    public boolean Select() {
        return this.buttons[6] == 1;
    }

    public boolean Start() {
        return this.buttons[7] == 1;
    }

    public boolean LStick() {
        return this.buttons[9] == 1;
    }

    public boolean RStick() {
        return this.buttons[10] == 1;
    }

    public boolean Up() {
        return this.buttons[11] == 1;
    }

    public boolean Right() {
        return this.buttons[12] == 1;
    }

    public boolean Down() {
        return this.buttons[13] == 1;
    }

    public boolean Left() {
        return this.buttons[14] == 1;
    }
}

