/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.lotus.managers;

import com.arizotaz.lotus.Lotus;
import com.arizotaz.lotus.LotusDebug;
import com.arizotaz.lotus.struc.Process;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;

public class ProcessManager {
    public static boolean inited = false;
    private TreeMap<Integer, Process> processes = new TreeMap();
    private boolean doCleanUp = true;
    private Lotus lotus;
    private Process macOSMainProcess = null;

    public ProcessManager(Lotus lotus) {
        this.lotus = lotus;
        if (inited) {
            lotus.Exit(10940002);
        }
        inited = true;
        LotusDebug.Log("[PROCESSMANAGER] INITED");
    }

    public int AddProcess(Process process) {
        return this.AddProcess(process, false);
    }

    public int AddProcess(Process process, boolean persistent) {
        int id = (int)Math.round(Math.random() * 100000.0);
        try {
            while (this.processes.get(id) != null) {
                id = (int)Math.round(Math.random() * 100000.0);
            }
            this.processes.put(id, process);
            this.processes.get(id).SetID(id);
            if (this.lotus.Platform().IsMac() && this.macOSMainProcess == null) {
                LotusDebug.Log("[PROCESSMANAGER] Registering Main Process as MacOS was detected");
                this.macOSMainProcess = this.processes.get(id);
            } else {
                this.processes.get(id).RunThread();
            }
            LotusDebug.Log("[PROCESSMANAGER] Created new process with id " + id);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(10940101);
        }
        return id;
    }

    public Object StartReturnProcess(Process p) {
        int processID = this.AddProcess(p);
        Process process = this.GetProcessByID(processID);
        while (this.ProcessAlive(processID)) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        Object returnVal = process.ReturnValue();
        process.SetPersistent(false);
        return returnVal;
    }

    public Process GetProcessByID(int id) {
        Process p = null;
        if (this.macOSMainProcess != null && id == this.macOSMainProcess.ID()) {
            return this.macOSMainProcess;
        }
        for (Map.Entry<Integer, Process> me : this.processes.entrySet()) {
            if (me.getValue().ID() != id) continue;
            p = me.getValue();
        }
        return p;
    }

    public Process GetCurrentProces() {
        return this.GetProcessByID(this.lotus.WindowManager().GetCurrentWindow().ParentProcessID());
    }

    public void Update() {
        if (this.doCleanUp) {
            ArrayList<String> names = new ArrayList<String>();
            ArrayList<Integer> ids = new ArrayList<Integer>();
            try {
                for (Map.Entry<Integer, Process> me : this.processes.entrySet()) {
                    Process process = me.getValue();
                    if (process.Persistent() || this.ProcessAlive(process.ID()) || process.ProcessStarted() <= 0L && Lotus.singleton.Running()) continue;
                    LotusDebug.Error("[PMANAGER] ------------- ID:" + process.ID() + " NAME:" + process.ProcessName() + " ALIVE:" + this.ProcessAlive(process.ID()) + " START:" + process.ProcessStarted());
                    ids.add(process.ID());
                    names.add(process.ProcessName());
                }
                for (int i = 0; i < ids.size(); ++i) {
                    this.processes.remove(ids.get(i));
                    LotusDebug.Log("[PROCESSMANAGER] Removed " + (String)names.get(i) + "(PROCESSID:" + String.valueOf(ids.get(i)) + ")");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean ProcessAlive(int id) {
        Process p = this.GetProcessByID(id);
        if (p == this.macOSMainProcess) {
            return this.macOSMainProcess.Running();
        }
        if (p != null) {
            return this.lotus.ThreadManager().IsAlive(p.ThreadID());
        }
        return false;
    }

    public int AliveProcesses() {
        return this.processes.size();
    }

    public void CleanDeadProcesses(boolean clean) {
        this.doCleanUp = clean;
    }

    public int[] Processes() {
        int[] processes = new int[this.AliveProcesses()];
        int index = 0;
        for (Map.Entry<Integer, Process> me : this.processes.entrySet()) {
            processes[index++] = me.getKey();
        }
        return processes;
    }

    public Process MainMacOSXProcess() {
        return this.macOSMainProcess;
    }
}

