/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.lotus.managers;

import com.arizotaz.lotus.Lotus;
import com.arizotaz.lotus.LotusDebug;
import com.arizotaz.lotus.utils.TextShorts;
import com.arizotaz.lotus.window.Window;
import java.io.IOException;
import java.util.ArrayList;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.util.tinyfd.TinyFileDialogs;

public class WindowManager {
    public static boolean inited = false;
    private Window macOSMainWindow = null;
    private Lotus lotus;
    private volatile ArrayList<Window> windows = new ArrayList();

    public WindowManager(Lotus lotus) {
        if (inited) {
            Lotus.singleton.Exit(10940004);
        }
        inited = true;
        this.lotus = lotus;
        LotusDebug.Log("[WINDOWMANAGER] INITED");
    }

    public void Update() {
        int i = 0;
        while (i < this.windows.size()) {
            if (Lotus.singleton.ProcessManager().ProcessAlive(this.windows.get(i).ParentProcessID())) {
                ++i;
                continue;
            }
            this.windows.remove(i);
        }
    }

    public String CreateWindow(String title, int w, int h, int process) {
        boolean yes;
        if (Lotus.singleton.Platform().IsMac() && Lotus.NeedsRelaunchOnMacOS() && (yes = TinyFileDialogs.tinyfd_messageBox("Application Error", "This application was not launched with the -XstartOnFirstThread argument.  Would you like to relaunch the application with this option enabled.", "yesno", "error", true))) {
            try {
                Lotus.RelaunchWithStartOnFirstThread();
            }
            catch (IOException e) {
                e.printStackTrace();
                TinyFileDialogs.tinyfd_messageBox("Launch Error", "The application failed to lauch\n" + TextShorts.StackTraceToString(e), "ok", "error", false);
            }
        }
        Window window = new Window(title, w, h, this.lotus, process);
        this.windows.add(window);
        LotusDebug.Log("[WINDOWMANAGER] Created window with an id of " + window.identifier);
        if (Lotus.singleton.Platform().IsMac()) {
            if (this.macOSMainWindow == null) {
                this.macOSMainWindow = window;
            } else {
                TinyFileDialogs.tinyfd_messageBox("MacOS multi-window support", "Version " + Lotus.singleton.EngineInfo().Version().toString() + " of the Lotus Engine does not have support for multiple windows on MacOS. The application will continue but the window will likely not be created.", "ok", "error", true);
            }
        }
        return window.identifier;
    }

    public Window[] Windows() {
        Window[] wins = new Window[this.windows.size()];
        for (int i = 0; i < wins.length; ++i) {
            wins[i] = this.windows.get(i);
        }
        return wins;
    }

    public Window GetWindow(String identifier) {
        Window win = null;
        for (int i = 0; i < this.windows.size(); ++i) {
            if (!this.windows.get((int)i).identifier.equals(identifier)) continue;
            win = this.windows.get(i);
        }
        return win;
    }

    public Window Get(int i) {
        if (i < this.windows.size()) {
            if (this.windows.get(i) != null) {
                return this.windows.get(i);
            }
            return null;
        }
        return null;
    }

    public Window GetCurrentWindow() {
        return this.GetByGL(GLFW.glfwGetCurrentContext());
    }

    public Window GetByGL(long glfwGetCurrentContext) {
        if (this.macOSMainWindow != null) {
            return this.macOSMainWindow;
        }
        Window win = null;
        for (int i = 0; i < this.windows.size(); ++i) {
            if (this.windows.get((int)i).window != glfwGetCurrentContext) continue;
            win = this.windows.get(i);
        }
        return win;
    }
}

