/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.lotus.parseXL;

import com.arizotaz.lotus.parseXL.Cell;
import com.arizotaz.lotus.utils.Tools;
import java.util.ArrayList;

public class ConsoleTable {
    private char vert = (char)9553;
    private char hori = (char)9552;
    private char tright = (char)9559;
    private char tleft = (char)9556;
    private char bright = (char)9565;
    private char bleft = (char)9562;
    private char cross = (char)9580;
    private char leftT = (char)9568;
    private char rightT = (char)9571;
    private char topT = (char)9574;
    private char botT = (char)9577;
    private String borderColor = "\u001b[36m";
    private String textColor = "\u001b[0m";
    private ArrayList<Cell[]> rows;
    private int[] columnWidth = new int[]{20, 20, 8, 3, 8, 10, 3};
    float maxColumnWidth = 30.0f;

    public void SetData(ArrayList<Cell[]> rows) {
        this.rows = rows;
    }

    public void MaxColumnWidth(int size) {
        this.maxColumnWidth = size;
    }

    public void Print() {
        try {
            ArrayList<Cell[]> rows = this.rows;
            this.CalcColumnWidths(rows);
            System.out.print(this.borderColor + this.tleft);
            for (int c = 0; c < this.columnWidth.length; ++c) {
                int size = this.columnWidth[c] + 2;
                for (int i = 0; i < size; ++i) {
                    System.out.print(this.hori);
                }
                if (c < this.columnWidth.length - 1) {
                    System.out.print(this.topT);
                    continue;
                }
                System.out.print(this.tright);
            }
            System.out.print("\n");
            for (int i = 0; i < rows.size(); ++i) {
                this.DrawRow(rows.get(i), i, rows.size());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("\u001b[0m");
    }

    private void DrawRow(Cell[] cells, int row, int length) {
        int maxHeight = this.ResizeCells(cells);
        if (row > 0) {
            maxHeight = (int)Tools.SetSmallest(maxHeight, 2.0f);
        }
        for (int l = 0; l < maxHeight; ++l) {
            System.out.print(this.borderColor + this.vert);
            for (int c = 0; c < cells.length; ++c) {
                String cellVal = cells[c].value;
                String[] cline = cellVal.split("\n");
                if (l < cline.length) {
                    System.out.print(this.textColor + " " + cline[l] + " ");
                    System.out.print(this.borderColor + this.vert);
                    continue;
                }
                int size = this.columnWidth[c] + 2;
                for (int i = 0; i < size; ++i) {
                    System.out.print(" ");
                }
                System.out.print(this.vert);
            }
            System.out.print("\n");
        }
        if (row < length - 1) {
            System.out.print(this.leftT);
            for (c = 0; c < this.columnWidth.length; ++c) {
                size = this.columnWidth[c] + 2;
                for (int i = 0; i < size; ++i) {
                    System.out.print(this.hori);
                }
                if (c < this.columnWidth.length - 1) {
                    System.out.print(this.cross);
                    continue;
                }
                System.out.print(this.rightT);
            }
        } else {
            System.out.print(this.bleft);
            for (c = 0; c < this.columnWidth.length; ++c) {
                size = this.columnWidth[c] + 2;
                for (int i = 0; i < size; ++i) {
                    System.out.print(this.hori);
                }
                if (c < this.columnWidth.length - 1) {
                    System.out.print(this.botT);
                    continue;
                }
                System.out.print(this.bright);
            }
        }
        System.out.print("\n");
    }

    private int ResizeCells(Cell[] cells) {
        int maxHeight = 0;
        for (int i = 0; i < cells.length; ++i) {
            String[] lines = this.ResizeCell(cells[i], i);
            maxHeight = Math.round(Tools.SetSmallest(maxHeight, lines.length));
            Object value = "";
            for (int l = 0; l < lines.length; ++l) {
                String line = lines[l];
                value = (String)value + line;
                if (i >= lines.length) continue;
                value = (String)value + "\n";
            }
            cells[i] = new Cell(value);
        }
        return maxHeight;
    }

    private String[] ResizeCell(Cell cell, int column) {
        Object text = cell.value;
        ArrayList<String> lines = new ArrayList<String>();
        int columnWidth = this.columnWidth[column];
        while (((String)text).length() > columnWidth) {
            String addLine = ((String)text).substring(0, Math.round(Tools.SetLargest(((String)text).length(), columnWidth)));
            lines.add(addLine);
            text = ((String)text).substring(addLine.length(), ((String)text).length());
        }
        while (((String)text).length() < columnWidth) {
            text = (String)text + " ";
        }
        lines.add((String)text);
        String[] rlines = new String[lines.size()];
        for (int i = 0; i < lines.size(); ++i) {
            rlines[i] = (String)lines.get(i);
        }
        return rlines;
    }

    public void CalcColumnWidths(ArrayList<Cell[]> rows) {
        this.columnWidth = new int[rows.get(0).length];
        for (int r = 0; r < rows.size(); ++r) {
            Cell[] row = rows.get(r);
            for (int c = 0; c < row.length; ++c) {
                Cell cell = row[c];
                this.columnWidth[c] = Math.round(Tools.ClampVar(this.columnWidth[c], cell.value.length(), this.maxColumnWidth));
            }
        }
    }
}

