/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.lotus.texture;

import com.arizotaz.lotus.Lotus;
import com.arizotaz.lotus.LotusDebug;
import com.arizotaz.lotus.texture.TextureEngine;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;
import org.lwjgl.stb.STBImage;
import org.lwjgl.system.MemoryStack;

public class Texture {
    private boolean inited = false;
    private boolean glCreated = false;
    private String textureMapID = "";
    private int GL_ID;
    private int width;
    private int height;
    private boolean imported = false;
    private ByteBuffer pixels;
    private boolean smooth = false;
    private String fileName = "";
    private boolean isOutsideOfClass = false;
    private long lastUsed = System.currentTimeMillis();
    private boolean persistent = false;

    public Texture(String textureID) {
        this.textureMapID = textureID;
    }

    public void SetVars(String fileName, boolean isOutsideOfClass, boolean filter) {
        this.fileName = fileName;
        this.isOutsideOfClass = isOutsideOfClass;
        this.smooth = filter;
    }

    public void Init(String fileName, boolean isOutsideOfClass, boolean filter) {
        LotusDebug.Log("[TEXTURE] Loading texture: " + this.textureMapID + " into memory");
        if (!isOutsideOfClass && !((String)fileName).startsWith("/")) {
            fileName = "/" + (String)fileName;
        }
        this.SetVars((String)fileName, isOutsideOfClass, filter);
        try (MemoryStack stack = MemoryStack.stackPush();){
            ByteBuffer imageData;
            IntBuffer x = stack.mallocInt(1);
            IntBuffer y = stack.mallocInt(1);
            IntBuffer comp = stack.mallocInt(1);
            if (isOutsideOfClass) {
                imageData = STBImage.stbi_load((CharSequence)fileName, x, y, comp, 4);
            } else {
                try (InputStream in = Lotus.class.getResourceAsStream((String)fileName);){
                    if (in == null) {
                        throw new RuntimeException("Resource not found: " + (String)fileName);
                    }
                    byte[] imageBytes = in.readAllBytes();
                    ByteBuffer buffer = BufferUtils.createByteBuffer(imageBytes.length);
                    buffer.put(imageBytes);
                    buffer.flip();
                    imageData = STBImage.stbi_load_from_memory(buffer, x, y, comp, 4);
                }
            }
            if (imageData == null) {
                throw new RuntimeException("Failed to load image: " + STBImage.stbi_failure_reason());
            }
            this.width = x.get(0);
            this.height = y.get(0);
            this.pixels = imageData;
            this.inited = true;
            LotusDebug.Log("[TEXTURE." + this.textureMapID + "] Image loaded successfully");
        }
        catch (Exception e) {
            System.err.println("[TEXTURE." + this.textureMapID + "] Failed to load");
            e.printStackTrace();
            TextureEngine.RemoveFromGlobalList(this.textureMapID);
        }
    }

    public void GLGen(ByteBuffer pixels, int width, int height, boolean filter) {
        LotusDebug.Log("[TEXTURE." + this.textureMapID + "] Loading into context");
        this.smooth = filter;
        this.width = width;
        this.height = height;
        this.GL_ID = GL11.glGenTextures();
        GL11.glBindTexture(3553, this.GL_ID);
        GL11.glTexImage2D(3553, 0, 6408, width, height, 0, 6408, 5121, pixels);
        if (this.smooth) {
            LotusDebug.Log("[TEXTURE." + this.textureMapID + "] Bilinear filtering");
            GL30.glGenerateMipmap(3553);
            GL11.glTexParameterf(3553, 10241, 9987.0f);
            GL11.glTexParameterf(3553, 10240, 9728.0f);
        } else {
            LotusDebug.Log("[TEXTURE." + this.textureMapID + "] Nearest Neighbor");
            GL11.glTexParameterf(3553, 10241, 9728.0f);
            GL11.glTexParameterf(3553, 10240, 9728.0f);
        }
        this.glCreated = true;
        LotusDebug.Log("[TEXTURE." + this.textureMapID + "] DONE");
    }

    public void BindToGL() {
        GL11.glBindTexture(3553, this.GL_ID);
        this.lastUsed = System.currentTimeMillis();
    }

    public String ID() {
        return this.textureMapID;
    }

    public ByteBuffer PixelBuffer() {
        return this.pixels;
    }

    public int Width() {
        return this.width;
    }

    public int Height() {
        return this.height;
    }

    public void Destroy() {
        LotusDebug.Log("[TEXTURE." + this.textureMapID + "] DESTROYED");
        this.GLDestroy();
    }

    public void GLDestroy() {
        GL11.glDeleteTextures(this.GL_ID);
    }

    public boolean GLCreated() {
        return this.glCreated;
    }

    public boolean Inited() {
        return this.inited;
    }

    public boolean Filter() {
        return this.smooth;
    }

    public long LastUsed() {
        return this.lastUsed;
    }

    public boolean Persistent() {
        return this.persistent;
    }

    public void SetPersistent(boolean val) {
        this.persistent = val;
    }
}

