/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.lotus.theme.windows98;

import com.arizotaz.lotus.Font;
import com.arizotaz.lotus.Text;
import com.arizotaz.lotus.resources.ICON;
import com.arizotaz.lotus.struc.Vector2;
import com.arizotaz.lotus.struc.Vector4;
import com.arizotaz.lotus.texture.Texture;
import com.arizotaz.lotus.texture.TextureEngine;
import com.arizotaz.lotus.theme.windows98.HorizontalDragBar;
import com.arizotaz.lotus.theme.windows98.VerticalDragBar;
import com.arizotaz.lotus.theme.windows98.Win98ActionDropDown;
import com.arizotaz.lotus.theme.windows98.Win98Button;
import com.arizotaz.lotus.theme.windows98.Win98DropDown;
import com.arizotaz.lotus.theme.windows98.Win98Header;
import com.arizotaz.lotus.theme.windows98.Win98ImageButton;
import com.arizotaz.lotus.theme.windows98.Win98InputBox;
import com.arizotaz.lotus.theme.windows98.Windows98Checkbox;
import com.arizotaz.lotus.ui.elements.Button;
import com.arizotaz.lotus.ui.elements.Element;
import com.arizotaz.lotus.ui.elements.ElementRenderer;
import com.arizotaz.lotus.ui.elements.Image;
import com.arizotaz.lotus.ui.elements.Panel;
import com.arizotaz.lotus.ui.elements.TextDisplay;
import com.arizotaz.lotus.window.Window;
import com.arizotaz.lotus.window.WindowTheme;

public class Windows98WindowTheme
extends WindowTheme {
    private Win98Header winHeader;
    private Vector2 canvas;
    private Vector2 translate;
    private ElementRenderer headerRenderer;
    private HorizontalDragBar leftSide;
    private HorizontalDragBar rightSide;
    private VerticalDragBar topSide;
    private VerticalDragBar bottomSide;
    private boolean lastDragState = false;
    private String lastIconPath = "";
    private Button close;
    private Button maximize;
    private Button minimize;
    int iconLoadFrames = 0;
    float padding;
    float renderScale;
    float headerWidth;
    float headerHeight;
    float headerX = 0.0f;
    float headerY;

    public Windows98WindowTheme(Window window) {
        super(window);
    }

    @Override
    public void Init() {
        this.window.Border(false);
        this.headerRenderer = new ElementRenderer();
        this.winHeader = new Win98Header();
        TextureEngine.AddToGlobalList("window.theme.98.header", "com/arizotaz/lotus/theme/windows98/win98_header.png");
        this.leftSide = new HorizontalDragBar(false);
        this.rightSide = new HorizontalDragBar(true);
        this.bottomSide = new VerticalDragBar(true);
        this.topSide = new VerticalDragBar(false);
        this.SetPrimaryColor(new Vector4(186.0, 186.0, 186.0, 255.0), new Vector4(100.0, 100.0, 100.0, 255.0), new Vector4(0.0, 0.0, 0.0, 255.0));
        this.SetSecondaryColor(new Vector4(0.0, 0.0, 0.0, 255.0), new Vector4(100.0, 100.0, 100.0, 255.0), new Vector4(0.0, 0.0, 0.0, 255.0));
        this.background = new Vector4(192.0, 192.0, 192.0, 255.0);
        this.textColor = new Vector4(0.0, 0.0, 0.0, 255.0);
        Text.dr = this.textColor.IntX();
        Text.dg = this.textColor.IntY();
        Text.db = this.textColor.IntZ();
        Text.da = this.textColor.IntW();
        try {
            this.window.SetIcon("com/arizotaz/lotus/theme/windows98/win98_win.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Font font = new Font("window.theme.98.font");
        font.ImportLocal("com/arizotaz/lotus/resources/fonts/pixels.json");
        this.font = font.Name();
        Element.CreateWindowParms();
        Element.SetDefaultButton(new Win98Button());
        Element.SetDefaultInput(new Win98InputBox());
        Element.SetDefaultDropDown(new Win98DropDown());
        Element.SetDefaultActionDropDown(new Win98ActionDropDown());
        Element.SetDefaultImageButton(new Win98ImageButton());
        Element.SetDefaultCheckbox(new Windows98Checkbox());
        long maxTime = System.currentTimeMillis() + 10000L;
        this.CreateElements();
    }

    @Override
    public void SetupSpace() {
        if (this.window.Border()) {
            this.window.Border(false);
        }
        Element.Reset();
        if (this.window.SizeChanged()) {
            this.CreateElements();
        }
        if (!this.window.IconPath().equals(this.lastIconPath)) {
            this.lastIconPath = this.window.IconPath();
            this.window.TextureEngine().DestroyTexture("window.theme.98.win_" + this.window.window + ".icon");
            TextureEngine.RemoveFromGlobalList("window.theme.98.win_" + this.window.window + ".icon");
            TextureEngine.AddToGlobalList("window.theme.98.win_" + this.window.window + ".icon", this.lastIconPath, false, true);
            this.CreateElements();
        }
        --this.iconLoadFrames;
        Texture tex = this.window.TextureEngine().GetTexture("window.theme.98.win_" + this.window.window + ".icon");
        if (tex == null) {
            this.iconLoadFrames = 60;
        } else if (!tex.GLCreated()) {
            this.iconLoadFrames = 60;
        }
        if (this.iconLoadFrames > 0) {
            --this.iconLoadFrames;
            this.CreateElements();
        }
        if (this.winHeader != null && this.lastDragState != this.winHeader.Drag()) {
            this.lastDragState = this.winHeader.Drag();
            this.CreateElements();
        }
        this.window.RenderOffset().Set(0.0, 0.0);
        this.canvas = new Vector2(this.window.Width(), this.window.Height());
        if (!this.window.NotWindowed()) {
            this.window.RenderOffset().Move(0.0, -this.window.Height() / 2.0f);
            this.window.SetCanvasSize(new Vector2(this.headerWidth, this.headerY - this.padding - this.headerHeight / 2.0f + this.window.Height() / 2.0f));
            this.window.RenderOffset().Move(0.0, this.window.CanvasHeight() / 2.0f + this.padding);
            this.window.SetRenderUnitScale(this.renderScale);
            this.window.Translate().Set(0.0, 0.0);
        }
    }

    @Override
    public void RenderBackground() {
        this.window.RenderObjects().SetColor(255.0f, 0.0f, 0.0f, 255.0f);
        this.window.RenderObjects().DrawRect(0.0f, 0.0f, this.window.CanvasWidth(), this.window.CanvasHeight(), 0.0f);
    }

    @Override
    public void Restore() {
        Element.Reset();
        try {
            this.window.SetCanvasSize(this.canvas);
            this.window.Translate().Set(0.0, 0.0);
            this.window.RenderOffset().Set(0.0, 0.0);
            float renderScale = this.window.RawRenderUnitScale();
            this.window.SetRenderUnitScale(1.0f);
            this.headerRenderer.Update();
            this.headerRenderer.Interact();
            if (this.headerRenderer.HasChanged() || this.window.RenderedOnLastCycle()) {
                this.headerRenderer.Render();
            }
            if (this.headerRenderer.HasChanged()) {
                this.window.ForceWindowDraw();
            }
            if (this.close.Clicked()) {
                this.window.ShouldClose(true);
            }
            if (this.maximize.Clicked()) {
                if (this.window.Maximized()) {
                    this.window.RestoreWindow();
                } else {
                    this.window.Maximize();
                }
            }
            if (this.minimize.Clicked()) {
                this.window.Minimize();
            }
            this.window.SetRenderUnitScale(renderScale);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void RenderForeground() {
    }

    public void CreateElements() {
        this.renderScale = this.window.RawRenderUnitScale();
        this.window.RenderOffset().Set(0.0, 0.0);
        this.headerRenderer.ClearCycle();
        this.window.SetRenderUnitScale(1.0f);
        this.padding = this.window.RenderScale() * 4.0f;
        this.headerRenderer.AddElement(new Panel(0.0f, -this.window.Height() / 2.0f + this.padding / 2.0f, this.window.Width(), this.padding, 0.0f, 192));
        this.headerRenderer.AddElement(new Panel(this.window.Width() / 2.0f - this.padding / 2.0f, 0.0f, this.padding, this.window.Height(), 0.0f, 192));
        this.headerRenderer.AddElement(new Panel(0.0f, this.window.Height() / 2.0f - this.padding / 2.0f, this.window.Width(), this.padding, 0.0f, 192));
        this.headerRenderer.AddElement(new Panel(-this.window.Width() / 2.0f + this.padding / 2.0f, 0.0f, this.padding, this.window.Height(), 0.0f, 192));
        this.headerRenderer.AddElement(new Panel(0.0f, -this.window.Height() / 2.0f, this.window.Width(), this.padding, 0.0f, 100));
        this.headerRenderer.AddElement(new Panel(this.window.Width() / 2.0f, 0.0f, this.padding, this.window.Height(), 0.0f, 100));
        this.headerRenderer.AddElement(new Panel(0.0f, this.window.Height() / 2.0f, this.window.Width(), this.padding, 0.0f, 240));
        this.headerRenderer.AddElement(new Panel(-this.window.Width() / 2.0f, 0.0f, this.padding, this.window.Height(), 0.0f, 240));
        this.headerWidth = this.window.Width() - this.padding * 2.0f;
        this.headerHeight = 20.0f * this.window.RenderScale();
        this.headerX = 0.0f;
        this.headerY = this.window.Height() / 2.0f - this.padding - this.headerHeight / 2.0f;
        if (!this.window.NotWindowed()) {
            this.winHeader.Set(this.headerX, this.headerY, this.headerWidth, this.headerHeight);
            this.headerRenderer.AddElement(this.winHeader);
            if (!this.window.Maximized() && this.window.Resizable() && !this.winHeader.Drag()) {
                this.leftSide.Set(-this.window.CanvasWidth() / 2.0f + 5.0f, 0.0f, 10.0f, this.window.CanvasHeight());
                this.headerRenderer.AddElement(this.leftSide);
                this.rightSide.Set(this.window.CanvasWidth() / 2.0f - 5.0f, 0.0f, 10.0f, this.window.CanvasHeight());
                this.headerRenderer.AddElement(this.rightSide);
                this.topSide.Set(0.0f, this.window.CanvasHeight() / 2.0f - 5.0f, this.window.CanvasWidth(), 10.0f);
                this.headerRenderer.AddElement(this.topSide);
                this.bottomSide.Set(0.0f, -this.window.CanvasHeight() / 2.0f + 5.0f, this.window.CanvasWidth(), 10.0f);
                this.headerRenderer.AddElement(this.bottomSide);
            }
            float imageSize = this.headerHeight - this.padding;
            float imageX = this.headerX - this.headerWidth / 2.0f;
            if (this.window.TextureEngine().GetTexture("window.theme.98.win_" + this.window.window + ".icon") != null) {
                this.headerRenderer.AddElement(new Image("window.theme.98.win_" + this.window.window + ".icon", imageX += this.padding + imageSize / 2.0f, this.headerY, imageSize, imageSize, 0.0f, 255, true));
                imageX += imageSize / 2.0f;
            } else {
                if (this.window.TextureEngine().GetTexture("window.theme.98.win_" + this.window.window + ".icon") != null) {
                    this.window.TextureEngine().LoadFromGlobalList("window.theme.98.win_" + this.window.window + ".icon");
                }
                this.window.RenderObjects().DrawImage("window.theme.98.win_" + this.window.window + ".icon", 0.0f, 0.0f, 1.0f, 1.0f, 0.0f);
            }
            Text headerTitle = new Text(this.window.GetTitle());
            headerTitle.Color(255);
            headerTitle.Align(0, 1);
            headerTitle.FontSize(this.headerHeight - this.padding * 2.0f);
            headerTitle.SetFont(this.Font());
            this.headerRenderer.AddElement(new TextDisplay(headerTitle, imageX + this.padding, this.headerY));
            float buttonSize = this.headerHeight - this.padding;
            this.close = new Win98ImageButton();
            this.close.Set(ICON.Texture("win.close"), this.headerX + this.headerWidth / 2.0f - this.padding - buttonSize / 2.0f, this.headerY, buttonSize, buttonSize);
            this.close.SetFont(this.Font());
            this.close.SetTextColor(0);
            this.headerRenderer.AddElement(this.close);
            this.maximize = new Win98ImageButton();
            this.maximize.Set(ICON.Texture("win.maximize"), this.headerX + this.headerWidth / 2.0f - this.padding - buttonSize / 2.0f - buttonSize - this.padding, this.headerY, buttonSize, buttonSize);
            this.maximize.SetFont(this.Font());
            this.maximize.SetTextColor(0);
            this.headerRenderer.AddElement(this.maximize);
            this.minimize = new Win98ImageButton();
            this.minimize.Set(ICON.Texture("win.minimize"), this.headerX + this.headerWidth / 2.0f - this.padding - buttonSize / 2.0f + (-buttonSize - this.padding) * 2.0f, this.headerY, buttonSize, buttonSize);
            this.minimize.SetFont(this.Font());
            this.minimize.SetTextColor(0);
            this.headerRenderer.AddElement(this.minimize);
        }
    }

    public static float BorderSize(Window window) {
        return 6.0f * window.RenderScale();
    }
}

