/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.lotus.ui;

import com.arizotaz.lotus.Lotus;
import com.arizotaz.lotus.Text;
import com.arizotaz.lotus.managers.WindowManager;
import com.arizotaz.lotus.struc.Contact;
import com.arizotaz.lotus.struc.Process;
import com.arizotaz.lotus.texture.TextureEngine;
import com.arizotaz.lotus.ui.elements.Button;
import com.arizotaz.lotus.ui.elements.Element;
import com.arizotaz.lotus.ui.elements.ElementRenderer;
import com.arizotaz.lotus.ui.elements.Image;
import com.arizotaz.lotus.ui.elements.Panel;
import com.arizotaz.lotus.ui.elements.RoundedPanel;
import com.arizotaz.lotus.ui.elements.TextDisplay;
import com.arizotaz.lotus.utils.Tools;
import com.arizotaz.lotus.utils.Web;
import com.arizotaz.lotus.window.Window;
import java.util.HashMap;
import java.util.Map;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWErrorCallback;

public class ContactView
extends Process {
    Window window;
    Contact contact;
    double lastMouseX = 0.0;
    double lastMouseY = 0.0;
    ElementRenderer elm;

    public ContactView(Contact contact) {
        this.contact = contact;
    }

    @Override
    public void Start() {
        GLFWErrorCallback.createPrint(System.err).set();
        if (!GLFW.glfwInit()) {
            throw new IllegalStateException("Unable to initialize GLFW");
        }
        WindowManager wm = Lotus.singleton.WindowManager();
        this.window = wm.GetWindow(wm.CreateWindow(this.contact.Name(), 800, 300, this.ID()));
        this.window.Init();
        this.window.LimitFPS(60);
        Element.Reset();
        if (TextureEngine.InGlobalList("Contact_" + this.ID())) {
            TextureEngine.RemoveFromGlobalList("Contact_" + this.ID());
        }
        if (this.contact.ContactImageIsUrl()) {
            TextureEngine.AddURLToGlobalList("Contact_" + this.ID(), this.contact.ContactImage(), true);
        } else {
            TextureEngine.AddToGlobalList("Contact_" + this.ID(), this.contact.ContactImage(), false, true);
        }
        if (this.contact.IsBirthday() && !TextureEngine.InGlobalList("contact.partyhat") && !TextureEngine.InGlobalList("contact.partyhat")) {
            TextureEngine.AddToGlobalList("contact.partyhat", "com/arizotaz/lotus/resources/party_hat.png");
        }
        this.elm = new ElementRenderer();
    }

    @Override
    public void Update() {
        float sidePadding = 25.0f * this.window.RenderScale();
        boolean renderWindow = false;
        Element.Reset();
        this.elm.ClearCycle();
        this.window.Process();
        this.window.TextureEngine().Update();
        if (this.window.Mouse().InsideOfWindow()) {
            renderWindow = !this.window.Mouse().InsideOfRenderCanvas();
        }
        this.elm.AddElement(new Panel(0.0f, 0.0f, this.window.CanvasWidth(), this.window.CanvasHeight(), 0.0f, this.window.GetTheme().PrimaryColor_Light()));
        float xIndex = 0.0f;
        float yIndex = 0.0f;
        float iconSize = 400.0f * this.window.RenderScale();
        iconSize = Tools.ClampVar(iconSize, 0.0f, this.window.CanvasHeight() - 100.0f * this.window.RenderScale());
        this.window.Translate().Move(-this.window.CanvasWidth() / 2.0f + sidePadding, 0.0);
        this.elm.AddElement(new RoundedPanel(xIndex += iconSize / 2.0f, 0.0f, iconSize + 15.0f * this.window.RenderScale(), iconSize + 15.0f * this.window.RenderScale(), iconSize / 20.0f, 3, 150));
        this.elm.AddElement(new Panel(xIndex, 0.0f, iconSize, iconSize, 0.0f, 255));
        this.elm.AddElement(new Image("Contact_" + this.ID(), xIndex, 0.0f, iconSize, iconSize, 0.0f, 255));
        if (this.contact.IsBirthday()) {
            this.elm.AddElement(new Image("contact.partyhat", xIndex + iconSize / 2.0f, iconSize / 2.0f, iconSize / 2.5f, iconSize / 2.5f, -45.0f, 255));
        }
        float advance = 0.0f;
        xIndex += iconSize / 2.0f;
        yIndex += iconSize / 2.0f;
        xIndex += 25.0f * this.window.RenderScale();
        Text text = new Text(this.contact.Name());
        text.Align(0, 0);
        text.FontSize(24.0f * this.window.RenderScale());
        text.SetFont(this.window.GetTheme().Font());
        text.Calculate();
        this.elm.AddElement(new TextDisplay(text, xIndex, yIndex));
        yIndex -= text.Height() + 5.0f * this.window.RenderScale();
        advance = Tools.SetSmallest(advance, text.Width());
        text = new Text(this.contact.Username());
        text.Align(0, 0);
        text.FontSize(18.0f * this.window.RenderScale());
        text.SetFont(this.window.GetTheme().Font());
        text.Calculate();
        this.elm.AddElement(new TextDisplay(text, xIndex, yIndex));
        yIndex -= text.Height() + 5.0f * this.window.RenderScale();
        advance = Tools.SetSmallest(advance, text.Width());
        text = new Text("Email: " + this.contact.Email());
        text.Align(0, 0);
        text.FontSize(14.0f * this.window.RenderScale());
        text.SetFont(this.window.GetTheme().Font());
        text.Calculate();
        this.elm.AddElement(new TextDisplay(text, xIndex, yIndex));
        yIndex -= text.Height() + 5.0f * this.window.RenderScale();
        advance = Tools.SetSmallest(advance, text.Width());
        text = new Text("Phone: " + this.contact.Phone());
        text.Align(0, 0);
        text.FontSize(14.0f * this.window.RenderScale());
        text.SetFont(this.window.GetTheme().Font());
        text.Calculate();
        this.elm.AddElement(new TextDisplay(text, xIndex, yIndex));
        yIndex -= text.Height() + 5.0f * this.window.RenderScale();
        advance = Tools.SetSmallest(advance, text.Width());
        text = new Text("Date of birth: " + this.contact.Birthday());
        text.Align(0, 0);
        text.SetFont(this.window.GetTheme().Font());
        text.FontSize(14.0f * this.window.RenderScale());
        text.Calculate();
        this.elm.AddElement(new TextDisplay(text, xIndex, yIndex));
        yIndex -= text.Height() + 5.0f * this.window.RenderScale();
        advance = Tools.SetSmallest(advance, text.Width());
        text = new Text("Age: " + this.contact.Age());
        text.Align(0, 0);
        text.SetFont(this.window.GetTheme().Font());
        text.FontSize(14.0f * this.window.RenderScale());
        text.Calculate();
        this.elm.AddElement(new TextDisplay(text, xIndex, yIndex));
        yIndex -= text.Height() + 5.0f * this.window.RenderScale();
        advance = Tools.SetSmallest(advance, text.Width());
        float linkSize = this.window.CanvasWidth() - (xIndex += advance + this.window.RenderScale() * 20.0f) - sidePadding * 2.0f;
        yIndex = iconSize / 2.0f;
        text = new Text("Links");
        text.Align(1, 0);
        text.FontSize(16.0f * this.window.RenderScale());
        text.SetFont(this.window.GetTheme().Font());
        this.elm.AddElement(new TextDisplay(text, xIndex += linkSize / 2.0f, yIndex));
        yIndex -= text.Height() * 2.0f + 5.0f * this.window.RenderScale();
        HashMap<Button, String> linkButtons = new HashMap<Button, String>();
        HashMap<String, String> links = this.contact.Links();
        for (Map.Entry<String, String> entry : links.entrySet()) {
            Button button = Element.Button();
            button.Set(entry.getKey(), xIndex, yIndex, linkSize, 20.0f * this.window.RenderScale());
            button.SetFont(this.window.GetTheme().Font());
            this.elm.AddElement(button);
            linkButtons.put(button, entry.getValue());
            yIndex -= 20.0f * this.window.RenderScale();
        }
        this.elm.Update();
        this.elm.Interact();
        if (renderWindow || this.elm.HasChanged()) {
            this.lastMouseX = this.window.Mouse().x();
            this.lastMouseY = this.window.Mouse().y();
            this.elm.Render();
            this.window.Render(true);
        }
        for (Map.Entry<String, String> entry : linkButtons.entrySet()) {
            if (!((Button)((Object)entry.getKey())).Clicked()) continue;
            Web.OpenURL(entry.getValue());
        }
        if (this.window.WantsToClose()) {
            this.QuitProcess();
        }
    }

    @Override
    public void Exit() {
    }
}

