/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.lotus.ui;

import com.arizotaz.lotus.ui.Menu;
import com.arizotaz.lotus.ui.defaultMenus.MenuMissing;
import com.arizotaz.lotus.window.Window;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;

public class MenuManager {
    private Window win;
    private TreeMap<Long, Menu> menus;
    private long currentMenu = 0L;
    private long goToMenu = 0L;
    private long lastMenu = -483L;
    private ArrayList<Long> history;

    public MenuManager(Window win) {
        this.win = win;
        this.menus = new TreeMap();
        this.SetMissingMenu(new MenuMissing());
        this.history = new ArrayList();
    }

    public void Update() {
        this.currentMenu = this.goToMenu;
        Menu cm = this.menus.get(this.currentMenu);
        if (cm == null) {
            cm = this.menus.get(-1L);
        }
        if (this.lastMenu != this.currentMenu) {
            Menu lm = this.menus.get(this.lastMenu);
            if (lm != null) {
                lm.Leave();
            }
            this.lastMenu = this.currentMenu;
            cm.Open();
        }
        cm.Update();
    }

    public void Render() {
        Menu cm = this.menus.get(this.currentMenu);
        if (cm == null) {
            cm = this.menus.get(-1L);
        }
        cm.Render();
    }

    public void Events() {
        Menu cm = this.menus.get(this.currentMenu);
        if (cm == null) {
            cm = this.menus.get(-1L);
        }
        cm.Events();
    }

    public void GoTo(long MenuID) {
        this.GoTo(MenuID, true);
    }

    public void GoTo(long MenuID, boolean AddToHistory) {
        this.goToMenu = MenuID;
        if (AddToHistory && this.menus.get(this.lastMenu) != null) {
            this.history.add(0, this.lastMenu);
        }
    }

    public boolean GoBack() {
        if (this.history.size() > 0) {
            Long menuID = this.history.get(0);
            this.history.remove(0);
            this.GoTo(menuID, false);
            return true;
        }
        return false;
    }

    public boolean AddMenu(long MenuID, Menu menu) {
        if (MenuID >= 0L) {
            menu.SetWindow(this.win);
            menu.SetMenuManager(this);
            this.menus.put(MenuID, menu);
            return true;
        }
        return false;
    }

    public Menu GetMenuAtID(long ID) {
        return this.menus.get(ID);
    }

    public boolean RemoveMenu(long MenuID) {
        if (MenuID >= 0L) {
            this.menus.remove(MenuID);
            return true;
        }
        return false;
    }

    public long NumMenus() {
        long n = 0L;
        for (Map.Entry<Long, Menu> menu : this.menus.entrySet()) {
            if (menu.getKey() < 0L) continue;
            ++n;
        }
        return n;
    }

    public long TotalNumMenus() {
        return this.menus.size();
    }

    public long Index() {
        return this.currentMenu;
    }

    public void ClearHistory() {
        this.history.clear();
    }

    public Long GetLastMenu() {
        return this.history.get(0);
    }

    public int HistorySize() {
        return this.history.size();
    }

    public TreeMap<Long, String> List() {
        TreeMap<Long, String> results = new TreeMap<Long, String>();
        for (Map.Entry<Long, Menu> menu : this.menus.entrySet()) {
            results.put(menu.getKey(), menu.getValue().getClass().getCanonicalName());
        }
        return results;
    }

    public void SetMissingMenu(Menu menu) {
        this.menus.put(-1L, menu);
        this.menus.get(-1L).SetWindow(this.win);
        this.menus.get(-1L).SetMenuManager(this);
    }
}

