/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.lotus.ui.elements;

import com.arizotaz.lotus.Lotus;
import com.arizotaz.lotus.struc.Vector2;
import com.arizotaz.lotus.ui.elements.Element;
import com.arizotaz.lotus.window.Window;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;

public class ElementRenderer {
    String currentItemList = "";
    String lastItemList = "";
    float frameChangeDelay = 0.0f;
    boolean changed = false;
    int clearCycle = 0;
    Window window;
    private TreeMap<Float, ArrayList<Element>> elements;

    public ElementRenderer() {
        this.ClearCycle();
    }

    public void ClearCycle() {
        this.elements = new TreeMap();
        this.clearCycle = 2;
    }

    public void AddElement(Element elm) {
        this.AddElement(elm, 0.0f);
    }

    public void AddElement(Element elm, float z) {
        elm.zHeight = z;
        if (this.elements.get(Float.valueOf(elm.zHeight())) == null) {
            this.elements.put(Float.valueOf(elm.zHeight()), new ArrayList());
        }
        this.elements.get(Float.valueOf(elm.zHeight())).add(elm);
    }

    public void Update() {
        if (this.changed || this.frameChangeDelay > 0.0f) {
            this.frameChangeDelay -= 1.0f;
        }
        for (Map.Entry<Float, ArrayList<Element>> Layers : this.elements.entrySet()) {
            ArrayList<Element> elements = Layers.getValue();
            int i = 0;
            while (i < elements.size()) {
                Element elm = elements.get(i);
                elm.Update();
                ++i;
            }
        }
        if (this.clearCycle > 0) {
            --this.clearCycle;
        }
    }

    public void Interact() {
        Object items = "";
        for (float key : this.elements.descendingKeySet()) {
            ArrayList<Element> elements = this.elements.get(Float.valueOf(key));
            int i = elements.size() - 1;
            while (i >= 0) {
                Element elm = elements.get(i);
                elm.Interact();
                items = (String)items + "-" + elm.ObjectIdentifier();
                if (elm.ShouldUpdateScreen()) {
                    items = (String)items + "_FRUP" + Math.round(Math.random() * 10000.0);
                }
                items = (String)items + ";";
                elm.DoNotUpdateScreen();
                --i;
            }
        }
        char[] chars = this.currentItemList.toCharArray();
        this.lastItemList = "";
        int i = 0;
        while (i < chars.length) {
            this.lastItemList = String.valueOf(this.lastItemList) + chars[i];
            ++i;
        }
        this.currentItemList = items;
        if (!this.lastItemList.equals(this.currentItemList) || this.window != null && this.window.TextureEngine().TexturesLoading()) {
            this.changed = true;
            this.frameChangeDelay = 60.0f;
        } else {
            this.changed = false;
        }
    }

    public void Render() {
        this.window = Lotus.singleton.WindowManager().GetCurrentWindow();
        Vector2 t = new Vector2(this.window.Translate().x(), this.window.Translate().y());
        this.window.Translate().Set(0.0, 0.0);
        for (Map.Entry<Float, ArrayList<Element>> Layers : this.elements.entrySet()) {
            ArrayList<Element> elements = Layers.getValue();
            int i = 0;
            while (i < elements.size()) {
                Element elm = elements.get(i);
                elm.Render();
                ++i;
            }
        }
        this.window.Translate().Set(t.x(), t.y());
    }

    public boolean HasChanged() {
        return this.changed || this.frameChangeDelay > 0.0f;
    }

    public void MarkChange() {
        this.changed = true;
        this.frameChangeDelay = 60.0f;
    }

    public boolean IsClearCycle() {
        return this.clearCycle > 0;
    }
}

