/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.lotus.ui.elements;

import com.arizotaz.lotus.Text;
import com.arizotaz.lotus.struc.Vector3;
import com.arizotaz.lotus.struc.Vector4;
import com.arizotaz.lotus.ui.elements.Button;

public class ImageButton
extends Button {
    protected String caption = "";
    protected String capFont = "";
    protected float capSize = 0.0f;
    protected Vector3 capColor = new Vector3(0.0, 0.0, 0.0);
    protected float capMaxWidth = 999999.0f;

    public ImageButton() {
        this.textColor = new Vector4(255.0, 255.0, 255.0, 255.0);
    }

    @Override
    public void Render() {
        float padding = this.window.RenderScale() * (this.height / 15.0f);
        if (!this.IsHovering()) {
            this.window.RenderObjects().SetColor(this.buttonColor.IntX() - 50, this.buttonColor.IntY() - 50, this.buttonColor.IntZ() - 50, this.buttonColor.IntW());
        } else {
            this.window.RenderObjects().SetColor(this.hoverColor.IntX() - 120, this.hoverColor.IntY() - 120, this.hoverColor.IntZ() - 120, this.hoverColor.IntW());
        }
        this.window.RenderObjects().DrawRoundedRect(this.x, this.y, 0.0, this.width, this.height, this.height / 6.0f, 3);
        if (!this.IsHovering()) {
            this.window.RenderObjects().SetColor(this.buttonColor.IntX(), this.buttonColor.IntY(), this.buttonColor.IntZ(), this.buttonColor.IntW());
        } else {
            this.window.RenderObjects().SetColor(this.hoverColor.IntX(), this.hoverColor.IntY(), this.hoverColor.IntZ(), this.hoverColor.IntW());
        }
        this.window.RenderObjects().DrawRoundedRect(this.x, this.y, 0.0, this.width - padding, this.height - padding, this.height / 8.0f, 3);
        this.window.RenderObjects().SetColor(this.textColor.IntX(), this.textColor.IntY(), this.textColor.IntZ(), this.textColor.IntW());
        this.window.RenderObjects().DrawImage(this.text, this.x, this.y, this.width - padding, this.height - padding, 0.0f, true);
        if (!this.caption.equals("")) {
            Text caption = new Text(this.caption);
            caption.Align(1, 0);
            caption.Color(this.capColor);
            caption.MaxWidth(this.capMaxWidth);
            if (this.capSize != 0.0f) {
                caption.FontSize(this.capSize);
            } else {
                caption.FontSize(this.height / 4.0f);
            }
            if (this.capFont.equals("")) {
                caption.SetFont(this.capFont);
            } else {
                caption.SetFont(this.window.GetTheme().Font());
            }
            caption.Render(this.x, this.y - this.height / 2.0f + padding);
        }
    }

    public void Set(String texture, String caption, float x, float y, float w, float h) {
        this.SetCaption(caption);
        this.Set(texture, x, y, w, h);
    }

    public void SetCaption(String caption) {
        this.caption = caption;
    }

    public void CaptionFontSize(float fontSize) {
        this.capSize = fontSize;
    }

    public void CaptionColor(double d, double e, double f) {
        this.capColor = new Vector3(d, e, f);
    }

    public void CaptionColor(Vector3 color) {
        this.CaptionColor(color.x(), color.y(), color.z());
    }

    public void CaptionFont(String font) {
        this.capFont = font;
    }

    public void CaptionMaxWidth(float max) {
        this.capMaxWidth = max;
    }
}

