/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.lotus.ui.elements;

import com.arizotaz.lotus.struc.Vector2;
import com.arizotaz.lotus.struc.Vector3;
import com.arizotaz.lotus.struc.Vector4;
import com.arizotaz.lotus.ui.elements.Element;
import com.arizotaz.lotus.window.Mouse;

public class RoundedPanel
extends Element {
    private int r;
    private int g;
    private int b;
    private int a;
    private float curve = 0.0f;
    private int segs = 0;
    private Mouse mouse;

    public RoundedPanel(float x, float y, float width, float height, float curve, int segs, Vector4 color) {
        this.Set(x, y, width, height, curve, segs, color.IntX(), color.IntY(), color.IntZ(), color.IntW());
    }

    public RoundedPanel(float x, float y, float width, float height, float curve, int segs, Vector3 color) {
        this.Set(x, y, width, height, curve, segs, color.IntX(), color.IntY(), color.IntZ(), 255);
    }

    public RoundedPanel(float x, float y, float width, float height, float curve, int segs, Vector2 color) {
        this.Set(x, y, width, height, curve, segs, color.IntX(), color.IntX(), color.IntX(), color.IntY());
    }

    public RoundedPanel(float x, float y, float width, float height, float curve, int segs, int r, int g, int b, int a) {
        this.Set(x, y, width, height, curve, segs, r, g, b, a);
    }

    public RoundedPanel(float x, float y, float width, float height, float curve, int segs, int r, int a) {
        this.Set(x, y, width, height, curve, segs, r, r, r, a);
    }

    public RoundedPanel(float x, float y, float width, float height, float curve, int segs, int r, int g, int b) {
        this.Set(x, y, width, height, curve, segs, r, g, b, 255);
    }

    public RoundedPanel(float x, float y, float width, float height, float curve, int segs, int r) {
        this.Set(x, y, width, height, curve, segs, r, r, r, 255);
    }

    private void Set(float x, float y, float width, float height, float curve, int segs, int r, int g, int b, int a) {
        this.mouse = this.window.Mouse();
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
        this.curve = curve;
        this.segs = segs;
        this.Set(x, y, width, height);
        this.interactX = this.window.Translate().x() + (double)this.x;
        this.interactY = this.window.Translate().y() + (double)this.y;
    }

    @Override
    public void Update() {
    }

    @Override
    public void Interact() {
        Vector2 t = new Vector2(this.window.Translate().x(), this.window.Translate().y());
        this.window.Translate().Set(0.0, 0.0);
        if (!Element.ShouldStopInteract() && this.mouse.x() < this.interactX + (double)(this.width / 2.0f) && this.mouse.x() > this.interactX - (double)(this.width / 2.0f) && this.mouse.y() > this.interactY - (double)(this.height / 2.0f) && this.mouse.y() < this.interactY + (double)(this.height / 2.0f)) {
            Element.StopInteract();
        }
        this.window.Translate().Set(t.x(), t.y());
    }

    @Override
    public void Render() {
        this.window.RenderObjects().SetColor(this.r, this.g, this.b, this.a);
        this.window.RenderObjects().DrawRoundedRect(this.x, this.y, 0.0, this.width, this.height, this.curve, this.segs);
    }
}

