/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.lotus.utils;

import com.arizotaz.lotus.Lotus;
import com.arizotaz.lotus.utils.Fs;
import com.arizotaz.lotus.utils.Web;
import java.io.File;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class ApplicationRepositoryAPI {
    public static File GetRepoLocationFolder() {
        return new File(Lotus.singleton.FileLocations().SystemAppData().getAbsolutePath() + "/AppRepo");
    }

    public static File GetRepositorysFolder() {
        return new File(ApplicationRepositoryAPI.GetRepoLocationFolder().getAbsolutePath() + "/repo");
    }

    public static String ReadLibraryFile() {
        return Fs.ReadText(new File(ApplicationRepositoryAPI.GetRepositorysFolder().getAbsolutePath() + "/libr.json"));
    }

    public static JSONObject LibraryJson() throws ParseException {
        JSONParser parser = new JSONParser();
        return (JSONObject)parser.parse(ApplicationRepositoryAPI.ReadLibraryFile());
    }

    public static boolean IsAppInstalled(String AppID) {
        try {
            boolean val = false;
            JSONObject obj = ApplicationRepositoryAPI.LibraryJson();
            JSONArray apps = (JSONArray)obj.get("apps");
            for (int i = 0; i < apps.size(); ++i) {
                JSONObject app = (JSONObject)apps.get(i);
                String constructedID = (String)app.get("repo") + ":" + (String)app.get("id");
                if (!constructedID.toLowerCase().equals(AppID.toLowerCase())) continue;
                i = apps.size();
                val = true;
            }
            return val;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static File GetAppLocation(String AppID) {
        String val = ApplicationRepositoryAPI.GetParm(AppID, "folder");
        if (val == null) {
            return null;
        }
        return new File(val);
    }

    public static File GetAppBinLocation(String AppID) {
        String val = ApplicationRepositoryAPI.GetParm(AppID, "bin");
        if (val == null) {
            return null;
        }
        return new File(val);
    }

    public static File GetAppDatLocation(String AppID) {
        String val = ApplicationRepositoryAPI.GetParm(AppID, "data");
        if (val == null) {
            return null;
        }
        return new File(val);
    }

    public static String GetParm(String AppID, String Parameter2) {
        String parm = null;
        try {
            JSONObject obj = ApplicationRepositoryAPI.LibraryJson();
            JSONArray apps = (JSONArray)obj.get("apps");
            for (int i = 0; i < apps.size(); ++i) {
                JSONObject app = (JSONObject)apps.get(i);
                String constructedID = (String)app.get("repo") + ":" + (String)app.get("id");
                if (!constructedID.toLowerCase().equals(AppID.toLowerCase())) continue;
                i = apps.size();
                parm = app.get(Parameter2).toString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return parm;
    }

    public static String[] BreakFullID(String AppID) {
        String[] args = AppID.split(":");
        String repo = args[0];
        String appID = args[1];
        return new String[]{repo, appID};
    }

    public static void LaunchAppApplication(String AppID) {
        String[] dat = ApplicationRepositoryAPI.BreakFullID(AppID);
        Web.OpenURL("com.apprepo.remote://launchpad/run/" + dat[0] + "/" + dat[1]);
    }
}

