/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.lotus.utils;

import com.arizotaz.lotus.Lotus;
import com.arizotaz.lotus.utils.Tools;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UncheckedIOException;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.stream.Collectors;

public class Fs {
    public static File FileUnite(File file, String location) {
        if (!((String)location).startsWith("/")) {
            location = "/" + (String)location;
        }
        return new File(file.getAbsolutePath() + (String)location);
    }

    public static boolean RemoveFolder(File directoryToBeDeleted) {
        File[] allContents;
        boolean fullyDelete = true;
        if (directoryToBeDeleted.isDirectory() && (allContents = directoryToBeDeleted.listFiles()) != null) {
            for (File file : allContents) {
                boolean deleted = Fs.RemoveFolder(file);
                if (!fullyDelete || deleted) continue;
                fullyDelete = false;
            }
        }
        Fs.Remove(directoryToBeDeleted);
        return fullyDelete;
    }

    public static long FolderSize(File directory) {
        return Fs.GetFolderSize(directory);
    }

    public static long GetFolderSize(File directory) {
        long length = 0L;
        try {
            for (File file : directory.listFiles()) {
                if (file.isFile()) {
                    length += file.length();
                    continue;
                }
                if (length > 100000000000L) continue;
                length += Fs.GetFolderSize(file);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return length;
    }

    public static void Remove(File file) {
        file.delete();
    }

    public static void RemoveOnVMClose(File file) {
        file.deleteOnExit();
    }

    public static void WriteObject(File location, Object value) throws FileNotFoundException, IOException {
        Fs.CreateDirsForFile(location);
        File dir = location.getParentFile();
        dir.mkdirs();
        File file = location.getAbsoluteFile();
        ObjectOutputStream outputStream = new ObjectOutputStream(new FileOutputStream(file));
        outputStream.writeObject(value);
        outputStream.close();
    }

    public static Object ReadObject(File location) {
        Object object = null;
        try {
            Object item;
            ObjectInputStream inputStream = new ObjectInputStream(new FileInputStream(location.getAbsoluteFile()));
            object = item = inputStream.readObject();
            inputStream.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return object;
    }

    public static boolean WriteText(File location, String text) {
        try {
            Fs.CreateDirsForFile(location);
            boolean result = false;
            FileWriter myWriter = new FileWriter(location);
            myWriter.write(text);
            myWriter.close();
            result = true;
            return result;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static String ReadText(File location) {
        try {
            String result = "";
            Path path = location.toPath();
            List<String> lines = Files.readAllLines(path, StandardCharsets.UTF_8);
            result = String.join((CharSequence)"\n", lines);
            return result;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static byte[] ReadBytes(File location) {
        try {
            Path path = Paths.get(location.getAbsolutePath(), new String[0]);
            byte[] result = Files.readAllBytes(path);
            return result;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void WriteBytes(File location, byte[] arr) {
        try {
            FileOutputStream outputStream = new FileOutputStream(location);
            outputStream.write(arr);
            outputStream.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static boolean CreateDirsForFile(File location) {
        location = location.getAbsoluteFile();
        File parentDir = location.getParentFile();
        String name = location.getName();
        if (!parentDir.exists()) {
            parentDir.mkdirs();
            return true;
        }
        return false;
    }

    public static String GetResourceFileAsString(String fileName) {
        fileName = "/" + (String)fileName;
        InputStream is = Lotus.class.getResourceAsStream((String)fileName);
        InputStreamReader isr = new InputStreamReader(is);
        BufferedReader reader = new BufferedReader(isr);
        return reader.lines().collect(Collectors.joining(System.lineSeparator()));
    }

    public static byte[] GetResourceFileAsBytes(String fileName) {
        try {
            fileName = "/" + (String)fileName;
            InputStream is = Lotus.class.getResourceAsStream((String)fileName);
            byte[] result = Tools.InputStreamToBytes(is);
            is.close();
            return result;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static String JarLocation() {
        Object jarFolder = String.valueOf(Lotus.singleton.FileLocations().TempDir().getAbsoluteFile()) + "/";
        try {
            jarFolder = new File(Lotus.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath()).getParentFile().getPath().replace('\\', '/');
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return jarFolder;
    }

    public static boolean ExportIOResource(String fileName, String location) {
        fileName = "/" + (String)fileName;
        try {
            Files.copy(Lotus.class.getResourceAsStream((String)fileName), new File(location).toPath(), StandardCopyOption.REPLACE_EXISTING);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static File FindAvailableTempFile() {
        File file = new File(String.valueOf(Lotus.singleton.FileLocations().TempDir().getAbsoluteFile()) + "/" + Tools.RandomSafeChars(24));
        while (file.exists()) {
            file = new File(String.valueOf(Lotus.singleton.FileLocations().TempDir().getAbsoluteFile()) + "/" + Tools.RandomSafeChars(24));
        }
        return file;
    }

    public static String MD5Hash(File file) throws NoSuchAlgorithmException, IOException {
        MessageDigest md5Digest = MessageDigest.getInstance("MD5");
        String checksum = Fs.GetFileChecksum(md5Digest, file);
        return checksum;
    }

    private static String GetFileChecksum(MessageDigest digest, File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        byte[] byteArray = new byte[1024];
        int bytesCount = 0;
        while ((bytesCount = fis.read(byteArray)) != -1) {
            digest.update(byteArray, 0, bytesCount);
        }
        fis.close();
        byte[] bytes = digest.digest();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            sb.append(Integer.toString((bytes[i] & 0xFF) + 256, 16).substring(1));
        }
        return sb.toString();
    }
}

