/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.lotus.utils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;

public class OldPostDownload {
    private float requireBytes = 0.0f;
    private float totalBytes = 0.0f;
    private boolean done = false;
    private String downloadURL;
    private File file;
    private HashMap<String, String> args;

    public OldPostDownload(String downloadURL, File file, HashMap<String, String> args, boolean ManualStart) throws IOException {
        this.downloadURL = downloadURL;
        this.file = file;
        this.args = args;
        if (!ManualStart) {
            this.Start();
        }
    }

    public OldPostDownload(String downloadURL, File file, HashMap<String, String> args) throws IOException {
        this.downloadURL = downloadURL;
        this.file = file;
        this.args = args;
        this.Start();
    }

    public void Start() throws IOException {
        int numBytesRead;
        URL url = new URL(this.downloadURL);
        URLConnection con = url.openConnection();
        HttpURLConnection http = (HttpURLConnection)con;
        http.setRequestMethod("POST");
        http.setDoOutput(true);
        HashMap<String, String> arguments = this.args;
        StringJoiner sj = new StringJoiner("&");
        for (Map.Entry entry : arguments.entrySet()) {
            sj.add(URLEncoder.encode((String)entry.getKey(), "UTF-8") + "=" + URLEncoder.encode((String)entry.getValue(), "UTF-8"));
        }
        byte[] out = sj.toString().getBytes(StandardCharsets.UTF_8);
        int length = out.length;
        http.setFixedLengthStreamingMode(length);
        http.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
        http.connect();
        try (OutputStream os = http.getOutputStream();){
            os.write(out);
        }
        String fileID = String.valueOf((int)Math.round(Math.random() * 1000000.0));
        String tempLocation = this.file.getAbsolutePath() + ".dl";
        while (new File(tempLocation).exists()) {
            fileID = String.valueOf((int)Math.round(Math.random() * 1000000.0));
            tempLocation = this.file.getAbsolutePath() + fileID + ".dl";
        }
        new File(tempLocation).createNewFile();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(http.getInputStream());
        FileOutputStream fileOutputStream = new FileOutputStream(tempLocation);
        float fileSize = http.getContentLength();
        this.requireBytes += fileSize;
        byte[] bucket = new byte[2048];
        while ((numBytesRead = bufferedInputStream.read(bucket, 0, bucket.length)) != -1) {
            fileOutputStream.write(bucket, 0, numBytesRead);
            this.totalBytes += (float)numBytesRead;
        }
        fileOutputStream.close();
        bufferedInputStream.close();
        Path fileToMovePath = Paths.get(tempLocation, new String[0]);
        Path targetPath = Paths.get(this.file.getAbsolutePath(), new String[0]);
        Files.move(fileToMovePath, targetPath, StandardCopyOption.REPLACE_EXISTING);
        this.done = true;
    }

    public float Progress() {
        return this.totalBytes / this.requireBytes;
    }

    public float TotalSize() {
        return this.requireBytes;
    }

    public float CurrentSize() {
        return this.totalBytes;
    }

    public boolean IsDone() {
        return this.done;
    }

    public String URL() {
        return this.downloadURL;
    }

    public File File() {
        return this.file;
    }
}

